/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel.mapeditor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.control.MapEditorController;
import net.sf.freecol.client.gui.DialogHandler;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.client.gui.panel.WrapLayout;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.Area;

public final class ChooseAreaModificationPanel
extends FreeColPanel {
    private static final Logger logger = Logger.getLogger(ChooseAreaModificationPanel.class.getName());
    private final DialogHandler<Area> dialogHandler;

    public ChooseAreaModificationPanel(FreeColClient freeColClient, DialogHandler<Area> dialogHandler) {
        super(freeColClient, null, new MigLayout("fill, wrap 1", "[fill, growprio 150]", "[fill, growprio 150]"));
        this.dialogHandler = dialogHandler;
        JPanel areasPanel = new JPanel(new WrapLayout().withHorizontalAlignment(WrapLayout.HorizontalAlignment.CENTER).withAllComponentsWithTheSameSize(true)){

            @Override
            public Dimension getMinimumSize() {
                return new Dimension(1, 1);
            }
        };
        areasPanel.setOpaque(false);
        MapEditorController ctlr = this.getFreeColClient().getMapEditorController();
        ButtonGroup bg = new ButtonGroup();
        for (Area a : freeColClient.getGame().getAreas()) {
            JPanel areaPanel = new JPanel(new BorderLayout());
            areaPanel.setOpaque(false);
            String title = a.getNameKey() != null ? Messages.message(a.getNameKey()) : a.getName();
            JToggleButton areaButton = new JToggleButton(title);
            areaButton.addActionListener(e -> dialogHandler.handle(a));
            bg.add(areaButton);
            areaPanel.add((Component)areaButton, "North");
            JCheckBox visible = new JCheckBox();
            visible.setSelected(ctlr.isAreaVisible(a));
            visible.setHorizontalAlignment(0);
            visible.addActionListener(e -> {
                ctlr.setAreaVisible(a, visible.isSelected());
                this.getGUI().refresh();
            });
            areaPanel.add((Component)visible, "South");
            areasPanel.add(areaPanel);
        }
        this.add((Component)areasPanel, "grow, shrink");
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setSize(this.getPreferredSize());
    }

    @Override
    public String getFrameTitle() {
        return Messages.message("mapEditor.chooseAreaModificationPanel.title");
    }

    @Override
    public void onFrameClosing() {
        super.onFrameClosing();
        this.getFreeColClient().getMapEditorController().setDisplayAreas(false);
    }
}

