/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.samples.iaik;

import java.io.File;
import java.io.FileInputStream;
import java.security.Key;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.Init;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.samples.SampleUtils;
import org.apache.xml.security.samples.signature.VerifyMerlinsExamplesFifteen;
import org.apache.xml.security.samples.signature.VerifyMerlinsExamplesSixteen;
import org.apache.xml.security.samples.signature.VerifyMerlinsExamplesTwentyThree;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.utils.resolver.ResourceResolverSpi;
import org.apache.xml.security.utils.resolver.implementations.ResolverAnonymous;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class IAIKInterOp {
    static Log log = LogFactory.getLog((String)(class$org$apache$xml$security$samples$iaik$IAIKInterOp == null ? (class$org$apache$xml$security$samples$iaik$IAIKInterOp = IAIKInterOp.class$("org.apache.xml.security.samples.iaik.IAIKInterOp")) : class$org$apache$xml$security$samples$iaik$IAIKInterOp).getName());
    static final boolean schemaValidate = false;
    static final String signatureSchemaFile = "data/xmldsig-core-schema.xsd";
    static /* synthetic */ Class class$org$apache$xml$security$samples$iaik$IAIKInterOp;

    public static void main(String[] stringArray) {
        String string;
        int n;
        System.out.println("We do not schema-validation");
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        documentBuilderFactory.setAttribute("http://xml.org/sax/features/namespaces", Boolean.TRUE);
        String string2 = "data/at/iaik/ixsil/";
        String[] stringArray2 = new String[]{string2 + "signatureAlgorithms/signatures/hMACSignature.xml", string2 + "signatureAlgorithms/signatures/hMACShortSignature.xml", string2 + "signatureAlgorithms/signatures/dSASignature.xml", string2 + "signatureAlgorithms/signatures/rSASignature.xml", string2 + "transforms/signatures/base64DecodeSignature.xml", string2 + "transforms/signatures/c14nSignature.xml", string2 + "coreFeatures/signatures/manifestSignature.xml", string2 + "transforms/signatures/xPathSignature.xml", string2 + "coreFeatures/signatures/signatureTypesSignature.xml", string2 + "transforms/signatures/envelopedSignatureSignature.xml"};
        IAIKInterOp.verifyAnonymous(string2, documentBuilderFactory);
        for (n = 0; n < 2; ++n) {
            string = stringArray2[n];
            try {
                VerifyMerlinsExamplesFifteen.verifyHMAC(documentBuilderFactory, string);
                continue;
            }
            catch (Exception exception) {
                System.out.println("The XML signature in file " + string + " crashed the application (bad)");
                exception.printStackTrace();
                System.out.println();
            }
        }
        for (n = 2; n < stringArray2.length; ++n) {
            string = stringArray2[n];
            try {
                VerifyMerlinsExamplesSixteen.verify(documentBuilderFactory, string);
                continue;
            }
            catch (Exception exception) {
                System.out.println("The XML signature in file " + string + " crashed the application (bad)");
                exception.printStackTrace();
                System.out.println();
            }
        }
        for (n = 2; n < stringArray2.length; ++n) {
            string = stringArray2[n];
            try {
                VerifyMerlinsExamplesTwentyThree.verify(documentBuilderFactory, string);
                continue;
            }
            catch (Exception exception) {
                System.out.println("The XML signature in file " + string + " crashed the application (bad)");
                exception.printStackTrace();
                System.out.println();
            }
        }
    }

    public static void verifyAnonymous(String string, DocumentBuilderFactory documentBuilderFactory) {
        String string2 = string + "coreFeatures/signatures/anonymousReferenceSignature.xml";
        try {
            String string3 = string + "coreFeatures/samples/anonymousReferenceContent.xml";
            ResolverAnonymous resolverAnonymous = new ResolverAnonymous(string3);
            File file = new File(string2);
            System.out.println("Try to verify " + file.toURL().toString());
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(new FileInputStream(file));
            Element element = SampleUtils.createDSctx(document, "ds", "http://www.w3.org/2000/09/xmldsig#");
            Element element2 = (Element)XPathAPI.selectSingleNode((Node)document, (String)"//ds:Signature[1]", (Node)element);
            XMLSignature xMLSignature = new XMLSignature(element2, file.toURL().toString());
            xMLSignature.setFollowNestedManifests(false);
            xMLSignature.addResourceResolver((ResourceResolverSpi)resolverAnonymous);
            KeyInfo keyInfo = xMLSignature.getKeyInfo();
            if (keyInfo != null) {
                X509Certificate x509Certificate = xMLSignature.getKeyInfo().getX509Certificate();
                if (x509Certificate != null) {
                    System.out.println("The XML signature in file " + file.toURL().toString() + " is " + (xMLSignature.checkSignatureValue(x509Certificate) ? "valid (good)" : "invalid !!!!! (bad)"));
                } else {
                    PublicKey publicKey = xMLSignature.getKeyInfo().getPublicKey();
                    if (publicKey != null) {
                        System.out.println("The XML signature in file " + file.toURL().toString() + " is " + (xMLSignature.checkSignatureValue((Key)publicKey) ? "valid (good)" : "invalid !!!!! (bad)"));
                    } else {
                        System.out.println("Did not find a public key, so I can't check the signature");
                    }
                }
            } else {
                System.out.println("Did not find a KeyInfo");
            }
        }
        catch (Exception exception) {
            System.out.println("The XML signature in file " + string2 + " crashed the application (bad)");
            exception.printStackTrace();
            System.out.println();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Init.init();
    }
}

