/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.Outputter;
import org.apache.commons.cli.Options;

public class RejectVpcPeeringConnection
extends BaseCmd {
    public RejectVpcPeeringConnection(String[] args) {
        super("ec2rpcx", "ec2-reject-vpc-peering-connection");
        this.init(new Options());
        this.parseOpts(args);
    }

    @Override
    protected String getOptionString() {
        return "[GENERAL OPTIONS] VPCPEERINGCONNECTION";
    }

    @Override
    public void printDescription() {
        super.printDescription();
        System.out.println("     Reject a VPC Peering Connection.");
    }

    @Override
    public void printOptions() {
        super.printOptions(false);
    }

    @Override
    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        this.assertNonOptionSet("VPCPEERINGCONNECTION");
        this.warnIfTooManyNonOptions();
        RequestResultPair result = jec2.rejectVpcPeeringConnection(this.getNonOptions()[0]);
        out.output(System.out, (Boolean)result.getResponse());
        out.printRequestId(System.out, (RequestResult)result);
        return true;
    }

    public static void main(String[] args) {
        new RejectVpcPeeringConnection(args).invoke();
    }
}

