/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.d2j.dex.writer.ev;

import com.googlecode.d2j.dex.writer.ev.EncodedValue;
import com.googlecode.d2j.dex.writer.io.DataOut;
import com.googlecode.d2j.dex.writer.item.BaseItem;
import com.googlecode.d2j.dex.writer.item.StringIdItem;
import com.googlecode.d2j.dex.writer.item.TypeIdItem;
import java.util.ArrayList;
import java.util.List;

public class EncodedAnnotation
implements Comparable<EncodedAnnotation> {
    public TypeIdItem type;
    public final List<AnnotationElement> elements = new ArrayList<AnnotationElement>(5);

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EncodedAnnotation that = (EncodedAnnotation)o;
        if (!this.elements.equals(that.elements)) {
            return false;
        }
        return this.type.equals(that.type);
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + this.elements.hashCode();
        return result;
    }

    @Override
    public int compareTo(EncodedAnnotation o) {
        if (o == null) {
            return 1;
        }
        int x = this.type.compareTo(o.type);
        if (x != 0) {
            return x;
        }
        x = Integer.compare(this.elements.size(), o.elements.size());
        if (x != 0) {
            return x;
        }
        for (int i = 0; i < this.elements.size(); ++i) {
            AnnotationElement b;
            AnnotationElement a = this.elements.get(i);
            x = a.compareTo(b = o.elements.get(i));
            if (x == 0) continue;
            return x;
        }
        return 0;
    }

    public int place(int offset) {
        offset += BaseItem.lengthOfUleb128(this.type.index);
        offset += BaseItem.lengthOfUleb128(this.elements.size());
        for (AnnotationElement ae : this.elements) {
            offset += BaseItem.lengthOfUleb128(ae.name.index);
            offset = ae.value.place(offset);
        }
        return offset;
    }

    public void write(DataOut out) {
        out.uleb128("type_idx", this.type.index);
        out.uleb128("size", this.elements.size());
        for (AnnotationElement ae : this.elements) {
            out.uleb128("name_idx", ae.name.index);
            ae.value.write(out);
        }
    }

    public static class AnnotationElement
    implements Comparable<AnnotationElement> {
        public StringIdItem name;
        public EncodedValue value;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AnnotationElement that = (AnnotationElement)o;
            if (!this.name.equals(that.name)) {
                return false;
            }
            return this.value.equals(that.value);
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + this.value.hashCode();
            return result;
        }

        @Override
        public int compareTo(AnnotationElement o) {
            if (o == null) {
                return 1;
            }
            int x = this.name.compareTo(o.name);
            if (x != 0) {
                return x;
            }
            return this.value.compareTo(o.value);
        }
    }
}

