/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.query;

import ca.sqlpower.query.Container;
import ca.sqlpower.query.Item;
import ca.sqlpower.query.ItemContainer;
import ca.sqlpower.query.SQLObjectItem;
import ca.sqlpower.sqlobject.SQLColumn;
import ca.sqlpower.sqlobject.SQLDatabase;
import ca.sqlpower.sqlobject.SQLObjectException;
import ca.sqlpower.sqlobject.SQLTable;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.log4j.Logger;

public class TableContainer
extends ItemContainer
implements Container {
    private static final Logger logger = Logger.getLogger(TableContainer.class);
    private SQLTable table;
    private final List<SQLObjectItem> itemList;
    private final String catalog;
    private final String schema;
    private final SQLDatabase database;

    public TableContainer(@Nonnull SQLDatabase db, @Nonnull SQLTable t) {
        super(t.getName());
        if (db == null) {
            throw new NullPointerException("Database mustn't be null when providing a live SQLTable.");
        }
        this.database = db;
        this.table = t;
        this.schema = this.table.getSchemaName();
        this.catalog = this.table.getCatalogName();
        this.setAlias("");
        this.itemList = new ArrayList<SQLObjectItem>();
        this.loadColumnsFromTable(t);
    }

    public TableContainer(String uuid, SQLDatabase db, String name, String schema, String catalog, List<SQLObjectItem> items) {
        this(uuid, db, name, schema, catalog, items, false);
    }

    public TableContainer(String uuid, SQLDatabase db, String name, String schema, String catalog, List<SQLObjectItem> items, boolean doPopulate) {
        super(name, uuid);
        if (db == null) {
            logger.debug((Object)("Database connection for table " + name + " is missing. Although " + "this is non-fatal, it should only happen if the actual database " + "connection was unavailable at the time the workspace was loaded"), (Throwable)new Exception("Don't panic. Just a stack trace"));
        }
        this.database = db;
        this.schema = schema != null ? schema : "";
        this.catalog = catalog != null ? catalog : "";
        this.setName(name);
        if (doPopulate) {
            this.table = null;
        } else {
            try {
                this.table = new SQLTable(db, true);
                this.table.setName(name);
            }
            catch (SQLObjectException e) {
                throw new RuntimeException("Cannot happen", e);
            }
        }
        super.setAlias("");
        this.itemList = new ArrayList<SQLObjectItem>();
        for (SQLObjectItem item : items) {
            item.setParent(this);
            this.itemList.add(item);
            this.fireChildAdded(item, this.itemList.indexOf(item));
        }
    }

    private void loadColumnsFromTable(SQLTable t) {
        try {
            for (SQLColumn child : t.getColumns()) {
                boolean itemFound = false;
                for (SQLObjectItem item : this.itemList) {
                    if (!item.getName().equals(child.getName())) continue;
                    item.setItem(child);
                    itemFound = true;
                    break;
                }
                if (itemFound) continue;
                SQLObjectItem item = new SQLObjectItem(child);
                item.setParent(this);
                this.itemList.add(item);
                this.fireChildAdded(item, this.itemList.indexOf(item));
            }
        }
        catch (SQLObjectException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<Item> getItems() {
        this.loadTableByQualifiedName();
        return new ArrayList<Item>(this.itemList);
    }

    @Override
    public String getName() {
        this.loadTableByQualifiedName();
        if (this.table != null) {
            return this.table.getName();
        }
        return super.getName();
    }

    @Override
    public Item getItem(Object item) {
        this.loadTableByQualifiedName();
        for (SQLObjectItem i : this.itemList) {
            if (i.getItem() != item) continue;
            return i;
        }
        return null;
    }

    public SQLDatabase getDatabase() {
        return this.database;
    }

    @Override
    public Object getContainedObject() {
        this.loadTableByQualifiedName();
        return this.table;
    }

    @Override
    public void addItem(Item item) {
        throw new IllegalStateException("Cannot add arbitrary items to a SQLObject.");
    }

    @Override
    public void removeItem(Item item) {
        throw new IllegalStateException("Cannot remove arbitrary items from a SQLObject.");
    }

    @Override
    public void removeItem(int i) {
        throw new IllegalStateException("Cannot remove arbitrary items from a SQLObject.");
    }

    public String getSchema() {
        return this.schema;
    }

    public String getCatalog() {
        return this.catalog;
    }

    void loadTableByQualifiedName() {
        if (this.table == null) {
            SQLDatabase db = this.database;
            logger.debug((Object)("Cache has database " + db));
            if (db == null) {
                logger.info((Object)("Skipping table " + super.getName() + " because its database connection is missing"));
                return;
            }
            try {
                this.table = db.getTableByName(this.catalog, this.schema, super.getName());
            }
            catch (SQLObjectException e) {
                logger.info((Object)("Skipping table " + super.getName() + " due to failure in populate:"), (Throwable)e);
                return;
            }
            if (this.table == null) {
                logger.info((Object)("Skipping table " + super.getName() + " because it doesn't exist in the database"));
                return;
            }
            this.loadColumnsFromTable(this.table);
        }
    }

    @Override
    public Container createCopy() {
        TableContainer copy = this.database != null && this.table != null ? new TableContainer(this.database, this.table) : new TableContainer(this.getUUID(), this.database, this.getName(), this.schema, this.catalog, this.itemList);
        for (SQLObjectItem item : this.itemList) {
            Item newItem = copy.getItem(item.getItem());
            newItem.setAlias(item.getAlias());
            newItem.setColumnWidth(item.getColumnWidth());
            newItem.setGroupBy(item.getGroupBy());
            newItem.setHaving(item.getHaving());
            newItem.setOrderBy(item.getOrderBy());
            newItem.setOrderByOrdering(item.getOrderByOrdering());
            newItem.setSelected(item.getSelected());
            newItem.setWhere(item.getWhere());
        }
        copy.setAlias(this.getAlias());
        copy.setPosition(new Point2D.Double(this.getPosition().getX(), this.getPosition().getY()));
        return copy;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof TableContainer && ((TableContainer)obj).getUUID().equals(this.getUUID());
    }

    @Override
    public int hashCode() {
        return 527 + this.getUUID().hashCode();
    }
}

