/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.profile;

import ca.sqlpower.architect.ArchitectProject;
import ca.sqlpower.architect.profile.LocalReservoirProfileCreator;
import ca.sqlpower.architect.profile.ProfileManager;
import ca.sqlpower.architect.profile.ProfileResult;
import ca.sqlpower.architect.profile.ProfileSettings;
import ca.sqlpower.architect.profile.RemoteDatabaseProfileCreator;
import ca.sqlpower.architect.profile.TableProfileCreator;
import ca.sqlpower.architect.profile.TableProfileResult;
import ca.sqlpower.architect.profile.event.ProfileChangeEvent;
import ca.sqlpower.architect.profile.event.ProfileChangeListener;
import ca.sqlpower.dao.PersistedSPObject;
import ca.sqlpower.dao.SPPersister;
import ca.sqlpower.dao.SPPersisterListener;
import ca.sqlpower.dao.SPSessionPersister;
import ca.sqlpower.dao.session.SessionPersisterSuperConverter;
import ca.sqlpower.object.AbstractSPObject;
import ca.sqlpower.object.SPObject;
import ca.sqlpower.object.annotation.Accessor;
import ca.sqlpower.object.annotation.Constructor;
import ca.sqlpower.object.annotation.Mutator;
import ca.sqlpower.object.annotation.NonBound;
import ca.sqlpower.object.annotation.NonProperty;
import ca.sqlpower.object.annotation.Transient;
import ca.sqlpower.sql.DataSourceCollection;
import ca.sqlpower.sql.PlDotIni;
import ca.sqlpower.sqlobject.SQLColumn;
import ca.sqlpower.sqlobject.SQLDatabase;
import ca.sqlpower.sqlobject.SQLObject;
import ca.sqlpower.sqlobject.SQLObjectException;
import ca.sqlpower.sqlobject.SQLObjectPreEvent;
import ca.sqlpower.sqlobject.SQLObjectPreEventListener;
import ca.sqlpower.sqlobject.SQLTable;
import ca.sqlpower.util.MonitorableImpl;
import ca.sqlpower.util.SessionNotFoundException;
import ca.sqlpower.util.UserPrompter;
import ca.sqlpower.util.UserPrompterFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;

public class ProfileManagerImpl
extends AbstractSPObject
implements ProfileManager {
    public static final List<Class<? extends SPObject>> allowedChildTypes = Collections.unmodifiableList(new ArrayList<Class>(Arrays.asList(ProfileSettings.class, TableProfileResult.class)));
    private static final Logger logger = Logger.getLogger(ProfileManagerImpl.class);
    private final List<ProfileChangeListener> profileChangeListeners = new ArrayList<ProfileChangeListener>();
    private final List<TableProfileResult> results = new ArrayList<TableProfileResult>();
    private ProfileSettings defaultProfileSettings = new ProfileSettings();
    private ExecutorService profileExecutor = Executors.newSingleThreadExecutor();
    private TableProfileCreator creator = new RemoteDatabaseProfileCreator(this.getDefaultProfileSettings());
    private final DatabaseRemovalWatcher databaseRemovalWatcher = new DatabaseRemovalWatcher();
    private List<TableProfileCreator> profileCreators = Arrays.asList(new RemoteDatabaseProfileCreator(this.getDefaultProfileSettings()), new LocalReservoirProfileCreator(this.getDefaultProfileSettings()));

    @Constructor
    public ProfileManagerImpl() {
        this.defaultProfileSettings.setParent(this);
        this.setName("Profile Manager");
    }

    @Mutator
    public void setParent(SPObject parent) {
        ArchitectProject oldParent = this.getParent();
        if (this.getParent() != null) {
            this.getParent().getRootObject().removeSQLObjectPreEventListener((SQLObjectPreEventListener)this.databaseRemovalWatcher);
        }
        super.setParent(parent);
        ArchitectProject architectProject = (ArchitectProject)parent;
        if (parent != null && architectProject.getRootObject() != null) {
            architectProject.getRootObject().addSQLObjectPreEventListener((SQLObjectPreEventListener)this.databaseRemovalWatcher);
        }
        this.firePropertyChange("parent", (Object)oldParent, parent);
    }

    @Accessor
    public ArchitectProject getParent() {
        return (ArchitectProject)super.getParent();
    }

    public void addTableProfileResult(TableProfileResult child) {
        this.results.add(child);
        child.setParent(this);
        this.fireProfilesAdded(Collections.singletonList(child));
    }

    private void addResults(List<TableProfileResult> newResults, boolean overrideCompletion) {
        this.results.addAll(newResults);
        for (TableProfileResult tpr : newResults) {
            tpr.setParent(this);
        }
        this.fireProfilesAdded(newResults);
        for (TableProfileResult newResult : newResults) {
            if (overrideCompletion) {
                ((MonitorableImpl)newResult.getProgressMonitor()).setFinished(true);
            }
            SQLTable table = (SQLTable)newResult.getProfiledObject();
            table.putClientProperty(ProfileManager.class, "profileCount", (Object)this.getResults(table).size());
        }
    }

    @Override
    public TableProfileResult createProfile(SQLTable table) throws SQLObjectException {
        TableProfileResult tpr = new TableProfileResult(table, this.getDefaultProfileSettings());
        this.addResults(Collections.singletonList(tpr), false);
        try {
            this.profileExecutor.submit(new ProfileResultCallable(tpr)).get();
            assert (tpr.getProgressMonitor().isFinished());
        }
        catch (InterruptedException ex) {
            logger.info((Object)"Profiling was interrupted (likely because this manager is being shut down)");
        }
        catch (ExecutionException ex) {
            throw new SQLObjectException("Profile execution failed", (Throwable)ex);
        }
        return tpr;
    }

    @Override
    public Collection<Future<TableProfileResult>> asynchCreateProfiles(Collection<SQLTable> tables) {
        ArrayList<TableProfileResult> profiles = new ArrayList<TableProfileResult>();
        for (SQLTable t : tables) {
            profiles.add(new TableProfileResult(t, this.getDefaultProfileSettings()));
        }
        this.addResults(profiles, false);
        ArrayList<Future<TableProfileResult>> results = new ArrayList<Future<TableProfileResult>>();
        for (TableProfileResult tpr : profiles) {
            results.add(this.scheduleProfile(tpr));
        }
        return results;
    }

    @Override
    public Future<TableProfileResult> scheduleProfile(TableProfileResult result) {
        return this.profileExecutor.submit(new ProfileResultCallable(result));
    }

    @Override
    public void clear() {
        ArrayList<TableProfileResult> oldResults = new ArrayList<TableProfileResult>(this.results);
        this.results.clear();
        this.fireProfilesRemoved(oldResults);
        int index = 0;
        try {
            this.begin("Removing all profiles");
            for (TableProfileResult oldResult : oldResults) {
                this.fireChildRemoved(TableProfileResult.class, oldResult, index);
                SQLTable table = (SQLTable)oldResult.getProfiledObject();
                table.putClientProperty(ProfileManager.class, "profileCount", (Object)0);
                ++index;
            }
            this.commit();
        }
        catch (RuntimeException e) {
            this.rollback(e.getMessage());
            throw e;
        }
        catch (Throwable t) {
            this.rollback(t.getMessage());
            throw new RuntimeException(t);
        }
    }

    @Override
    @NonProperty
    public List<TableProfileResult> getResults() {
        return Collections.unmodifiableList(new ArrayList<TableProfileResult>(this.results));
    }

    @Override
    @NonProperty
    public List<TableProfileResult> getResults(SQLTable t) {
        ArrayList<TableProfileResult> someResults = new ArrayList<TableProfileResult>();
        for (TableProfileResult tpr : this.results) {
            if (!((SQLTable)tpr.getProfiledObject()).equals((Object)t)) continue;
            someResults.add(tpr);
        }
        return Collections.unmodifiableList(someResults);
    }

    @Override
    public boolean removeProfile(TableProfileResult victim) {
        int index = this.results.indexOf(victim);
        boolean removed = this.results.remove(victim);
        if (removed) {
            this.fireChildRemoved(TableProfileResult.class, victim, index);
            this.fireProfilesRemoved(Collections.singletonList(victim));
        }
        SQLTable table = (SQLTable)victim.getProfiledObject();
        table.putClientProperty(ProfileManager.class, "profileCount", (Object)this.getResults(table).size());
        return removed;
    }

    @Override
    @NonProperty
    public ProfileSettings getDefaultProfileSettings() {
        return this.defaultProfileSettings;
    }

    @Override
    @NonProperty
    public void setDefaultProfileSettings(ProfileSettings settings) {
        ProfileSettings oldSettings = this.defaultProfileSettings;
        this.defaultProfileSettings = settings;
        this.defaultProfileSettings.setParent(this);
        if (oldSettings != null) {
            this.fireChildRemoved(ProfileSettings.class, (SPObject)oldSettings, 0);
        }
        if (settings != null) {
            this.fireChildAdded(ProfileSettings.class, (SPObject)settings, 0);
        }
    }

    @Override
    @NonBound
    public void setProcessingOrder(List<TableProfileResult> tpr) {
    }

    public void loadResult(ProfileResult<? extends SQLObject> pr) {
        if (pr instanceof TableProfileResult) {
            TableProfileResult tpr = (TableProfileResult)pr;
            this.addResults(Collections.singletonList(tpr), true);
        }
    }

    @Override
    public void addProfileChangeListener(ProfileChangeListener listener) {
        this.profileChangeListeners.add(listener);
    }

    @Override
    public void removeProfileChangeListener(ProfileChangeListener listener) {
        this.profileChangeListeners.remove(listener);
    }

    private void fireProfilesAdded(List<TableProfileResult> results) {
        if (results == null) {
            throw new NullPointerException("Can't fire event for null profile list");
        }
        for (TableProfileResult tpr : results) {
            this.fireChildAdded(TableProfileResult.class, tpr, results.indexOf(tpr));
        }
        ProfileChangeEvent e = new ProfileChangeEvent(this, results);
        for (int i = this.profileChangeListeners.size() - 1; i >= 0; --i) {
            this.profileChangeListeners.get(i).profilesAdded(e);
        }
    }

    private void fireProfilesRemoved(List<TableProfileResult> removedList) {
        if (removedList == null) {
            throw new NullPointerException("Null list not allowed");
        }
        ProfileChangeEvent e = new ProfileChangeEvent(this, removedList);
        for (int i = this.profileChangeListeners.size() - 1; i >= 0; --i) {
            this.profileChangeListeners.get(i).profilesRemoved(e);
        }
    }

    @Override
    public void close() {
        this.profileExecutor.shutdown();
    }

    @Override
    @NonBound
    public List<TableProfileCreator> getProfileCreators() {
        return Collections.unmodifiableList(this.profileCreators);
    }

    @Override
    @NonBound
    public TableProfileCreator getCreator() {
        return this.creator;
    }

    @Override
    @NonBound
    public void setCreator(TableProfileCreator tpc) {
        this.creator = tpc;
    }

    protected boolean removeChildImpl(SPObject child) {
        if (child.getClass().isAssignableFrom(TableProfileResult.class)) {
            if (this.removeProfile((TableProfileResult)child)) {
                return true;
            }
            throw new IllegalArgumentException("Table does not exist in this profile manager");
        }
        throw new IllegalArgumentException("Child must be of type TableProfileResult");
    }

    protected void addChildImpl(SPObject child, int index) {
        if (child instanceof ProfileSettings) {
            this.setDefaultProfileSettings((ProfileSettings)child);
        } else if (child instanceof TableProfileResult) {
            this.addResults(Collections.singletonList((TableProfileResult)child), true);
        }
    }

    public boolean allowsChildren() {
        return true;
    }

    public int childPositionOffset(Class<? extends SPObject> childType) {
        if (childType.isAssignableFrom(ProfileSettings.class)) {
            return 0;
        }
        if (childType.isAssignableFrom(TableProfileResult.class)) {
            if (this.defaultProfileSettings != null) {
                return 1;
            }
            return 0;
        }
        throw new IllegalArgumentException();
    }

    @Transient
    @Accessor
    public List<Class<? extends SPObject>> getAllowedChildTypes() {
        return allowedChildTypes;
    }

    @NonProperty
    public List<? extends SPObject> getChildren() {
        ArrayList<AbstractSPObject> allChildren = new ArrayList<AbstractSPObject>();
        allChildren.add(this.defaultProfileSettings);
        allChildren.addAll(this.results);
        return allChildren;
    }

    @NonBound
    public List<? extends SPObject> getDependencies() {
        return Collections.emptyList();
    }

    public void removeDependency(SPObject dependency) {
    }

    private class ProfileResultCallable
    implements Callable<TableProfileResult> {
        private TableProfileResult actualTPR;
        private final TableProfileResult tpr;

        ProfileResultCallable(TableProfileResult actualTPR) {
            TableProfileResult tempTPR;
            if (actualTPR == null) {
                throw new NullPointerException("Can't populate a null profile result!");
            }
            this.actualTPR = actualTPR;
            try {
                SQLTable profileTable = (SQLTable)actualTPR.getProfiledObject();
                SQLTable table = new SQLTable(profileTable.getParentDatabase(), true);
                table.setUUID(profileTable.getUUID());
                table.updateToMatch((SQLObject)profileTable);
                for (SQLColumn col : profileTable.getColumns()) {
                    SQLColumn newCol = new SQLColumn();
                    newCol.updateToMatch((SQLObject)col);
                    newCol.setUUID(col.getUUID());
                    table.addColumn(newCol);
                }
                tempTPR = new TableProfileResult(actualTPR, table);
                tempTPR.setUUID(actualTPR.getUUID());
                ProfileManagerImpl backgroundPM = new ProfileManagerImpl();
                backgroundPM.setUUID(actualTPR.getParent().getUUID());
                tempTPR.setParent(backgroundPM);
            }
            catch (Exception e) {
                tempTPR = null;
                actualTPR.setException(e);
            }
            this.tpr = tempTPR;
        }

        @Override
        public TableProfileResult call() throws Exception {
            if (this.actualTPR.getException() != null) {
                throw this.actualTPR.getException();
            }
            ProfileManagerImpl.this.creator.doProfile(this.tpr);
            Runnable runner = new Runnable(){

                @Override
                public void run() {
                    PlDotIni dsCollection = new PlDotIni();
                    SPObject root = ProfileResultCallable.this.actualTPR.getWorkspaceContainer().getWorkspace();
                    SessionPersisterSuperConverter converter = new SessionPersisterSuperConverter((DataSourceCollection)dsCollection, root);
                    SPSessionPersister persister = new SPSessionPersister("Profiling persister", root, converter){

                        protected void refreshRootNode(PersistedSPObject pso) {
                        }
                    };
                    persister.setWorkspaceContainer(ProfileResultCallable.this.actualTPR.getWorkspaceContainer());
                    SPPersisterListener eventCreator = new SPPersisterListener((SPPersister)persister, converter);
                    eventCreator.persistObject((SPObject)ProfileResultCallable.this.tpr, ProfileResultCallable.this.actualTPR.getParent().getChildren(TableProfileResult.class).indexOf(ProfileResultCallable.this.actualTPR), false);
                }
            };
            try {
                this.actualTPR.getRunnableDispatcher().runInForeground(runner);
            }
            catch (SessionNotFoundException e) {
                runner.run();
            }
            if (this.tpr.getException() != null) {
                throw this.tpr.getException();
            }
            return this.actualTPR;
        }
    }

    private class DatabaseRemovalWatcher
    implements SQLObjectPreEventListener {
        private DatabaseRemovalWatcher() {
        }

        public void dbChildrenPreRemove(SQLObjectPreEvent e) {
            logger.debug((Object)"Pre-remove on profile manager");
            UserPrompter up = ProfileManagerImpl.this.getParent().getSession().createUserPrompter("{0} tables have been profiled from the database {1}.\n\nIf you proceed, the profiling information from the database will be removed.", UserPrompterFactory.UserPromptType.BOOLEAN, UserPrompter.UserPromptOptions.OK_NOTOK_CANCEL, UserPrompter.UserPromptResponse.OK, Boolean.TRUE, new String[]{"Remove Profiles", "Keep Profiles", "Cancel"});
            for (SQLObject so : e.getChildren()) {
                SQLDatabase db = (SQLDatabase)so;
                ArrayList<TableProfileResult> refs = new ArrayList<TableProfileResult>();
                for (TableProfileResult tpr : ProfileManagerImpl.this.getResults()) {
                    if (((SQLTable)tpr.getProfiledObject()).getParentDatabase() == null || !((SQLTable)tpr.getProfiledObject()).getParentDatabase().equals((Object)db)) continue;
                    refs.add(tpr);
                }
                if (refs.isEmpty()) continue;
                UserPrompter.UserPromptResponse response = up.promptUser(new Object[]{refs.size(), db.getName()});
                if (response == UserPrompter.UserPromptResponse.OK) {
                    logger.debug((Object)"We got the ok to delete.");
                    for (TableProfileResult tpr : refs) {
                        ProfileManagerImpl.this.results.remove(tpr);
                    }
                    continue;
                }
                if (response == UserPrompter.UserPromptResponse.NOT_OK) {
                    e.veto();
                    continue;
                }
                if (response != UserPrompter.UserPromptResponse.CANCEL) continue;
                e.veto();
            }
        }
    }
}

