/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.filesexist;

import java.io.IOException;
import java.util.List;
import org.apache.commons.vfs.FileObject;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobEntryType;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.filesexist.Messages;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.repository.Repository;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobEntryFilesExist
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private String filename;
    public String[] arguments;

    public JobEntryFilesExist(String n) {
        super(n, "");
        this.filename = null;
        this.setID(-1L);
        this.setJobEntryType(JobEntryType.FILES_EXIST);
    }

    public JobEntryFilesExist() {
        this("");
    }

    public JobEntryFilesExist(JobEntryBase jeb) {
        super(jeb);
    }

    @Override
    public Object clone() {
        JobEntryFilesExist je = (JobEntryFilesExist)super.clone();
        return je;
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer();
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"filename", (String)this.filename));
        retval.append("      <fields>").append(Const.CR);
        if (this.arguments != null) {
            for (int i = 0; i < this.arguments.length; ++i) {
                retval.append("        <field>").append(Const.CR);
                retval.append("          ").append(XMLHandler.addTagValue((String)"name", (String)this.arguments[i]));
                retval.append("        </field>").append(Const.CR);
            }
        }
        retval.append("      </fields>").append(Const.CR);
        return retval.toString();
    }

    @Override
    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            this.filename = XMLHandler.getTagValue((Node)entrynode, (String)"filename");
            Node fields = XMLHandler.getSubNode((Node)entrynode, (String)"fields");
            int nrFields = XMLHandler.countNodes((Node)fields, (String)"field");
            this.arguments = new String[nrFields];
            for (int i = 0; i < nrFields; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.arguments[i] = XMLHandler.getTagValue((Node)fnode, (String)"name");
            }
        }
        catch (KettleXMLException xe) {
            throw new KettleXMLException(Messages.getString("JobEntryFilesExist.ERROR_0001_Cannot_Load_Job_Entry_From_Xml_Node", xe.getMessage()));
        }
    }

    @Override
    public void loadRep(Repository rep, long id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            super.loadRep(rep, id_jobentry, databases, slaveServers);
            this.filename = rep.getJobEntryAttributeString(id_jobentry, "filename");
            int argnr = rep.countNrJobEntryAttributes(id_jobentry, "name");
            this.arguments = new String[argnr];
            for (int a = 0; a < argnr; ++a) {
                this.arguments[a] = rep.getJobEntryAttributeString(id_jobentry, a, "name");
            }
        }
        catch (KettleException dbe) {
            throw new KettleException(Messages.getString("JobEntryFilesExist.ERROR_0002_Cannot_Load_Job_From_Repository", "" + id_jobentry, dbe.getMessage()));
        }
    }

    @Override
    public void saveRep(Repository rep, long id_job) throws KettleException {
        try {
            super.saveRep(rep, id_job);
            rep.saveJobEntryAttribute(id_job, this.getID(), "filename", this.filename);
            if (this.arguments != null) {
                for (int i = 0; i < this.arguments.length; ++i) {
                    rep.saveJobEntryAttribute(id_job, this.getID(), (long)i, "name", this.arguments[i]);
                }
            }
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException(Messages.getString("JobEntryFilesExist.ERROR_0003_Cannot_Save_Job_Entry", "" + id_job, dbe.getMessage()));
        }
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public Result execute(Result previousResult, int nr, Repository rep, Job parentJob) {
        LogWriter log = LogWriter.getInstance();
        Result result = previousResult;
        result.setResult(false);
        int missingfiles = 0;
        if (this.arguments != null) {
            for (int i = 0; i < this.arguments.length && !parentJob.isStopped(); ++i) {
                FileObject file;
                block14: {
                    file = null;
                    String realFilefoldername = this.environmentSubstitute(this.arguments[i]);
                    file = KettleVFS.getFileObject((String)realFilefoldername);
                    if (file.exists() && file.isReadable()) {
                        if (log.isDetailed()) {
                            log.logDetailed(this.toString(), Messages.getString("JobEntryFilesExist.File_Exists", realFilefoldername), new Object[0]);
                        }
                        break block14;
                    }
                    result.setNrErrors((long)(++missingfiles));
                    if (!log.isDetailed()) break block14;
                    log.logDetailed(this.toString(), Messages.getString("JobEntryFilesExist.File_Does_Not_Exist", realFilefoldername), new Object[0]);
                }
                Object var12_12 = null;
                if (file == null) continue;
                try {
                    file.close();
                }
                catch (IOException ex) {}
                continue;
                {
                    catch (IOException e) {
                        result.setNrErrors((long)(++missingfiles));
                        log.logError(this.toString(), Messages.getString("JobEntryFilesExist.ERROR_0004_IO_Exception", e.toString()), new Object[0]);
                        var12_12 = null;
                        if (file == null) continue;
                        try {
                            file.close();
                        }
                        catch (IOException ex) {}
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    var12_12 = null;
                    if (file != null) {
                        try {
                            file.close();
                        }
                        catch (IOException ex) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
            }
        }
        if (missingfiles == 0) {
            result.setResult(true);
        }
        return result;
    }

    @Override
    public boolean evaluates() {
        return true;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, JobMeta jobMeta) {
    }
}

