/*
 * Decompiled with CFR 0.152.
 */
package brut.yaml;

import java.util.Objects;
import org.apache.commons.text.StringEscapeUtils;

public final class YamlLine {
    public final int indent;
    public final String key;
    public final String value;
    public final boolean isComment;
    public final boolean isEmpty;
    public final boolean hasColon;
    public final boolean isNull;
    public final boolean isItem;

    public YamlLine(String stringArray) {
        int n;
        this.indent = 0;
        this.key = "";
        this.value = "";
        this.isNull = Objects.isNull(stringArray);
        if (stringArray == null) {
            return;
        }
        this.isEmpty = stringArray.trim().isEmpty();
        if (this.isEmpty) {
            return;
        }
        for (n = 0; n < stringArray.length() && stringArray.charAt(n) == ' '; ++n) {
            ++this.indent;
        }
        stringArray = stringArray.trim();
        char c = stringArray.charAt(0);
        n = c;
        boolean bl = c == '#' || n == 33;
        this.isComment = bl;
        n = n == 45 ? 1 : 0;
        this.isItem = n;
        if (bl) {
            this.value = stringArray.substring(1).trim();
        } else {
            this.hasColon = stringArray.contains(":");
            if (n != 0) {
                this.value = stringArray.substring(1).trim();
            } else if ((stringArray = stringArray.split(":")).length > 0) {
                this.key = stringArray[0].trim();
                if (stringArray.length > 1) {
                    this.value = stringArray[1].trim();
                }
            }
        }
    }

    public final String getValue() {
        if (this.value.equals("null")) {
            return null;
        }
        return StringEscapeUtils.UNESCAPE_JAVA.translate(this.value).replaceAll("^\"|\"$", "").replaceAll("^'|'$", "");
    }

    public final String getKey() {
        return StringEscapeUtils.UNESCAPE_JAVA.translate(this.key).replaceAll("^\"|\"$", "").replaceAll("^'|'$", "");
    }

    public final boolean getValueBool() {
        return Objects.equals(this.value, "true");
    }
}

