/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.utils.counters;

import java.util.Iterator;
import org.graalvm.visualvm.heapviewer.utils.counters.BooleanCounter;
import org.graalvm.visualvm.heapviewer.utils.counters.ByteCounter;
import org.graalvm.visualvm.heapviewer.utils.counters.CharCounter;
import org.graalvm.visualvm.heapviewer.utils.counters.DoubleCounter;
import org.graalvm.visualvm.heapviewer.utils.counters.FloatCounter;
import org.graalvm.visualvm.heapviewer.utils.counters.IntCounter;
import org.graalvm.visualvm.heapviewer.utils.counters.LongCounter;
import org.graalvm.visualvm.heapviewer.utils.counters.ShortCounter;

public abstract class PrimitiveCounter {
    public static PrimitiveCounter create(String type, int instancesCount) {
        switch (type) {
            case "boolean": {
                return new BooleanCounter();
            }
            case "char": {
                return new CharCounter();
            }
            case "byte": {
                return new ByteCounter();
            }
            case "short": {
                return new ShortCounter();
            }
            case "int": {
                return new IntCounter(instancesCount);
            }
            case "long": {
                return new LongCounter(instancesCount);
            }
            case "float": {
                return new FloatCounter(instancesCount);
            }
            case "double": {
                return new DoubleCounter(instancesCount);
            }
        }
        throw new IllegalArgumentException("Unknown primitive type " + type);
    }

    public abstract void count(String var1);

    public abstract int size();

    public abstract Iterator<? extends Record> iterator();

    public static abstract class Record {
        public abstract String getValue();

        public abstract int getCount();
    }
}

