/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.ui.components.treetable;

import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.TreePath;
import org.graalvm.visualvm.lib.jfluid.results.CCTNode;
import org.graalvm.visualvm.lib.ui.components.treetable.TreeTableModel;

public abstract class AbstractTreeTableModel
extends DefaultTableModel
implements TreeTableModel {
    protected CCTNode root;
    protected boolean initialSortingOrder;
    protected boolean supportsSorting;
    protected int initialSortingColumn;

    public AbstractTreeTableModel(CCTNode root) {
        this(root, false, -1, false);
    }

    public AbstractTreeTableModel(CCTNode root, int sortingColumn, boolean sortingOrder) {
        this(root, true, sortingColumn, sortingOrder);
    }

    public AbstractTreeTableModel(CCTNode root, boolean supportsSorting, int sortingColumn, boolean sortingOrder) {
        this.root = root;
        this.supportsSorting = supportsSorting;
        this.initialSortingColumn = sortingColumn;
        this.initialSortingOrder = sortingOrder;
    }

    @Override
    public Object getChild(Object node, int num) {
        return ((CCTNode)node).getChild(num);
    }

    @Override
    public int getChildCount(Object node) {
        return ((CCTNode)node).getNChildren();
    }

    @Override
    public abstract Class getColumnClass(int var1);

    @Override
    public abstract int getColumnCount();

    @Override
    public abstract String getColumnName(int var1);

    public String getColumnToolTipText(int column) {
        return null;
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        if (parent == null || child == null) {
            return -1;
        }
        return ((CCTNode)parent).getIndexOfChild(child);
    }

    public boolean getInitialSorting(int column) {
        return false;
    }

    public int getInitialSortingColumn() {
        return this.initialSortingColumn;
    }

    public boolean getInitialSortingOrder() {
        return this.initialSortingOrder;
    }

    @Override
    public boolean isLeaf(Object node) {
        return ((CCTNode)node).getNChildren() == 0;
    }

    public void setRoot(Object root) {
        this.root = (CCTNode)root;
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    @Override
    public abstract Object getValueAt(Object var1, int var2);

    @Override
    public boolean isCellEditable(Object node, int column) {
        return false;
    }

    public CCTNode[] getPathToRoot(CCTNode aNode) {
        return this.getPathToRoot(aNode, 0);
    }

    @Override
    public void setValueAt(Object aValue, Object node, int column) {
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.listenerList.add(TreeModelListener.class, l);
    }

    public void fireTreeNodesChanged(Object source, Object[] path, int[] childIndices, Object[] children) {
        Object[] listeners = this.listenerList.getListenerList();
        TreeModelEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TreeModelListener.class) continue;
            if (e == null) {
                e = new TreeModelEvent(source, path, childIndices, children);
            }
            ((TreeModelListener)listeners[i + 1]).treeNodesChanged(e);
        }
    }

    public void fireTreeNodesInserted(Object source, Object[] path, int[] childIndices, Object[] children) {
        Object[] listeners = this.listenerList.getListenerList();
        TreeModelEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TreeModelListener.class) continue;
            if (e == null) {
                e = new TreeModelEvent(source, path, childIndices, children);
            }
            ((TreeModelListener)listeners[i + 1]).treeNodesInserted(e);
        }
    }

    public void fireTreeNodesRemoved(Object source, Object[] path, int[] childIndices, Object[] children) {
        Object[] listeners = this.listenerList.getListenerList();
        TreeModelEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TreeModelListener.class) continue;
            if (e == null) {
                e = new TreeModelEvent(source, path, childIndices, children);
            }
            ((TreeModelListener)listeners[i + 1]).treeNodesRemoved(e);
        }
    }

    public void fireTreeStructureChanged(Object source, Object[] path, int[] childIndices, Object[] children) {
        Object[] listeners = this.listenerList.getListenerList();
        TreeModelEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TreeModelListener.class) continue;
            if (e == null) {
                e = new TreeModelEvent(source, path, childIndices, children);
            }
            ((TreeModelListener)listeners[i + 1]).treeStructureChanged(e);
        }
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.listenerList.remove(TreeModelListener.class, l);
    }

    public void sortByColumn(int column, boolean order) {
    }

    public boolean supportsSorting() {
        return this.supportsSorting;
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    private CCTNode[] getPathToRoot(CCTNode aNode, int depth) {
        CCTNode[] retNodes;
        if (aNode == null) {
            if (depth == 0) {
                return null;
            }
            retNodes = new CCTNode[depth];
        } else {
            retNodes = aNode == this.root ? new CCTNode[depth] : this.getPathToRoot(aNode.getParent(), ++depth);
            retNodes[retNodes.length - depth] = aNode;
        }
        return retNodes;
    }
}

