/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.application.snapshot;

import java.awt.Image;
import org.graalvm.visualvm.application.snapshot.ApplicationSnapshot;
import org.graalvm.visualvm.core.datasource.DataSource;
import org.graalvm.visualvm.core.datasupport.Utils;
import org.graalvm.visualvm.core.snapshot.Snapshot;
import org.graalvm.visualvm.core.snapshot.SnapshotDescriptor;
import org.graalvm.visualvm.core.snapshot.SnapshotsSupport;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class ApplicationSnapshotDescriptor
extends SnapshotDescriptor<ApplicationSnapshot> {
    private static final Image NODE_ICON = ImageUtilities.loadImage((String)"org/graalvm/visualvm/core/ui/resources/application.png", (boolean)true);

    public ApplicationSnapshotDescriptor(ApplicationSnapshot snapshot) {
        super((Snapshot)snapshot, ApplicationSnapshotDescriptor.resolveSnapshotName((Snapshot)snapshot), NbBundle.getMessage(ApplicationSnapshotDescriptor.class, (String)"DESCR_ApplicationSnapshot"), ApplicationSnapshotDescriptor.resolveIcon(snapshot), ApplicationSnapshotDescriptor.resolvePosition((DataSource)snapshot, (int)0x7FFFFFFE, (boolean)true), 0);
    }

    private static Image resolveIcon(ApplicationSnapshot snapshot) {
        Image persistedIcon;
        Image icon = NODE_ICON;
        String persistedIconString = snapshot.getStorage().getCustomProperty("prop_icon");
        if (persistedIconString != null && (persistedIcon = Utils.stringToImage((String)persistedIconString)) != null) {
            icon = persistedIcon;
        }
        return icon != null ? SnapshotsSupport.getInstance().createSnapshotIcon(icon) : null;
    }
}

