/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.immutable;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.Function4;
import scala.Function5;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnce$;
import scala.collection.IterableOnceExtensionMethods$;
import scala.collection.Iterator;
import scala.collection.LinearSeqOps;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.generic.SerializeEnd$;
import scala.collection.immutable.AbstractSeq;
import scala.collection.immutable.LazyList$;
import scala.collection.immutable.LinearSeq;
import scala.collection.immutable.Stream$;
import scala.collection.immutable.Stream$Deferrer$;
import scala.collection.immutable.Stream$cons$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Builder;
import scala.collection.mutable.StringBuilder;
import scala.math.Integral;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$Evaluating$;
import scala.runtime.LazyVals$NullValue$;
import scala.runtime.ObjectRef;
import scala.runtime.Scala3RunTime$;

public abstract class Stream<A>
extends AbstractSeq<A>
implements LinearSeq<A>,
Serializable {
    private static final long serialVersionUID = 3L;

    public static <A, B> Stream<B> collectedTail(B b, Stream<A> stream, PartialFunction<A, B> partialFunction) {
        return Stream$.MODULE$.collectedTail(b, stream, partialFunction);
    }

    public static <A> Stream<A> continually(Function0<A> function0) {
        return Stream$.MODULE$.continually(function0);
    }

    public static Object fill(int n, Function0 function0) {
        return Stream$.MODULE$.fill(n, function0);
    }

    public static Object fill(int n, int n2, Function0 function0) {
        return Stream$.MODULE$.fill(n, n2, function0);
    }

    public static Object fill(int n, int n2, int n3, Function0 function0) {
        return Stream$.MODULE$.fill(n, n2, n3, function0);
    }

    public static Object fill(int n, int n2, int n3, int n4, Function0 function0) {
        return Stream$.MODULE$.fill(n, n2, n3, n4, function0);
    }

    public static Object fill(int n, int n2, int n3, int n4, int n5, Function0 function0) {
        return Stream$.MODULE$.fill(n, n2, n3, n4, n5, function0);
    }

    public static <A> Stream<A> filteredTail(Stream<A> stream, Function1<A, Object> function1, boolean bl) {
        return Stream$.MODULE$.filteredTail(stream, function1, bl);
    }

    public static Stream<Object> from(int n) {
        return Stream$.MODULE$.from(n);
    }

    public static Stream<Object> from(int n, int n2) {
        return Stream$.MODULE$.from(n, n2);
    }

    public static <A> Stream<A> from(IterableOnce<A> iterableOnce) {
        return Stream$.MODULE$.from((IterableOnce)iterableOnce);
    }

    public static <A> Stream<A> fromIterator(Iterator<A> iterator) {
        return Stream$.MODULE$.fromIterator(iterator);
    }

    public static <A> Stream<A> iterate(A a, Function1<A, A> function1) {
        return Stream$.MODULE$.iterate(a, function1);
    }

    public static Object iterate(Object object, int n, Function1 function1) {
        return Stream$.MODULE$.iterate(object, n, function1);
    }

    public static <A> Builder<A, Stream<A>> newBuilder() {
        return Stream$.MODULE$.newBuilder();
    }

    public static Object range(Object object, Object object2, Integral integral) {
        return Stream$.MODULE$.range(object, object2, integral);
    }

    public static Object range(Object object, Object object2, Object object3, Integral integral) {
        return Stream$.MODULE$.range(object, object2, object3, integral);
    }

    public static Object tabulate(int n, Function1 function1) {
        return Stream$.MODULE$.tabulate(n, function1);
    }

    public static Object tabulate(int n, int n2, Function2 function2) {
        return Stream$.MODULE$.tabulate(n, n2, function2);
    }

    public static Object tabulate(int n, int n2, int n3, Function3 function3) {
        return Stream$.MODULE$.tabulate(n, n2, n3, function3);
    }

    public static Object tabulate(int n, int n2, int n3, int n4, Function4 function4) {
        return Stream$.MODULE$.tabulate(n, n2, n3, n4, function4);
    }

    public static Object tabulate(int n, int n2, int n3, int n4, int n5, Function5 function5) {
        return Stream$.MODULE$.tabulate(n, n2, n3, n4, n5, function5);
    }

    public static <A> Function0 toDeferrer(Function0<Stream<A>> function0) {
        return Stream$.MODULE$.toDeferrer(function0);
    }

    public static SeqOps unapplySeq(SeqOps seqOps) {
        return Stream$.MODULE$.unapplySeq(seqOps);
    }

    public static Object unfold(Object object, Function1 function1) {
        return Stream$.MODULE$.unfold(object, function1);
    }

    public Stream() {
        LinearSeqOps.$init$(this);
        scala.collection.LinearSeq.$init$(this);
        LinearSeq.$init$(this);
    }

    @Override
    public Option<A> headOption() {
        return LinearSeqOps.headOption$(this);
    }

    @Override
    public Iterator<A> iterator() {
        return LinearSeqOps.iterator$(this);
    }

    @Override
    public int length() {
        return LinearSeqOps.length$(this);
    }

    @Override
    public A last() {
        return (A)LinearSeqOps.last$(this);
    }

    @Override
    public int lengthCompare(int len) {
        return LinearSeqOps.lengthCompare$((LinearSeqOps)this, len);
    }

    @Override
    public int lengthCompare(Iterable<?> that) {
        return LinearSeqOps.lengthCompare$((LinearSeqOps)this, that);
    }

    @Override
    public boolean isDefinedAt(int x) {
        return LinearSeqOps.isDefinedAt$(this, x);
    }

    @Override
    public A apply(int n) throws IndexOutOfBoundsException {
        return (A)LinearSeqOps.apply$(this, n);
    }

    @Override
    public boolean forall(Function1<A, Object> p) {
        return LinearSeqOps.forall$(this, p);
    }

    @Override
    public boolean exists(Function1<A, Object> p) {
        return LinearSeqOps.exists$(this, p);
    }

    @Override
    public <A1> boolean contains(A1 elem) {
        return LinearSeqOps.contains$(this, elem);
    }

    @Override
    public <B> boolean sameElements(IterableOnce<B> that) {
        return LinearSeqOps.sameElements$(this, that);
    }

    @Override
    public int segmentLength(Function1<A, Object> p, int from) {
        return LinearSeqOps.segmentLength$(this, p, from);
    }

    @Override
    public int indexWhere(Function1<A, Object> p, int from) {
        return LinearSeqOps.indexWhere$(this, p, from);
    }

    @Override
    public int lastIndexWhere(Function1<A, Object> p, int end) {
        return LinearSeqOps.lastIndexWhere$(this, p, end);
    }

    @Override
    public Option<A> findLast(Function1<A, Object> p) {
        return LinearSeqOps.findLast$(this, p);
    }

    @Override
    public Iterator<Stream<A>> tails() {
        return LinearSeqOps.tails$(this);
    }

    @Override
    public String stringPrefix() {
        return scala.collection.LinearSeq.stringPrefix$(this);
    }

    @Override
    public /* synthetic */ boolean scala$collection$LinearSeqOps$$super$sameElements(IterableOnce that) {
        return SeqOps.sameElements$(this, that);
    }

    public abstract Stream<A> force();

    @Override
    public SeqFactory<Stream> iterableFactory() {
        return Stream$.MODULE$;
    }

    @Override
    public String className() {
        return "Stream";
    }

    @Override
    public final <U> void foreach(Function1<A, U> f) {
        while (!this_.isEmpty()) {
            f.apply(this_.head());
            Stream this_ = this_.tail();
        }
    }

    @Override
    public final Option<A> find(Function1<A, Object> p) {
        while (!this_.isEmpty()) {
            if (BoxesRunTime.unboxToBoolean(p.apply(this_.head()))) {
                return Some$.MODULE$.apply(this_.head());
            }
            Stream this_ = this_.tail();
        }
        return None$.MODULE$;
    }

    @Override
    public Stream<A> take(int n) {
        if (n <= 0 || this.isEmpty()) {
            return Stream$.MODULE$.empty();
        }
        if (n == 1) {
            return new Cons(this.head(), Stream::take$$anonfun$1);
        }
        return new Cons(this.head(), () -> this.take$$anonfun$2(n));
    }

    @Override
    public final <B> B foldLeft(B z, Function2<B, A, B> op) {
        while (!this_.isEmpty()) {
            Stream stream = this_.tail();
            B b = op.apply(z, this_.head());
            Stream this_ = stream;
            z = b;
        }
        return z;
    }

    public final <B> Stream<B> append(Function0<IterableOnce<B>> rest) {
        return this.lazyAppendedAll(rest);
    }

    public Object writeReplace() {
        if (this.nonEmpty() && this.tailDefined()) {
            return new SerializationProxy(this);
        }
        return this;
    }

    public void print() {
        Console$.MODULE$.print(this.force().mkString(", "));
    }

    public void print(String sep) {
        Console$.MODULE$.print(this.force().mkString(sep));
    }

    public <B> Stream<B> lazyAppendedAll(Function0<IterableOnce<B>> suffix) {
        if (this.isEmpty()) {
            return (Stream)this.iterableFactory().from(suffix.apply());
        }
        return Stream$cons$.MODULE$.apply(this.head(), () -> this.lazyAppendedAll$$anonfun$1(suffix));
    }

    @Override
    public <B> Stream<B> scanLeft(B z, Function2<B, A, B> op) {
        if (this.isEmpty()) {
            return (Stream)((SeqOps)this.iterableFactory().empty()).$plus$colon(z);
        }
        return Stream$cons$.MODULE$.apply(z, () -> this.scanLeft$$anonfun$1(op, z));
    }

    @Override
    public final <B> B reduceLeft(Function2<B, A, B> f) {
        if (this.isEmpty()) {
            throw new UnsupportedOperationException("empty.reduceLeft");
        }
        Object reducedRes = this.head();
        Stream left = this.tail();
        while (!left.isEmpty()) {
            reducedRes = f.apply(reducedRes, left.head());
            left = left.tail();
        }
        return (B)reducedRes;
    }

    @Override
    public Tuple2<Stream<A>, Stream<A>> partition(Function1<A, Object> p) {
        return Tuple2$.MODULE$.apply(this.filter((Function1)p), this.filterNot((Function1)p));
    }

    @Override
    public Stream<A> filter(Function1<A, Object> pred) {
        return this.filterImpl(pred, false);
    }

    @Override
    public Stream<A> filterNot(Function1<A, Object> pred) {
        return this.filterImpl(pred, true);
    }

    public Stream<A> filterImpl(Function1<A, Object> p, boolean isFlipped) {
        Stream rest = (Stream)this.coll();
        while (rest.nonEmpty() && BoxesRunTime.unboxToBoolean(p.apply(rest.head())) == isFlipped) {
            rest = rest.tail();
        }
        if (rest.nonEmpty()) {
            return Stream$.MODULE$.filteredTail(rest, p, isFlipped);
        }
        return (Stream)this.iterableFactory().empty();
    }

    @Override
    public final scala.collection.WithFilter<A, Stream> withFilter(Function1<A, Object> p) {
        return Stream$.MODULE$.withFilter((Stream)this.coll(), p);
    }

    @Override
    public final <B> Stream<B> prepended(B elem) {
        return Stream$cons$.MODULE$.apply(elem, this::prepended$$anonfun$1);
    }

    @Override
    public final <B> Stream<B> map(Function1<A, B> f) {
        if (this.isEmpty()) {
            return (Stream)this.iterableFactory().empty();
        }
        return Stream$cons$.MODULE$.apply(f.apply(this.head()), () -> this.map$$anonfun$1(f));
    }

    @Override
    public final <B> Stream<B> collect(PartialFunction<A, B> pf) {
        while (!this_.isEmpty()) {
            ObjectRef<Object> newHead = ObjectRef.create(null);
            Function1<A, Object> runWith = pf.runWith((B b) -> {
                newHead$1.elem = b;
            });
            if (BoxesRunTime.unboxToBoolean(runWith.apply(this_.head()))) {
                return Stream$.MODULE$.collectedTail(newHead.elem, this_, pf);
            }
            Stream this_ = this_.tail();
        }
        return Stream$.MODULE$.empty();
    }

    @Override
    public final <B> Option<B> collectFirst(PartialFunction<A, B> pf) {
        while (!this_.isEmpty()) {
            ObjectRef<Object> newHead = ObjectRef.create(null);
            Function1<A, Object> runWith = pf.runWith((B b) -> {
                newHead$2.elem = b;
            });
            if (BoxesRunTime.unboxToBoolean(runWith.apply(this_.head()))) {
                return Some$.MODULE$.apply(newHead.elem);
            }
            Stream this_ = this_.tail();
        }
        return None$.MODULE$;
    }

    @Override
    public final <B> Stream<B> flatMap(Function1<A, IterableOnce<B>> f) {
        if (this.isEmpty()) {
            return (Stream)this.iterableFactory().empty();
        }
        ObjectRef<Stream> nonEmptyPrefix = ObjectRef.create((Stream)this.coll());
        Stream prefix = (Stream)this.iterableFactory().from(f.apply(((Stream)nonEmptyPrefix.elem).head()));
        while (!((Stream)nonEmptyPrefix.elem).isEmpty() && prefix.isEmpty()) {
            nonEmptyPrefix.elem = ((Stream)nonEmptyPrefix.elem).tail();
            if (((Stream)nonEmptyPrefix.elem).isEmpty()) continue;
            prefix = (Stream)this.iterableFactory().from(f.apply(((Stream)nonEmptyPrefix.elem).head()));
        }
        if (((Stream)nonEmptyPrefix.elem).isEmpty()) {
            return (Stream)this.iterableFactory().empty();
        }
        return prefix.lazyAppendedAll(() -> Stream.flatMap$$anonfun$1(nonEmptyPrefix, f));
    }

    @Override
    public final <B> Stream<Tuple2<A, B>> zip(IterableOnce<B> that) {
        Object object;
        IterableOnce iterableOnce;
        if (this.isEmpty() || IterableOnceExtensionMethods$.MODULE$.isEmpty$extension(iterableOnce = IterableOnce$.MODULE$.iterableOnceExtensionMethods(that))) {
            return (Stream)this.iterableFactory().empty();
        }
        IterableOnce<B> iterableOnce2 = that;
        if (iterableOnce2 instanceof Iterable) {
            Iterable iterable;
            Iterable that2 = iterable = (Iterable)iterableOnce2;
            object = that2;
        } else {
            object = LazyList$.MODULE$.from((IterableOnce)that);
        }
        Object thatIterable = object;
        return Stream$cons$.MODULE$.apply(Tuple2$.MODULE$.apply(this.head(), thatIterable.head()), () -> this.zip$$anonfun$1((Iterable)thatIterable));
    }

    @Override
    public final Stream<Tuple2<A, Object>> zipWithIndex() {
        return this.zip(LazyList$.MODULE$.from(0));
    }

    public abstract boolean tailDefined();

    @Override
    public StringBuilder addString(StringBuilder sb, String start, String sep, String end) {
        this.force();
        this.addStringNoForce(sb.underlying(), start, sep, end);
        return sb;
    }

    private java.lang.StringBuilder addStringNoForce(java.lang.StringBuilder b, String start, String sep, String end) {
        b.append(start);
        if (this.nonEmpty()) {
            b.append(this.head());
            ObjectRef<Stream> cursor = ObjectRef.create(this);
            if (this.tailDefined()) {
                Stream scout = this.tail();
                if ((Stream)cursor.elem != scout) {
                    cursor.elem = scout;
                    if (scout.tailDefined()) {
                        scout = scout.tail();
                        while ((Stream)cursor.elem != scout && scout.tailDefined()) {
                            Stream.appendCursorElement$1(b, sep, cursor);
                            cursor.elem = ((Stream)cursor.elem).tail();
                            if (!(scout = scout.tail()).tailDefined()) continue;
                            scout = scout.tail();
                        }
                    }
                }
                if (!scout.tailDefined()) {
                    while ((Stream)cursor.elem != scout) {
                        Stream.appendCursorElement$1(b, sep, cursor);
                        cursor.elem = ((Stream)cursor.elem).tail();
                    }
                    if (((Stream)cursor.elem).nonEmpty()) {
                        Stream.appendCursorElement$1(b, sep, cursor);
                    }
                } else {
                    Stream runner = this;
                    int k = 0;
                    while (runner != scout) {
                        runner = runner.tail();
                        scout = scout.tail();
                        ++k;
                    }
                    if ((Stream)cursor.elem == scout && k > 0) {
                        Stream.appendCursorElement$1(b, sep, cursor);
                        cursor.elem = ((Stream)cursor.elem).tail();
                    }
                    while ((Stream)cursor.elem != scout) {
                        Stream.appendCursorElement$1(b, sep, cursor);
                        cursor.elem = ((Stream)cursor.elem).tail();
                    }
                }
            }
            if (((Stream)cursor.elem).nonEmpty()) {
                if (!((Stream)cursor.elem).tailDefined()) {
                    b.append(sep).append("<not computed>");
                } else {
                    b.append(sep).append("<cycle>");
                }
            }
        }
        b.append(end);
        return b;
    }

    @Override
    public String toString() {
        return this.addStringNoForce(new java.lang.StringBuilder(this.className()), "(", ", ", ")").toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean hasDefiniteSize() {
        if (this.isEmpty()) return true;
        if (this.tailDefined()) {
            Stream these = this.tail();
            for (Stream those = this; those != these; those = those.tail()) {
                if (these.isEmpty()) {
                    return true;
                }
                if (!these.tailDefined()) {
                    return false;
                }
                if ((these = these.tail()).isEmpty()) {
                    return true;
                }
                if (!these.tailDefined()) {
                    return false;
                }
                if (those != (these = these.tail())) continue;
                return false;
            }
            if (!false) return false;
            return true;
        }
        if (false) return true;
        return false;
    }

    private static final Stream take$$anonfun$1() {
        return Stream$.MODULE$.empty();
    }

    private final Stream take$$anonfun$2(int n$1) {
        return this.tail().take(n$1 - 1);
    }

    private final Stream lazyAppendedAll$$anonfun$1(Function0 suffix$1) {
        return this.tail().lazyAppendedAll(suffix$1);
    }

    private final Stream scanLeft$$anonfun$1(Function2 op$1, Object z$1) {
        return this.tail().scanLeft(op$1.apply(z$1, this.head()), op$1);
    }

    private final Stream prepended$$anonfun$1() {
        return (Stream)this.coll();
    }

    private final Stream map$$anonfun$1(Function1 f$1) {
        return this.tail().map(f$1);
    }

    private static final IterableOnce flatMap$$anonfun$1(ObjectRef nonEmptyPrefix$1, Function1 f$2) {
        return ((Stream)nonEmptyPrefix$1.elem).tail().flatMap(f$2);
    }

    private final Stream zip$$anonfun$1(Iterable thatIterable$1) {
        return this.tail().zip((IterableOnce)thatIterable$1.tail());
    }

    private static final void appendCursorElement$1(java.lang.StringBuilder b$1, String sep$1, ObjectRef cursor$1) {
        b$1.append(sep$1).append(((Stream)cursor$1.elem).head());
    }

    public static final class Cons<A>
    extends Stream<A> {
        private static final long serialVersionUID = 3L;
        private final A head;
        private volatile Stream<A> tlVal;
        private volatile Function0<Stream<A>> tlGen;

        public Cons(A head, Function0<Stream<A>> tl) {
            this.head = head;
            this.tlGen = tl;
        }

        @Override
        public A head() {
            return this.head;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean tailDefined() {
            return this.tlGen == null;
        }

        @Override
        public Stream<A> tail() {
            if (!this.tailDefined()) {
                Cons cons = this;
                synchronized (cons) {
                    if (!this.tailDefined()) {
                        Function0<Stream<A>> x$proxy2 = this.tlGen;
                        if (x$proxy2 == null) {
                            throw Scala3RunTime$.MODULE$.nnFail();
                        }
                        this.tlVal = x$proxy2.apply();
                        this.tlGen = null;
                        v0 = BoxedUnit.UNIT;
                    } else {
                        v0 = BoxedUnit.UNIT;
                    }
                }
            }
            return this.tlVal;
        }

        @Override
        public Cons<A> force() {
            Stream these = this;
            Stream those = this;
            if (!these.isEmpty()) {
                these = these.tail();
            }
            while (those != these) {
                if (these.isEmpty()) {
                    return this;
                }
                if ((these = these.tail()).isEmpty()) {
                    return this;
                }
                if ((these = these.tail()) == those) {
                    return this;
                }
                those = ((Stream)those).tail();
            }
            return this;
        }
    }

    public static final class Deferrer<A> {
        private final Function0<Stream<A>> l;

        public static <B, A> Stream<B> $hash$colon$colon$extension(Function0 function0, B b) {
            return Stream$Deferrer$.MODULE$.$hash$colon$colon$extension(function0, b);
        }

        public static <B, A> Stream<B> $hash$colon$colon$colon$extension(Function0 function0, Stream<B> stream) {
            return Stream$Deferrer$.MODULE$.$hash$colon$colon$colon$extension(function0, stream);
        }

        public static <A> boolean equals$extension(Function0 function0, Object object) {
            return Stream$Deferrer$.MODULE$.equals$extension(function0, object);
        }

        public static <A> int hashCode$extension(Function0 function0) {
            return Stream$Deferrer$.MODULE$.hashCode$extension(function0);
        }

        public Deferrer(Function0<Stream<A>> l) {
            this.l = l;
        }

        public int hashCode() {
            return Stream$Deferrer$.MODULE$.hashCode$extension(this.scala$collection$immutable$Stream$Deferrer$$l());
        }

        public boolean equals(Object x$0) {
            return Stream$Deferrer$.MODULE$.equals$extension(this.scala$collection$immutable$Stream$Deferrer$$l(), x$0);
        }

        public Function0<Stream<A>> scala$collection$immutable$Stream$Deferrer$$l() {
            return this.l;
        }

        public <B> Stream<B> $hash$colon$colon(B elem) {
            return Stream$Deferrer$.MODULE$.$hash$colon$colon$extension(this.scala$collection$immutable$Stream$Deferrer$$l(), elem);
        }

        public <B> Stream<B> $hash$colon$colon$colon(Stream<B> prefix) {
            return Stream$Deferrer$.MODULE$.$hash$colon$colon$colon$extension(this.scala$collection$immutable$Stream$Deferrer$$l(), prefix);
        }
    }

    public static class SerializationProxy<A>
    implements Serializable {
        private static final long serialVersionUID = 3L;
        private transient Stream<A> coll;

        public SerializationProxy(Stream<A> coll) {
            this.coll = coll;
        }

        public Stream<A> coll() {
            return this.coll;
        }

        public void coll_$eq(Stream<A> x$1) {
            this.coll = x$1;
        }

        private void writeObject(ObjectOutputStream out) {
            out.defaultWriteObject();
            Stream these = this.coll();
            while (these.nonEmpty() && these.tailDefined()) {
                out.writeObject(these.head());
                these = these.tail();
            }
            out.writeObject(SerializeEnd$.MODULE$);
            out.writeObject(these);
        }

        private void readObject(ObjectInputStream in) {
            in.defaultReadObject();
            ArrayBuffer init2 = new ArrayBuffer();
            boolean initRead = false;
            while (!initRead) {
                Object object = in.readObject();
                if (SerializeEnd$.MODULE$.equals(object)) {
                    initRead = true;
                    continue;
                }
                Object a = object;
                init2.$plus$eq(a);
            }
            Stream tail = (Stream)in.readObject();
            this.coll_$eq((Stream)tail.$plus$plus$colon((IterableOnce)init2));
        }

        public Object readResolve() {
            return this.coll();
        }
    }

    public static final class WithFilter<A>
    extends scala.collection.WithFilter<A, Stream> {
        private static final VarHandle filtered$lzy1$lzyHandle = MethodHandles.lookup().findVarHandle(WithFilter.class, "filtered$lzy1", Object.class);
        private final Function1<A, Object> p;
        private Stream<A> s;
        private volatile Object filtered$lzy1;

        public WithFilter(Stream<A> l, Function1<A, Object> p) {
            this.p = p;
            this.s = l;
        }

        private Stream<A> filtered() {
            Object object = this.filtered$lzy1;
            if (object instanceof Stream) {
                return (Stream)object;
            }
            if (object == LazyVals$NullValue$.MODULE$) {
                return null;
            }
            return (Stream)this.filtered$lzyINIT1();
        }

        private Object filtered$lzyINIT1() {
            Object object;
            block8: {
                while (true) {
                    if ((object = this.filtered$lzy1) == null) {
                        if (!filtered$lzy1$lzyHandle.compareAndSet(this, null, LazyVals$Evaluating$.MODULE$)) continue;
                        Object object2 = null;
                        Object object3 = null;
                        try {
                            Object f = this.s.filter((Function1)this.p);
                            this.s = null;
                            object3 = f;
                            object2 = object3 == null ? LazyVals$NullValue$.MODULE$ : object3;
                        }
                        finally {
                            if (!filtered$lzy1$lzyHandle.compareAndSet(this, LazyVals$Evaluating$.MODULE$, object2)) {
                                LazyVals.Waiting waiting = (LazyVals.Waiting)this.filtered$lzy1;
                                filtered$lzy1$lzyHandle.compareAndSet(this, waiting, object2);
                                waiting.countDown();
                            }
                        }
                        return object3;
                    }
                    if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                    if (object == LazyVals$Evaluating$.MODULE$) {
                        filtered$lzy1$lzyHandle.compareAndSet(this, object, new LazyVals.Waiting());
                        continue;
                    }
                    if (!(object instanceof LazyVals.Waiting)) break;
                    ((LazyVals.Waiting)object).await();
                }
                return null;
            }
            return object;
        }

        @Override
        public <B> Stream<B> map(Function1<A, B> f) {
            return this.filtered().map((Function1)f);
        }

        @Override
        public <B> Stream<B> flatMap(Function1<A, IterableOnce<B>> f) {
            return this.filtered().flatMap((Function1)f);
        }

        @Override
        public <U> void foreach(Function1<A, U> f) {
            this.filtered().foreach(f);
        }

        @Override
        public scala.collection.WithFilter<A, Stream> withFilter(Function1<A, Object> q) {
            return new WithFilter<A>(this.filtered(), q);
        }
    }
}

