/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.startup.importSettings.transfer.backend.providers.vswin;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.startup.importSettings.TransferSettingsConfiguration;
import com.intellij.ide.startup.importSettings.TransferableIdeId;
import com.intellij.ide.startup.importSettings.TransferableIdeVersionId;
import com.intellij.ide.startup.importSettings.fus.TransferSettingsCollector;
import com.intellij.ide.startup.importSettings.models.BaseIdeVersion;
import com.intellij.ide.startup.importSettings.models.FailedIdeVersion;
import com.intellij.ide.startup.importSettings.models.Settings;
import com.intellij.ide.startup.importSettings.providers.TransferSettingsProvider;
import com.intellij.ide.startup.importSettings.providers.vswin.utilities.VSProfileDetectorUtils;
import com.intellij.ide.startup.importSettings.transfer.backend.models.IdeVersion;
import com.intellij.ide.startup.importSettings.transfer.backend.providers.vswin.KnownPlugins;
import com.intellij.ide.startup.importSettings.transfer.backend.providers.vswin.VSWinTransferSettingsProviderKt;
import com.intellij.ide.startup.importSettings.transfer.backend.providers.vswin.parsers.VSIsolationIniParser;
import com.intellij.ide.startup.importSettings.transfer.backend.providers.vswin.parsers.VSParser;
import com.intellij.ide.startup.importSettings.transfer.backend.providers.vswin.parsers.VSRegistryParserNew;
import com.intellij.ide.startup.importSettings.transfer.backend.providers.vswin.utilities.VSHive;
import com.intellij.ide.startup.importSettings.transfer.backend.providers.vswin.utilities.VSHiveDetourFileNotFoundException;
import com.intellij.ide.startup.importSettings.transfer.backend.providers.vswin.utilities.VSPossibleVersionsEnumerator;
import com.intellij.ide.startup.importSettings.ui.representation.TransferSettingsRightPanelChooser;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.gridLayout.UnscaledGapsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001'B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\t0\u0013H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u000e\u0010\u0018\u001a\u00020\u0017H\u0096@\u00a2\u0006\u0002\u0010\u0019J\b\u0010\u001a\u001a\u00020\u001bH\u0002J\u0017\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001bH\u0002\u00a2\u0006\u0004\b\u001f\u0010 J\u0018\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\f\u001a\u00070\t\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000e\u001a\u00070\t\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000f\u001a\u00070\t\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/intellij/ide/startup/importSettings/transfer/backend/providers/vswin/VSWinTransferSettingsProvider;", "Lcom/intellij/ide/startup/importSettings/providers/TransferSettingsProvider;", "<init>", "()V", "transferableIdeId", "Lcom/intellij/ide/startup/importSettings/TransferableIdeId;", "getTransferableIdeId", "()Lcom/intellij/ide/startup/importSettings/TransferableIdeId;", "name", "", "getName", "()Ljava/lang/String;", "defaultAdvice", "Lorg/jetbrains/annotations/Nls;", "failureReason", "noSettings", "vsEnumerator", "Lcom/intellij/ide/startup/importSettings/transfer/backend/providers/vswin/utilities/VSPossibleVersionsEnumerator;", "getIdeVersions", "", "Lcom/intellij/ide/startup/importSettings/models/BaseIdeVersion;", "skipIds", "isAvailable", "", "hasDataToImport", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "timeFn", "", "convertTimeFn", "Lkotlin/time/Duration;", "time", "convertTimeFn-5sfh64U", "(J)J", "getRightPanel", "Lcom/intellij/ide/startup/importSettings/ui/representation/TransferSettingsRightPanelChooser;", "ideV", "Lcom/intellij/ide/startup/importSettings/transfer/backend/models/IdeVersion;", "config", "Lcom/intellij/ide/startup/importSettings/TransferSettingsConfiguration;", "VSWinTransferSettingsRightPanelChooser", "intellij.ide.startup.importSettings"})
@SourceDebugExtension(value={"SMAP\nVSWinTransferSettingsProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VSWinTransferSettingsProvider.kt\ncom/intellij/ide/startup/importSettings/transfer/backend/providers/vswin/VSWinTransferSettingsProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,215:1\n1617#2,9:216\n1869#2:225\n1870#2:228\n1626#2:229\n1#3:226\n1#3:227\n*S KotlinDebug\n*F\n+ 1 VSWinTransferSettingsProvider.kt\ncom/intellij/ide/startup/importSettings/transfer/backend/providers/vswin/VSWinTransferSettingsProvider\n*L\n47#1:216,9\n47#1:225\n47#1:228\n47#1:229\n47#1:227\n*E\n"})
public final class VSWinTransferSettingsProvider
implements TransferSettingsProvider {
    @NotNull
    private final TransferableIdeId transferableIdeId = TransferableIdeId.VisualStudio;
    @NotNull
    private final String name;
    @NotNull
    private final String defaultAdvice;
    @NotNull
    private final String failureReason;
    @NotNull
    private final String noSettings;
    @NotNull
    private final VSPossibleVersionsEnumerator vsEnumerator;

    public VSWinTransferSettingsProvider() {
        this.name = "Visual Studio";
        String string = IdeBundle.message((String)"transfersettings.vs.quit.advise", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this.defaultAdvice = string;
        Object[] objectArray = new Object[]{this.defaultAdvice};
        String string2 = IdeBundle.message((String)"transfersettings.vs.failureReason", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        this.failureReason = string2;
        String string3 = IdeBundle.message((String)"transfersettings.vs.noSettings", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        this.noSettings = string3;
        this.vsEnumerator = new VSPossibleVersionsEnumerator();
    }

    @Override
    @NotNull
    public TransferableIdeId getTransferableIdeId() {
        return this.transferableIdeId;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<BaseIdeVersion> getIdeVersions(@NotNull List<String> skipIds) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(skipIds, (String)"skipIds");
        Ref.ObjectRef speedResult = new Ref.ObjectRef();
        speedResult.element = "";
        List badVersions = new ArrayList();
        Iterable $this$mapNotNull$iv = this.vsEnumerator.get();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            IdeVersion ideVersion;
            block19: {
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                VSHive hive = (VSHive)element$iv$iv;
                boolean bl2 = false;
                long start = this.timeFn();
                VSWinTransferSettingsProviderKt.access$getLogger$p().info("Started processing " + hive.getHiveString());
                String instanceIdForIdeVersion = "VisualStudio" + hive.getHiveString();
                String customRt = System.getProperty("trl.oneHs");
                if (customRt != null && !Intrinsics.areEqual((Object)hive.getHiveString(), (Object)customRt)) {
                    ideVersion = null;
                } else {
                    Icon icon;
                    speedResult.element = speedResult.element + "START " + instanceIdForIdeVersion + " ---------------------------\n";
                    String string = System.getProperty("trl.transfer.debug");
                    String name = (string != null ? Boolean.parseBoolean(string) : false) ? StringsKt.replace$default((String)hive.getPresentationString(), (String)"Visual Studio", (String)"VS", (boolean)false, (int)4, null) + " " + hive.getHiveString() : hive.getPresentationString();
                    TransferableIdeId transferableIdeId = this.getTransferableIdeId();
                    String string2 = hive.getHiveString();
                    Intrinsics.checkNotNullExpressionValue((Object)AllIcons.Idea_logo_welcome, (String)"Idea_logo_welcome");
                    Object object = this.defaultAdvice;
                    String string3 = this.failureReason;
                    FailedIdeVersion failedIde = new FailedIdeVersion(transferableIdeId, instanceIdForIdeVersion, icon, name, string2, string3, (String)object, true, null, 256, null);
                    long registryTime = this.timeFn();
                    try {
                        object = hive.getRegistry();
                    }
                    catch (VSHiveDetourFileNotFoundException vSHiveDetourFileNotFoundException) {
                        VSWinTransferSettingsProviderKt.access$getLogger$p().info("File not found. Probably vs was uninstalled");
                        ideVersion = null;
                        break block19;
                    }
                    Object registry = object;
                    long res2 = this.convertTimeFn-5sfh64U(this.timeFn() - registryTime);
                    speedResult.element = speedResult.element + "registryTime " + Duration.toString-impl((long)res2) + "\n";
                    TransferSettingsCollector.INSTANCE.logPerformanceMeasured-Wn2Vu4Y(TransferSettingsCollector.PerformanceMetricType.Registry, TransferableIdeId.VisualStudio, hive.transferableVersion(), res2);
                    if (registry == null) {
                        VSWinTransferSettingsProviderKt.access$getLogger$p().warn("Critical. Failed to init registry");
                        badVersions.add(failedIde);
                        ideVersion = null;
                    } else if (!hive.isInstalled()) {
                        VSWinTransferSettingsProviderKt.access$getLogger$p().info("This instance of Visual Studio was uninstalled");
                        ideVersion = null;
                    } else {
                        Icon icon2;
                        CharSequence $this$getIdeVersions_u24lambda_u240_u242;
                        String string4;
                        StringBuilder stringBuilder;
                        long subNameTime = this.timeFn();
                        StringBuilder $this$getIdeVersions_u24lambda_u240_u240 = stringBuilder = new StringBuilder();
                        boolean bl3 = false;
                        try {
                            String string5 = hive.getEdition();
                            if (string5 == null) {
                                string5 = "";
                            }
                            $this$getIdeVersions_u24lambda_u240_u240.append(string5);
                            VSIsolationIniParser vSIsolationIniParser = hive.getIsolation();
                            $this$getIdeVersions_u24lambda_u240_u240.append((vSIsolationIniParser != null ? vSIsolationIniParser.isPreview() : false) ? " Preview" : "");
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        String it = VSProfileDetectorUtils.INSTANCE.rootSuffixStabilizer(hive);
                        boolean bl4 = false;
                        if (it != null) {
                            $this$getIdeVersions_u24lambda_u240_u240.append(" (" + it + ")");
                        }
                        StringBuilder it2 = stringBuilder;
                        boolean bl5 = false;
                        if (((CharSequence)it2).length() == 0) {
                            string4 = null;
                        } else {
                            String string6 = it2.toString();
                            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"toString(...)");
                            string4 = ((Object)StringsKt.trimStart((CharSequence)string6)).toString();
                        }
                        String subName = string4;
                        long res1 = this.convertTimeFn-5sfh64U(this.timeFn() - subNameTime);
                        speedResult.element = speedResult.element + "subname " + Duration.toString-impl((long)res1) + "\n";
                        TransferSettingsCollector.INSTANCE.logPerformanceMeasured-Wn2Vu4Y(TransferSettingsCollector.PerformanceMetricType.SubName, TransferableIdeId.VisualStudio, hive.transferableVersion(), res1);
                        long readSettingsTime = this.timeFn();
                        try {
                            if (((VSRegistryParserNew)registry).getSettingsFile() == null) {
                                String string7 = "Required value was null.";
                                throw new IllegalArgumentException(string7.toString());
                            }
                        }
                        catch (Throwable t) {
                            FailedIdeVersion failedIdeVersion;
                            VSWinTransferSettingsProviderKt.access$getLogger$p().warn("Critical. Failed to read file");
                            VSWinTransferSettingsProviderKt.access$getLogger$p().warn(t);
                            FailedIdeVersion failedIdeVersion2 = failedIdeVersion = failedIde;
                            List list = badVersions;
                            boolean bl6 = false;
                            ((FailedIdeVersion)((Object)$this$getIdeVersions_u24lambda_u240_u242)).setStepsToFix(this.noSettings);
                            list.add(failedIdeVersion);
                            ideVersion = null;
                            break block19;
                        }
                        long res3 = this.convertTimeFn-5sfh64U(this.timeFn() - readSettingsTime);
                        speedResult.element = speedResult.element + "readSettingsFile " + Duration.toString-impl((long)res3) + "\n";
                        TransferSettingsCollector.INSTANCE.logPerformanceMeasured-Wn2Vu4Y(TransferSettingsCollector.PerformanceMetricType.ReadSettingsFile, TransferableIdeId.VisualStudio, hive.transferableVersion(), res3);
                        $this$getIdeVersions_u24lambda_u240_u242 = hive.getRootSuffix();
                        boolean isExperimental = !($this$getIdeVersions_u24lambda_u240_u242 == null || StringsKt.isBlank((CharSequence)$this$getIdeVersions_u24lambda_u240_u242));
                        TransferableIdeId transferableIdeId2 = this.getTransferableIdeId();
                        TransferableIdeVersionId transferableIdeVersionId = hive.transferableVersion();
                        Intrinsics.checkNotNullExpressionValue((Object)AllIcons.TransferSettings.VS, (String)"VS");
                        Date date = hive.getLastUsage();
                        int n = isExperimental ? 1 : 0;
                        IdeVersion l = new IdeVersion(transferableIdeId2, transferableIdeVersionId, instanceIdForIdeVersion, icon2, name, subName, (Function0<? extends Settings>)((Function0)() -> VSWinTransferSettingsProvider.getIdeVersions$lambda$0$3(hive)), date, this, n);
                        long res4 = this.convertTimeFn-5sfh64U(this.timeFn() - start);
                        speedResult.element = speedResult.element + hive.getHiveString() + " " + Duration.toString-impl((long)res4) + "\n\n";
                        ideVersion = l;
                    }
                }
            }
            if (ideVersion == null) continue;
            IdeVersion it$iv$iv = ideVersion;
            boolean bl = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List accessibleVSInstallations = (List)destination$iv$iv;
        if (Boolean.parseBoolean(System.getProperty("trl.transfer.ReSharperGranular"))) {
            SwingUtilities.invokeLater(() -> VSWinTransferSettingsProvider.getIdeVersions$lambda$1(speedResult));
        }
        return CollectionsKt.plus((Collection)accessibleVSInstallations, (Iterable)badVersions);
    }

    @Override
    public boolean isAvailable() {
        return SystemInfoRt.isWindows;
    }

    @Override
    @Nullable
    public Object hasDataToImport(@NotNull Continuation<? super Boolean> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(this, null){
            int label;
            final /* synthetic */ VSWinTransferSettingsProvider this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        return Boxing.boxBoolean((boolean)VSWinTransferSettingsProvider.access$getVsEnumerator$p(this.this$0).hasAny());
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Boolean> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    private final long timeFn() {
        return System.nanoTime();
    }

    private final long convertTimeFn-5sfh64U(long time) {
        return DurationKt.toDuration((long)time, (DurationUnit)DurationUnit.NANOSECONDS);
    }

    @Override
    @NotNull
    public TransferSettingsRightPanelChooser getRightPanel(@NotNull IdeVersion ideV, @NotNull TransferSettingsConfiguration config) {
        Intrinsics.checkNotNullParameter((Object)ideV, (String)"ideV");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        return new VSWinTransferSettingsRightPanelChooser(ideV, config);
    }

    private static final Settings getIdeVersions$lambda$0$3(VSHive $hive) {
        return new VSParser($hive).getSettings();
    }

    private static final void getIdeVersions$lambda$1(Ref.ObjectRef $speedResult) {
        Messages.showInfoMessage((String)((String)$speedResult.element), (String)"Speedrun");
    }

    public static final /* synthetic */ VSPossibleVersionsEnumerator access$getVsEnumerator$p(VSWinTransferSettingsProvider $this) {
        return $this.vsEnumerator;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/ide/startup/importSettings/transfer/backend/providers/vswin/VSWinTransferSettingsProvider$VSWinTransferSettingsRightPanelChooser;", "Lcom/intellij/ide/startup/importSettings/ui/representation/TransferSettingsRightPanelChooser;", "ide", "Lcom/intellij/ide/startup/importSettings/transfer/backend/models/IdeVersion;", "config", "Lcom/intellij/ide/startup/importSettings/TransferSettingsConfiguration;", "<init>", "(Lcom/intellij/ide/startup/importSettings/transfer/backend/models/IdeVersion;Lcom/intellij/ide/startup/importSettings/TransferSettingsConfiguration;)V", "getBottomComponentFactory", "Lkotlin/Function0;", "Ljavax/swing/JComponent;", "intellij.ide.startup.importSettings"})
    private static final class VSWinTransferSettingsRightPanelChooser
    extends TransferSettingsRightPanelChooser {
        @NotNull
        private final IdeVersion ide;

        public VSWinTransferSettingsRightPanelChooser(@NotNull IdeVersion ide, @NotNull TransferSettingsConfiguration config) {
            Intrinsics.checkNotNullParameter((Object)ide, (String)"ide");
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            super(ide, config);
            this.ide = ide;
        }

        @Override
        @NotNull
        public Function0<JComponent> getBottomComponentFactory() {
            return () -> VSWinTransferSettingsRightPanelChooser.getBottomComponentFactory$lambda$0(this);
        }

        private static final JComponent getBottomComponentFactory$lambda$0(VSWinTransferSettingsRightPanelChooser this$0) {
            return this$0.ide.getSettingsCache().getPlugins().values().contains(KnownPlugins.INSTANCE.getReSharper()) ? (JComponent)BuilderKt.panel(VSWinTransferSettingsRightPanelChooser::getBottomComponentFactory$lambda$0$0) : null;
        }

        private static final Unit getBottomComponentFactory$lambda$0$0(Panel $this$panel) {
            Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
            Panel.row$default((Panel)$this$panel, null, VSWinTransferSettingsRightPanelChooser::getBottomComponentFactory$lambda$0$0$0, (int)1, null);
            return Unit.INSTANCE;
        }

        private static final Unit getBottomComponentFactory$lambda$0$0$0(Row $this$row) {
            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
            Icon icon = AllIcons.TransferSettings.Resharper;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Resharper");
            $this$row.icon(icon).customize(UnscaledGapsKt.UnscaledGaps$default((int)0, (int)5, (int)0, (int)5, (int)5, null));
            String string = IdeBundle.message((String)"transfer-settings.vs-win.resharper-settings-found", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            $this$row.label(string);
            return Unit.INSTANCE;
        }
    }
}

