/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.model;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashSet;
import org.jupnp.model.ValidationError;
import org.jupnp.model.ValidationException;
import org.jupnp.model.meta.Device;
import org.jupnp.model.meta.DeviceIdentity;
import org.jupnp.model.meta.Icon;
import org.jupnp.model.meta.Service;
import org.jupnp.model.resource.Resource;
import org.jupnp.util.URIUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Namespace {
    private final Logger logger = LoggerFactory.getLogger(Namespace.class);
    public static final String DEVICE = "/dev";
    public static final String SERVICE = "/svc";
    public static final String CONTROL = "/action";
    public static final String EVENTS = "/event";
    public static final String DESCRIPTOR_FILE = "/desc";
    public static final String CALLBACK_FILE = "/cb";
    protected final URI basePath;
    protected final String decodedPath;

    public Namespace() {
        this("");
    }

    public Namespace(String basePath) {
        this(URI.create(basePath));
    }

    public Namespace(URI basePath) {
        this.basePath = basePath;
        this.decodedPath = basePath.getPath();
    }

    public URI getBasePath() {
        return this.basePath;
    }

    public URI getPath(Device device) {
        return this.appendPathToBaseURI(this.getDevicePath(device));
    }

    public URI getPath(Service service) {
        return this.appendPathToBaseURI(this.getServicePath(service));
    }

    public URI getDescriptorPath(Device device) {
        return this.appendPathToBaseURI(this.getDevicePath((Device)device.getRoot()) + DESCRIPTOR_FILE);
    }

    public String getDescriptorPathString(Device device) {
        return this.decodedPath + this.getDevicePath((Device)device.getRoot()) + DESCRIPTOR_FILE;
    }

    public URI getDescriptorPath(Service service) {
        return this.appendPathToBaseURI(this.getServicePath(service) + DESCRIPTOR_FILE);
    }

    public URI getControlPath(Service service) {
        return this.appendPathToBaseURI(this.getServicePath(service) + CONTROL);
    }

    public URI getIconPath(Icon icon) {
        return this.appendPathToBaseURI(this.getDevicePath(icon.getDevice()) + "/" + icon.getUri().toString());
    }

    public URI getEventSubscriptionPath(Service service) {
        return this.appendPathToBaseURI(this.getServicePath(service) + EVENTS);
    }

    public URI getEventCallbackPath(Service service) {
        return this.appendPathToBaseURI(this.getServicePath(service) + "/event/cb");
    }

    public String getEventCallbackPathString(Service service) {
        return this.decodedPath + this.getServicePath(service) + "/event/cb";
    }

    public URI prefixIfRelative(Device device, URI uri) {
        if (!uri.isAbsolute() && !uri.getPath().startsWith("/")) {
            return this.appendPathToBaseURI(this.getDevicePath(device) + "/" + String.valueOf(uri));
        }
        return uri;
    }

    public boolean isControlPath(URI uri) {
        return uri.toString().endsWith(CONTROL);
    }

    public boolean isEventSubscriptionPath(URI uri) {
        return uri.toString().endsWith(EVENTS);
    }

    public boolean isEventCallbackPath(URI uri) {
        return uri.toString().endsWith(CALLBACK_FILE);
    }

    public Resource[] getResources(Device device) throws ValidationException {
        Resource[] discoveredResources;
        if (!device.isRoot()) {
            return null;
        }
        HashSet<Resource> resources = new HashSet<Resource>();
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        this.logger.trace("Discovering local resources of device graph");
        for (Resource resource : discoveredResources = device.discoverResources(this)) {
            this.logger.trace("Discovered: {}", (Object)resource);
            if (resources.add(resource)) continue;
            this.logger.trace("Local resource already exists, queueing validation error");
            errors.add(new ValidationError(this.getClass(), "resources", "Local URI namespace conflict between resources of device: " + String.valueOf(resource)));
        }
        if (!errors.isEmpty()) {
            throw new ValidationException("Validation of device graph failed, call getErrors() on exception", errors);
        }
        return resources.toArray(new Resource[resources.size()]);
    }

    protected URI appendPathToBaseURI(String path) {
        try {
            return new URI(this.basePath.getScheme(), null, this.basePath.getHost(), this.basePath.getPort(), this.decodedPath + path, null, null);
        }
        catch (URISyntaxException e) {
            return URI.create(String.valueOf(this.basePath) + path);
        }
    }

    protected String getDevicePath(Device device) {
        if (((DeviceIdentity)device.getIdentity()).getUdn() == null) {
            throw new IllegalStateException("Can't generate local URI prefix without UDN");
        }
        StringBuilder s = new StringBuilder();
        s.append(DEVICE).append("/");
        s.append(URIUtil.encodePathSegment(((DeviceIdentity)device.getIdentity()).getUdn().getIdentifierString()));
        return s.toString();
    }

    protected String getServicePath(Service service) {
        if (service.getServiceId() == null) {
            throw new IllegalStateException("Can't generate local URI prefix without service ID");
        }
        StringBuilder s = new StringBuilder();
        s.append(SERVICE);
        s.append("/");
        s.append(service.getServiceId().getNamespace());
        s.append("/");
        s.append(service.getServiceId().getId());
        return this.getDevicePath((Device)service.getDevice()) + String.valueOf(s);
    }
}

