/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.type;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.hibernate.HibernateError;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.registry.classloading.spi.ClassLoadingException;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeConstructor;

public final class PgJdbcHelper {
    public static boolean isUsable(ServiceRegistry serviceRegistry) {
        ClassLoaderService classLoaderService = serviceRegistry.requireService(ClassLoaderService.class);
        try {
            classLoaderService.classForName("org.postgresql.util.PGobject");
            return true;
        }
        catch (ClassLoadingException ex) {
            return false;
        }
    }

    public static JdbcType getStructJdbcType(ServiceRegistry serviceRegistry) {
        return PgJdbcHelper.createJdbcType(serviceRegistry, "org.hibernate.dialect.type.PostgreSQLStructPGObjectJdbcType");
    }

    public static JdbcType getIntervalJdbcType(ServiceRegistry serviceRegistry) {
        return PgJdbcHelper.createJdbcType(serviceRegistry, "org.hibernate.dialect.type.PostgreSQLIntervalSecondJdbcType");
    }

    public static JdbcType getInetJdbcType(ServiceRegistry serviceRegistry) {
        return PgJdbcHelper.createJdbcType(serviceRegistry, "org.hibernate.dialect.type.PostgreSQLInetJdbcType");
    }

    public static JdbcType getJsonJdbcType(ServiceRegistry serviceRegistry) {
        return PgJdbcHelper.createJdbcType(serviceRegistry, "org.hibernate.dialect.type.PostgreSQLJsonPGObjectJsonType");
    }

    public static JdbcType getJsonbJdbcType(ServiceRegistry serviceRegistry) {
        return PgJdbcHelper.createJdbcType(serviceRegistry, "org.hibernate.dialect.type.PostgreSQLJsonPGObjectJsonbType");
    }

    public static JdbcTypeConstructor getJsonArrayJdbcType(ServiceRegistry serviceRegistry) {
        return PgJdbcHelper.createJdbcTypeConstructor(serviceRegistry, "org.hibernate.dialect.type.PostgreSQLJsonArrayPGObjectJsonJdbcTypeConstructor");
    }

    public static JdbcTypeConstructor getJsonbArrayJdbcType(ServiceRegistry serviceRegistry) {
        return PgJdbcHelper.createJdbcTypeConstructor(serviceRegistry, "org.hibernate.dialect.type.PostgreSQLJsonArrayPGObjectJsonbJdbcTypeConstructor");
    }

    public static JdbcType createJdbcType(ServiceRegistry serviceRegistry, String className) {
        ClassLoaderService classLoaderService = serviceRegistry.requireService(ClassLoaderService.class);
        try {
            Class clazz = classLoaderService.classForName(className);
            Constructor constructor = clazz.getConstructor(new Class[0]);
            return (JdbcType)constructor.newInstance(new Object[0]);
        }
        catch (NoSuchMethodException e) {
            throw new HibernateError("Class does not have an empty constructor", e);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new HibernateError("Could not construct JdbcType", e);
        }
    }

    public static JdbcTypeConstructor createJdbcTypeConstructor(ServiceRegistry serviceRegistry, String className) {
        ClassLoaderService classLoaderService = serviceRegistry.requireService(ClassLoaderService.class);
        try {
            Class clazz = classLoaderService.classForName(className);
            Constructor constructor = clazz.getConstructor(new Class[0]);
            return (JdbcTypeConstructor)constructor.newInstance(new Object[0]);
        }
        catch (NoSuchMethodException e) {
            throw new HibernateError("Class does not have an empty constructor", e);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new HibernateError("Could not construct JdbcTypeConstructor", e);
        }
    }
}

