/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function.array;

import java.util.List;
import org.hibernate.dialect.function.array.ArrayConcatElementFunction;
import org.hibernate.dialect.function.array.DdlTypeHelper;
import org.hibernate.engine.jdbc.Size;
import org.hibernate.metamodel.mapping.JdbcMappingContainer;
import org.hibernate.metamodel.mapping.SqlTypedMapping;
import org.hibernate.metamodel.model.domain.ReturnableType;
import org.hibernate.sql.ast.SqlAstNodeRenderingMode;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.Literal;
import org.hibernate.type.BasicPluralType;

public class PostgreSQLArrayConcatElementFunction
extends ArrayConcatElementFunction {
    public PostgreSQLArrayConcatElementFunction(boolean prepend) {
        super("", "||", "", prepend);
    }

    @Override
    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> sqlAstArguments, ReturnableType<?> returnType, SqlAstTranslator<?> walker) {
        String elementCastType;
        Expression arrayArgument;
        Expression elementArgument;
        Expression firstArgument = (Expression)sqlAstArguments.get(0);
        Expression secondArgument = (Expression)sqlAstArguments.get(1);
        if (this.prepend) {
            elementArgument = firstArgument;
            arrayArgument = secondArgument;
        } else {
            arrayArgument = firstArgument;
            elementArgument = secondArgument;
        }
        if (PostgreSQLArrayConcatElementFunction.needsElementCasting(elementArgument)) {
            Size size;
            JdbcMappingContainer arrayType = arrayArgument.getExpressionType();
            if (arrayType instanceof SqlTypedMapping) {
                SqlTypedMapping sqlTypedMapping = (SqlTypedMapping)((Object)arrayType);
                size = sqlTypedMapping.toSize();
            } else {
                size = null;
            }
            Size size2 = size;
            elementCastType = DdlTypeHelper.getCastTypeName(((BasicPluralType)returnType).getElementType(), size2, walker.getSessionFactory().getTypeConfiguration());
        } else {
            elementCastType = null;
        }
        sqlAppender.append("case when ");
        walker.render(arrayArgument, SqlAstNodeRenderingMode.DEFAULT);
        sqlAppender.append(" is not null then ");
        if (this.prepend && elementCastType != null) {
            sqlAppender.append("cast(");
            walker.render(firstArgument, SqlAstNodeRenderingMode.DEFAULT);
            sqlAppender.append(" as ");
            sqlAppender.append(elementCastType);
            sqlAppender.append(')');
        } else {
            walker.render(firstArgument, SqlAstNodeRenderingMode.DEFAULT);
        }
        sqlAppender.append("||");
        if (!this.prepend && elementCastType != null) {
            sqlAppender.append("cast(");
            walker.render(secondArgument, SqlAstNodeRenderingMode.DEFAULT);
            sqlAppender.append(" as ");
            sqlAppender.append(elementCastType);
            sqlAppender.append(')');
        } else {
            walker.render(secondArgument, SqlAstNodeRenderingMode.DEFAULT);
        }
        sqlAppender.append(" end");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean needsElementCasting(Expression elementExpression) {
        if (!(elementExpression instanceof Literal)) return false;
        Literal literal = (Literal)elementExpression;
        if (elementExpression.getExpressionType().getSingleJdbcMapping().getJdbcType().isString()) return true;
        if (literal.getLiteralValue() != null) return false;
        return true;
    }
}

