/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.exportimport.dir;

import java.util.List;
import java.util.Map;
import org.keycloak.Config;
import org.keycloak.exportimport.ExportImportConfig;
import org.keycloak.exportimport.ImportProvider;
import org.keycloak.exportimport.ImportProviderFactory;
import org.keycloak.exportimport.Strategy;
import org.keycloak.exportimport.dir.DirImportProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderConfigurationBuilder;

public class DirImportProviderFactory
implements ImportProviderFactory {
    public static final String REALM_NAME = "realmName";
    public static final String DIR = "dir";
    private static final String STRATEGY = "strategy";
    public static final String PROVIDER_ID = "dir";
    private Config.Scope config;

    public ImportProvider create(KeycloakSession session, Map<String, String> overrides) {
        Strategy strategy = Enum.valueOf(Strategy.class, System.getProperty("keycloak.migration.strategy", this.config.get(STRATEGY, ExportImportConfig.DEFAULT_STRATEGY.toString())));
        String realmName = System.getProperty("keycloak.migration.realmName", this.config.get(REALM_NAME));
        String dir = overrides.getOrDefault("keycloak.migration.dir", System.getProperty("keycloak.migration.dir", this.config.get("dir")));
        return new DirImportProvider(session.getKeycloakSessionFactory(), strategy).withDir(dir).withRealmName(realmName);
    }

    public void init(Config.Scope config) {
        this.config = config;
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return "dir";
    }

    public List<ProviderConfigProperty> getConfigMetadata() {
        return ProviderConfigurationBuilder.create().property().name(REALM_NAME).type("string").helpText("Realm to export").add().property().name("dir").type("string").helpText("Directory to import from").add().property().name(STRATEGY).type("string").helpText("Strategy for import: " + Strategy.IGNORE_EXISTING.name() + ", " + String.valueOf(Strategy.OVERWRITE_EXISTING)).add().build();
    }
}

