/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.multimap.impl.function.sortedset;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.functional.EntryView;
import org.infinispan.multimap.impl.ExternalizerIds;
import org.infinispan.multimap.impl.SortedSetBucket;
import org.infinispan.multimap.impl.function.sortedset.SortedSetBucketBaseFunction;

public final class ScoreFunction<K, V>
implements SortedSetBucketBaseFunction<K, V, List<Double>> {
    public static final AdvancedExternalizer<ScoreFunction> EXTERNALIZER = new Externalizer();
    private final List<V> members;

    public ScoreFunction(List<V> members) {
        this.members = members;
    }

    public List<Double> apply(EntryView.ReadWriteEntryView<K, SortedSetBucket<V>> entryView) {
        Optional existing = entryView.peek();
        if (existing.isPresent()) {
            return ((SortedSetBucket)existing.get()).scores(this.members);
        }
        return Collections.emptyList();
    }

    private static class Externalizer
    implements AdvancedExternalizer<ScoreFunction> {
        private Externalizer() {
        }

        public Set<Class<? extends ScoreFunction>> getTypeClasses() {
            return Collections.singleton(ScoreFunction.class);
        }

        public Integer getId() {
            return ExternalizerIds.SORTED_SET_SCORE_FUNCTION;
        }

        public void writeObject(ObjectOutput output, ScoreFunction object) throws IOException {
            MarshallUtil.marshallCollection(object.members, (ObjectOutput)output);
        }

        public ScoreFunction readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new ScoreFunction((List)MarshallUtil.unmarshallCollection((ObjectInput)input, ArrayList::new));
        }
    }
}

