/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher.filters;

import com.intellij.dupLocator.util.NodeFilter;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.util.PsiTreeUtil;

public final class TypedSymbolNodeFilter
implements NodeFilter {
    private static final NodeFilter INSTANCE = new TypedSymbolNodeFilter();

    private TypedSymbolNodeFilter() {
    }

    public boolean accepts(PsiElement element) {
        if (element instanceof PsiClass) {
            return !(element instanceof PsiTypeParameter);
        }
        if (element instanceof PsiMethod) {
            return true;
        }
        if (element instanceof PsiJavaCodeReferenceElement) {
            PsiJavaCodeReferenceElement referenceElement = (PsiJavaCodeReferenceElement)element;
            if (PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PsiImportStatement.class, PsiPackageStatement.class}) != null) {
                return false;
            }
            PsiReferenceParameterList parameterList = referenceElement.getParameterList();
            if (parameterList != null) {
                return true;
            }
        }
        return false;
    }

    public static NodeFilter getInstance() {
        return INSTANCE;
    }
}

