/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.navbar.frontend.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.paint.PaintUtil;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.MacUIUtil;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Path2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Deprecated(forRemoval=true)
@ApiStatus.Internal
public abstract class AbstractNavBarUI {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    public static void paintHighlight(@NotNull Graphics2D g, @NotNull Rectangle rectangle, @NotNull Color color) {
        if (g == null) {
            AbstractNavBarUI.$$$reportNull$$$0(0);
        }
        if (rectangle == null) {
            AbstractNavBarUI.$$$reportNull$$$0(1);
        }
        if (color == null) {
            AbstractNavBarUI.$$$reportNull$$$0(2);
        }
        Graphics2D g2 = (Graphics2D)g.create();
        try {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, MacUIUtil.USE_QUARTZ ? RenderingHints.VALUE_STROKE_PURE : RenderingHints.VALUE_STROKE_NORMALIZE);
            g2.setColor(color);
            float arc = JBUIScale.scale((int)4);
            RoundRectangle2D.Float shape = new RoundRectangle2D.Float(rectangle.x, rectangle.y, rectangle.width, rectangle.height, arc, arc);
            g2.fill(shape);
        }
        finally {
            g2.dispose();
        }
    }

    @ApiStatus.Internal
    public static BufferedImage drawToBuffer(@NotNull Component item, ScaleContext ctx, boolean floating, boolean toolbarVisible, boolean selected, boolean nextSelected, boolean isLastElement) {
        if (item == null) {
            AbstractNavBarUI.$$$reportNull$$$0(3);
        }
        int w = item.getWidth();
        int h = item.getHeight();
        int offset = w - AbstractNavBarUI.getDecorationOffset();
        int h2 = h / 2;
        BufferedImage result = ImageUtil.createImage((ScaleContext)ctx, (double)w, (double)h, (int)2, (PaintUtil.RoundingMode)PaintUtil.RoundingMode.FLOOR);
        Gray defaultBg = StartupUiUtil.isUnderDarcula() ? Gray._100 : JBColor.WHITE;
        Gray bg = floating ? defaultBg : null;
        Color selection = UIUtil.getListSelectionBackground((boolean)true);
        Graphics2D g2 = result.createGraphics();
        g2.setStroke(new BasicStroke(1.0f, 0, 1));
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Path2D.Double shape = new Path2D.Double();
        shape.moveTo(0.0, 0.0);
        shape.lineTo(offset, 0.0);
        shape.lineTo(w, h2);
        shape.lineTo(offset, h);
        shape.lineTo(0.0, h);
        shape.closePath();
        Path2D.Double endShape = new Path2D.Double();
        endShape.moveTo(offset, 0.0);
        endShape.lineTo(w, 0.0);
        endShape.lineTo(w, h);
        endShape.lineTo(offset, h);
        endShape.lineTo(w, h2);
        endShape.closePath();
        if (bg != null && toolbarVisible) {
            g2.setPaint((Paint)bg);
            g2.fill(shape);
            g2.fill(endShape);
        }
        if (selected) {
            Path2D.Double focusShape = new Path2D.Double();
            if (toolbarVisible || floating) {
                focusShape.moveTo(offset, 0.0);
            } else {
                focusShape.moveTo(0.0, 0.0);
                focusShape.lineTo(offset, 0.0);
            }
            focusShape.lineTo(w - 1, h2);
            focusShape.lineTo(offset, h - 1);
            if (!toolbarVisible && !floating) {
                focusShape.lineTo(0.0, h - 1);
            }
            g2.setColor(selection);
            if (floating && isLastElement) {
                g2.fillRect(0, 0, w, h);
            } else {
                g2.fill(shape);
            }
        }
        if (nextSelected) {
            g2.setColor(selection);
            g2.fill(endShape);
        }
        if (!(isLastElement || selected || nextSelected)) {
            Icon icon = AllIcons.Ide.NavBarSeparator;
            icon.paintIcon(item, g2, w - icon.getIconWidth() - JBUIScale.scale((int)1), h2 - icon.getIconHeight() / 2);
        }
        g2.dispose();
        return result;
    }

    @ApiStatus.Internal
    public static int getDecorationOffset() {
        return JBUIScale.scale((int)8);
    }

    @ApiStatus.Internal
    public static int getFirstElementLeftOffset() {
        return JBUIScale.scale((int)6);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rectangle";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
        }
        objectArray2[1] = "com/intellij/platform/navbar/frontend/ui/AbstractNavBarUI";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "paintHighlight";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "drawToBuffer";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

