/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.awt.SystemTray;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import net.i2p.I2PAppContext;
import net.i2p.app.ClientApp;
import net.i2p.app.ClientAppManager;
import net.i2p.app.ClientAppState;
import net.i2p.apps.systray.UrlLauncher;
import net.i2p.desktopgui.Main;
import net.i2p.router.RouterContext;
import net.i2p.router.startup.ClientAppConfig;
import net.i2p.router.web.ContextHelper;
import net.i2p.router.web.DeadlockDetector;
import net.i2p.router.web.FormHandler;
import net.i2p.router.web.RouterConsoleRunner;
import net.i2p.router.web.WrapperListener;
import net.i2p.util.SystemVersion;
import net.i2p.util.VersionComparator;
import org.tanukisoftware.wrapper.WrapperManager;

public class ConfigServiceHandler
extends FormHandler {
    private static WrapperListener _wrapperListener;
    private static final String LISTENER_AVAILABLE = "3.2.0";
    private static final String PROPERTIES_AVAILABLE = "3.2.0";
    private static final String LOCATION_AVAILABLE = "3.3.7";

    private void registerWrapperNotifier(int code, boolean rekey) {
        ConfigServiceHandler.registerWrapperNotifier(this._context, code, rekey);
    }

    public static void registerWrapperNotifier(RouterContext ctx, int code, boolean rekey) {
        Runnable task = new UpdateWrapperOrRekeyTask(rekey, ctx.hasWrapper());
        ctx.addShutdownTask(task);
        if (ctx.hasWrapper()) {
            task = new FinalWrapperTask(code);
            ctx.addFinalShutdownTask(task);
        }
    }

    static synchronized void registerSignalHandler(RouterContext ctx) {
        String wv;
        if (ctx.hasWrapper() && _wrapperListener == null && (wv = System.getProperty("wrapper.version")) != null && VersionComparator.comp(wv, "3.2.0") >= 0) {
            try {
                _wrapperListener = new WrapperListener(ctx);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static synchronized void unregisterSignalHandler() {
        if (_wrapperListener != null) {
            _wrapperListener.unregister();
            _wrapperListener = null;
        }
    }

    public boolean shouldShowCancelGraceful() {
        return this._context.router().gracefulShutdownInProgress();
    }

    public boolean shouldShowSystray() {
        try {
            if (!SystemTray.isSupported()) {
                return false;
            }
        }
        catch (Throwable t) {
            return false;
        }
        return !SystemVersion.isService() && (!SystemVersion.isWindows() || !this._context.hasWrapper() || !WrapperManager.isLaunchedAsService());
    }

    public boolean isSystrayEnabled() {
        return RouterConsoleRunner.isSystrayEnabled(this._context);
    }

    public String getConsoleURL() {
        return this._context.portMapper().getConsoleURL();
    }

    @Override
    protected void processForm() {
        if (this._t("Shutdown gracefully").equals(this._action)) {
            if (this._context.hasWrapper()) {
                this.registerWrapperNotifier(2, false);
            }
            this._context.router().shutdownGracefully();
            this.addFormNotice(this._t("Graceful shutdown initiated"));
        } else if (this._t("Shutdown immediately").equals(this._action)) {
            if (this._context.hasWrapper()) {
                this.registerWrapperNotifier(3, false);
            }
            this._context.router().shutdown(3);
            this.addFormNotice(this._t("Shutdown immediately"));
        } else if (this._t("Cancel graceful shutdown").equals(this._action)) {
            this._context.router().cancelGracefulShutdown();
            this.addFormNotice(this._t("Graceful shutdown cancelled"));
        } else if (this._t("Graceful restart").equals(this._action)) {
            if (this._context.hasWrapper()) {
                this.registerWrapperNotifier(5, false);
            }
            this._context.router().shutdownGracefully(5);
            this.addFormNotice(this._t("Graceful restart requested"));
        } else if (this._t("Hard restart").equals(this._action)) {
            if (this._context.hasWrapper()) {
                this.registerWrapperNotifier(4, false);
            }
            this._context.router().shutdown(4);
            this.addFormNotice(this._t("Hard restart requested"));
        } else if (this._t("Rekey and Restart").equals(this._action)) {
            this.addFormNotice(this._t("Rekeying after graceful restart"));
            this.registerWrapperNotifier(5, true);
            this._context.router().shutdownGracefully(5);
        } else if (this._t("Rekey and Shutdown").equals(this._action)) {
            this.addFormNotice(this._t("Rekeying after graceful shutdown"));
            this.registerWrapperNotifier(2, true);
            this._context.router().shutdownGracefully(2);
        } else if (this._t("Run I2P on startup").equals(this._action)) {
            this.installService();
        } else if (this._t("Don't run I2P on startup").equals(this._action)) {
            this.uninstallService();
        } else if (this._t("Dump threads").equals(this._action)) {
            try {
                WrapperManager.requestThreadDump();
            }
            catch (Throwable t) {
                this.addFormError("Warning: unable to contact the service manager - " + t.getLocalizedMessage());
            }
            File wlog = ConfigServiceHandler.wrapperLogFile(this._context);
            this.addFormNotice(this._t("Threads dumped to {0}", wlog.getAbsolutePath()));
            boolean deadlock = DeadlockDetector.detect(this._context);
            if (deadlock) {
                this.addFormErrorNoEscape("Deadlock detected!<br><a href=\"/logs\">Please report using the information on the logs page!</a><br>After reporting, please restart your router!");
            }
        } else if (this._t("View console on startup").equals(this._action)) {
            this.browseOnStartup(true);
            this.addFormNotice(this._t("Console is to be shown on startup"));
        } else if (this._t("Do not view console on startup").equals(this._action)) {
            this.browseOnStartup(false);
            this.addFormNotice(this._t("Console is not to be shown on startup"));
        } else if (this._t("Force GC").equals(this._action)) {
            Runtime.getRuntime().gc();
            this.addFormNotice(this._t("Full garbage collection requested"));
        } else if (this._t("Show systray icon").equals(this._action)) {
            this.changeSystray(true);
        } else if (this._t("Hide systray icon").equals(this._action)) {
            this.changeSystray(false);
        }
    }

    public static File wrapperLogFile(I2PAppContext ctx) {
        String wv;
        File f = null;
        if (ctx.hasWrapper() && (wv = System.getProperty("wrapper.version")) != null && VersionComparator.comp(wv, LOCATION_AVAILABLE) >= 0) {
            try {
                f = WrapperManager.getWrapperLogFile();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (f == null || !f.exists()) {
            String path = System.getProperty("wrapper.logfile");
            if (path != null) {
                f = new File(path);
            } else {
                f = new File(System.getProperty("java.io.tmpdir"), "wrapper.log");
                if (!f.exists()) {
                    f = new File(ctx.getBaseDir(), "wrapper.log");
                }
            }
        }
        return f;
    }

    private void installService() {
        try {
            Runtime.getRuntime().exec("install_i2p_service_winnt.bat");
            this.addFormNotice(this._t("Service installed"));
        }
        catch (IOException ioe) {
            this.addFormError(this._t("Warning: unable to install the service") + " - " + ioe.getLocalizedMessage());
        }
    }

    private void uninstallService() {
        try {
            Runtime.getRuntime().exec("uninstall_i2p_service_winnt.bat");
            this.addFormNotice(this._t("Service removed"));
        }
        catch (IOException ioe) {
            this.addFormError(this._t("Warning: unable to remove the service") + " - " + ioe.getLocalizedMessage());
        }
    }

    private void browseOnStartup(boolean shouldLaunchBrowser) {
        List<ClientAppConfig> clients = ClientAppConfig.getClientApps(this._context);
        ClientAppConfig ca = null;
        for (int cur = 0; cur < clients.size(); ++cur) {
            ClientAppConfig cac = clients.get(cur);
            if (!UrlLauncher.class.getName().equals(cac.className)) continue;
            ca = cac;
            ca.disabled = !shouldLaunchBrowser;
            break;
        }
        if (shouldLaunchBrowser && ca == null) {
            String url = this._context.portMapper().getConsoleURL();
            ca = new ClientAppConfig(UrlLauncher.class.getName(), "consoleBrowser", url, 5L, false);
            clients.add(ca);
        }
        try {
            if (ca != null) {
                if (ClientAppConfig.isSplitConfig(this._context)) {
                    ClientAppConfig.writeClientAppConfig((I2PAppContext)this._context, ca);
                } else {
                    ClientAppConfig.writeClientAppConfig((I2PAppContext)this._context, clients);
                }
            }
            this.addFormNotice(this._t("Configuration saved successfully"));
        }
        catch (IOException ioe) {
            this.addFormError(this._t("Error saving the configuration (applied but not saved) - please see the error logs"));
            this.addFormError(ioe.getLocalizedMessage());
        }
    }

    private void changeSystray(boolean enable) {
        boolean saved;
        ClientAppManager mgr = this._context.clientAppManager();
        if (mgr != null) {
            try {
                ClientApp dtg = mgr.getRegisteredApp("desktopgui");
                if (dtg != null) {
                    if (enable) {
                        if (dtg.getState() == ClientAppState.STOPPED) {
                            dtg.startup();
                            this.addFormNotice(this._t("Enabled system tray"));
                        }
                    } else if (dtg.getState() == ClientAppState.RUNNING) {
                        dtg.shutdown(null);
                        this.addFormNotice(this._t("Disabled system tray"));
                    }
                } else if (enable) {
                    if (Boolean.parseBoolean(System.getProperty("java.awt.headless"))) {
                        this.addFormError(this._t("Restart required to take effect"));
                    } else {
                        dtg = new Main(this._context, mgr, null);
                        dtg.startup();
                        this.addFormNotice(this._t("Enabled system tray"));
                    }
                }
            }
            catch (Throwable t) {
                if (enable) {
                    this.addFormError(this._t("Failed to start systray") + ": " + t);
                }
                this.addFormError(this._t("Failed to stop systray") + ": " + t);
            }
        }
        if (saved = this._context.router().saveConfig("desktopgui.enabled", Boolean.toString(enable))) {
            this.addFormNotice(this._t("Configuration saved successfully"));
        } else {
            this.addFormError(this._t("Error saving the configuration (applied but not saved) - please see the error logs"));
        }
    }

    private static class UpdateWrapperOrRekeyTask
    implements Runnable {
        private final boolean _rekey;
        private final boolean _tellWrapper;
        private static final int HASHCODE = -123999871;
        private static final int WAIT = SystemVersion.isARM() ? 240000 : 120000;

        public UpdateWrapperOrRekeyTask(boolean rekey, boolean tellWrapper) {
            this._rekey = rekey;
            this._tellWrapper = tellWrapper;
        }

        @Override
        public void run() {
            block9: {
                try {
                    int wait;
                    block10: {
                        if (this._rekey) {
                            ContextHelper.getContext(null).router().killKeys();
                        }
                        if (!this._tellWrapper) break block9;
                        wait = WAIT;
                        String wv = System.getProperty("wrapper.version");
                        if (wv != null && VersionComparator.comp(wv, "3.2.0") >= 0) {
                            try {
                                Properties props = WrapperManager.getProperties();
                                String tmout = props.getProperty("wrapper.jvm_exit.timeout");
                                if (tmout == null) break block10;
                                try {
                                    int cwait = Integer.parseInt(tmout) * 1000;
                                    if (cwait > wait) {
                                        wait = cwait;
                                    }
                                }
                                catch (NumberFormatException numberFormatException) {}
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                    }
                    WrapperManager.signalStopping((int)wait);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }

        public int hashCode() {
            return -123999871;
        }

        public boolean equals(Object o) {
            return o != null && o instanceof UpdateWrapperOrRekeyTask;
        }
    }

    private static class FinalWrapperTask
    implements Runnable {
        private final int _exitCode;
        private static final int HASHCODE = 123999871;

        public FinalWrapperTask(int exitCode) {
            this._exitCode = exitCode;
        }

        @Override
        public void run() {
            try {
                WrapperManager.signalStopped((int)this._exitCode);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }

        public int hashCode() {
            return 123999871;
        }

        public boolean equals(Object o) {
            return o != null && o instanceof FinalWrapperTask;
        }
    }
}

