/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.session;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Locale;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.naming.InitialContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.sql.DataSource;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.SessionManager;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.session.AbstractSessionIdManager;
import org.eclipse.jetty.server.session.JDBCSessionManager;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.ScheduledExecutorScheduler;
import org.eclipse.jetty.util.thread.Scheduler;

public class JDBCSessionIdManager
extends AbstractSessionIdManager {
    static final Logger LOG = SessionHandler.LOG;
    public static final int MAX_INTERVAL_NOT_SET = -999;
    protected final HashSet<String> _sessionIds = new HashSet();
    protected Server _server;
    protected Driver _driver;
    protected String _driverClassName;
    protected String _connectionUrl;
    protected DataSource _datasource;
    protected String _jndiName;
    protected int _deleteBlockSize = 10;
    protected Scheduler.Task _task;
    protected Scheduler _scheduler;
    protected Scavenger _scavenger;
    protected boolean _ownScheduler;
    protected long _lastScavengeTime;
    protected long _scavengeIntervalMs = 600000L;
    protected String _createSessionIdTable;
    protected String _createSessionTable;
    protected String _selectBoundedExpiredSessions;
    private String _selectExpiredSessions;
    protected String _insertId;
    protected String _deleteId;
    protected String _queryId;
    protected String _insertSession;
    protected String _deleteSession;
    protected String _updateSession;
    protected String _updateSessionNode;
    protected String _updateSessionAccessTime;
    protected DatabaseAdaptor _dbAdaptor = new DatabaseAdaptor();
    protected SessionIdTableSchema _sessionIdTableSchema = new SessionIdTableSchema();
    protected SessionTableSchema _sessionTableSchema = new SessionTableSchema();

    public JDBCSessionIdManager(Server server) {
        this._server = server;
    }

    public JDBCSessionIdManager(Server server, Random random) {
        super(random);
        this._server = server;
    }

    public void setDriverInfo(String driverClassName, String connectionUrl) {
        this._driverClassName = driverClassName;
        this._connectionUrl = connectionUrl;
    }

    public void setDriverInfo(Driver driverClass, String connectionUrl) {
        this._driver = driverClass;
        this._connectionUrl = connectionUrl;
    }

    public void setDatasource(DataSource ds) {
        this._datasource = ds;
    }

    public DataSource getDataSource() {
        return this._datasource;
    }

    public String getDriverClassName() {
        return this._driverClassName;
    }

    public String getConnectionUrl() {
        return this._connectionUrl;
    }

    public void setDatasourceName(String jndi) {
        this._jndiName = jndi;
    }

    public String getDatasourceName() {
        return this._jndiName;
    }

    @Deprecated
    public void setBlobType(String name) {
        this._dbAdaptor.setBlobType(name);
    }

    public DatabaseAdaptor getDbAdaptor() {
        return this._dbAdaptor;
    }

    public void setDbAdaptor(DatabaseAdaptor dbAdaptor) {
        if (dbAdaptor == null) {
            throw new IllegalStateException("DbAdaptor cannot be null");
        }
        this._dbAdaptor = dbAdaptor;
    }

    @Deprecated
    public String getBlobType() {
        return this._dbAdaptor.getBlobType();
    }

    @Deprecated
    public String getLongType() {
        return this._dbAdaptor.getLongType();
    }

    @Deprecated
    public void setLongType(String longType) {
        this._dbAdaptor.setLongType(longType);
    }

    public SessionIdTableSchema getSessionIdTableSchema() {
        return this._sessionIdTableSchema;
    }

    public void setSessionIdTableSchema(SessionIdTableSchema sessionIdTableSchema) {
        if (sessionIdTableSchema == null) {
            throw new IllegalArgumentException("Null SessionIdTableSchema");
        }
        this._sessionIdTableSchema = sessionIdTableSchema;
    }

    public SessionTableSchema getSessionTableSchema() {
        return this._sessionTableSchema;
    }

    public void setSessionTableSchema(SessionTableSchema sessionTableSchema) {
        this._sessionTableSchema = sessionTableSchema;
    }

    public void setDeleteBlockSize(int bsize) {
        this._deleteBlockSize = bsize;
    }

    public int getDeleteBlockSize() {
        return this._deleteBlockSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setScavengeInterval(long sec) {
        long period;
        if (sec <= 0L) {
            sec = 60L;
        }
        long old_period = this._scavengeIntervalMs;
        this._scavengeIntervalMs = period = sec * 1000L;
        long tenPercent = this._scavengeIntervalMs / 10L;
        if (System.currentTimeMillis() % 2L == 0L) {
            this._scavengeIntervalMs += tenPercent;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Scavenging every " + this._scavengeIntervalMs + " ms", new Object[0]);
        }
        JDBCSessionIdManager jDBCSessionIdManager = this;
        synchronized (jDBCSessionIdManager) {
            if (this._scheduler != null && (period != old_period || this._task == null)) {
                if (this._task != null) {
                    this._task.cancel();
                }
                if (this._scavenger == null) {
                    this._scavenger = new Scavenger();
                }
                this._task = this._scheduler.schedule((Runnable)this._scavenger, this._scavengeIntervalMs, TimeUnit.MILLISECONDS);
            }
        }
    }

    public long getScavengeInterval() {
        return this._scavengeIntervalMs / 1000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSession(HttpSession session) {
        if (session == null) {
            return;
        }
        HashSet<String> hashSet = this._sessionIds;
        synchronized (hashSet) {
            String id = ((JDBCSessionManager.Session)session).getClusterId();
            try {
                this.insert(id);
                this._sessionIds.add(id);
            }
            catch (Exception e) {
                LOG.warn("Problem storing session id=" + id, (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSession(String id) {
        if (id == null) {
            return;
        }
        HashSet<String> hashSet = this._sessionIds;
        synchronized (hashSet) {
            try {
                this.insert(id);
                this._sessionIds.add(id);
            }
            catch (Exception e) {
                LOG.warn("Problem storing session id=" + id, (Throwable)e);
            }
        }
    }

    @Override
    public void removeSession(HttpSession session) {
        if (session == null) {
            return;
        }
        this.removeSession(((JDBCSessionManager.Session)session).getClusterId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSession(String id) {
        if (id == null) {
            return;
        }
        HashSet<String> hashSet = this._sessionIds;
        synchronized (hashSet) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Removing sessionid=" + id, new Object[0]);
            }
            try {
                this._sessionIds.remove(id);
                this.delete(id);
            }
            catch (Exception e) {
                LOG.warn("Problem removing session id=" + id, (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean idInUse(String id) {
        if (id == null) {
            return false;
        }
        String clusterId = this.getClusterId(id);
        boolean inUse = false;
        HashSet<String> hashSet = this._sessionIds;
        synchronized (hashSet) {
            inUse = this._sessionIds.contains(clusterId);
        }
        if (inUse) {
            return true;
        }
        try {
            return this.exists(clusterId);
        }
        catch (Exception e) {
            LOG.warn("Problem checking inUse for id=" + clusterId, (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidateAll(String id) {
        this.removeSession(id);
        HashSet<String> hashSet = this._sessionIds;
        synchronized (hashSet) {
            Handler[] contexts = this._server.getChildHandlersByClass(ContextHandler.class);
            for (int i = 0; contexts != null && i < contexts.length; ++i) {
                SessionManager manager;
                SessionHandler sessionHandler = ((ContextHandler)contexts[i]).getChildHandlerByClass(SessionHandler.class);
                if (sessionHandler == null || (manager = sessionHandler.getSessionManager()) == null || !(manager instanceof JDBCSessionManager)) continue;
                ((JDBCSessionManager)manager).invalidateSession(id);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renewSessionId(String oldClusterId, String oldNodeId, HttpServletRequest request) {
        String newClusterId = this.newSessionId(request.hashCode());
        HashSet<String> hashSet = this._sessionIds;
        synchronized (hashSet) {
            this.removeSession(oldClusterId);
            this.addSession(newClusterId);
            Handler[] contexts = this._server.getChildHandlersByClass(ContextHandler.class);
            for (int i = 0; contexts != null && i < contexts.length; ++i) {
                SessionManager manager;
                SessionHandler sessionHandler = ((ContextHandler)contexts[i]).getChildHandlerByClass(SessionHandler.class);
                if (sessionHandler == null || (manager = sessionHandler.getSessionManager()) == null || !(manager instanceof JDBCSessionManager)) continue;
                ((JDBCSessionManager)manager).renewSessionId(oldClusterId, oldNodeId, newClusterId, this.getNodeId(newClusterId, request));
            }
        }
    }

    @Override
    public void doStart() throws Exception {
        this.initializeDatabase();
        this.prepareTables();
        super.doStart();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Scavenging interval = " + this.getScavengeInterval() + " sec", new Object[0]);
        }
        this._scheduler = (Scheduler)this._server.getBean(Scheduler.class);
        if (this._scheduler == null) {
            this._scheduler = new ScheduledExecutorScheduler();
            this._ownScheduler = true;
            this._scheduler.start();
        } else if (!this._scheduler.isStarted()) {
            throw new IllegalStateException("Shared scheduler not started");
        }
        this.setScavengeInterval(this.getScavengeInterval());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doStop() throws Exception {
        JDBCSessionIdManager jDBCSessionIdManager = this;
        synchronized (jDBCSessionIdManager) {
            if (this._task != null) {
                this._task.cancel();
            }
            this._task = null;
            if (this._ownScheduler && this._scheduler != null) {
                this._scheduler.stop();
            }
            this._scheduler = null;
        }
        this._sessionIds.clear();
        super.doStop();
    }

    protected Connection getConnection() throws SQLException {
        if (this._datasource != null) {
            return this._datasource.getConnection();
        }
        return DriverManager.getConnection(this._connectionUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareTables() throws SQLException {
        if (this._sessionIdTableSchema == null) {
            throw new IllegalStateException("No SessionIdTableSchema");
        }
        if (this._sessionTableSchema == null) {
            throw new IllegalStateException("No SessionTableSchema");
        }
        try (Connection connection = this.getConnection();
             Statement statement = connection.createStatement();){
            String schemaName;
            String tableName;
            DatabaseMetaData metaData;
            block76: {
                connection.setAutoCommit(true);
                metaData = connection.getMetaData();
                this._dbAdaptor.adaptTo(metaData);
                this._sessionTableSchema.setDatabaseAdaptor(this._dbAdaptor);
                this._sessionIdTableSchema.setDatabaseAdaptor(this._dbAdaptor);
                this._createSessionIdTable = this._sessionIdTableSchema.getCreateStatementAsString();
                this._insertId = this._sessionIdTableSchema.getInsertStatementAsString();
                this._deleteId = this._sessionIdTableSchema.getDeleteStatementAsString();
                this._queryId = this._sessionIdTableSchema.getSelectStatementAsString();
                tableName = this._dbAdaptor.convertIdentifier(this._sessionIdTableSchema.getTableName());
                schemaName = this._sessionIdTableSchema.getSchemaName() != null ? this._dbAdaptor.convertIdentifier(this._sessionIdTableSchema.getSchemaName()) : null;
                try (ResultSet result = metaData.getTables(null, schemaName, tableName, null);){
                    if (!result.next()) {
                        statement.executeUpdate(this._createSessionIdTable);
                    }
                }
                tableName = this._dbAdaptor.convertIdentifier(this._sessionTableSchema.getTableName());
                schemaName = this._sessionTableSchema.getSchemaName() != null ? this._dbAdaptor.convertIdentifier(this._sessionTableSchema.getSchemaName()) : null;
                result = metaData.getTables(null, schemaName, tableName, null);
                var9_13 = null;
                try {
                    if (!result.next()) {
                        this._createSessionTable = this._sessionTableSchema.getCreateStatementAsString();
                        statement.executeUpdate(this._createSessionTable);
                        break block76;
                    }
                    ResultSet colResult = null;
                    try {
                        colResult = metaData.getColumns(null, schemaName, tableName, this._dbAdaptor.convertIdentifier(this._sessionTableSchema.getMaxIntervalColumn()));
                    }
                    catch (SQLException s) {
                        LOG.warn("Problem checking if " + this._sessionTableSchema.getTableName() + " table contains " + this._sessionTableSchema.getMaxIntervalColumn() + " column. Ensure table contains column definition: \"" + this._sessionTableSchema.getMaxIntervalColumn() + " long not null default -999\"", new Object[0]);
                        throw s;
                    }
                    try {
                        if (colResult.next()) break block76;
                        try {
                            statement.executeUpdate(this._sessionTableSchema.getAlterTableForMaxIntervalAsString());
                        }
                        catch (SQLException s) {
                            LOG.warn("Problem adding " + this._sessionTableSchema.getMaxIntervalColumn() + " column. Ensure table contains column definition: \"" + this._sessionTableSchema.getMaxIntervalColumn() + " long not null default -999\"", new Object[0]);
                            throw s;
                        }
                    }
                    finally {
                        colResult.close();
                    }
                }
                catch (Throwable colResult) {
                    var9_13 = colResult;
                    throw colResult;
                }
                finally {
                    if (result != null) {
                        if (var9_13 != null) {
                            try {
                                result.close();
                            }
                            catch (Throwable colResult) {
                                var9_13.addSuppressed(colResult);
                            }
                        } else {
                            result.close();
                        }
                    }
                }
            }
            String index1 = "idx_" + this._sessionTableSchema.getTableName() + "_expiry";
            String index2 = "idx_" + this._sessionTableSchema.getTableName() + "_session";
            boolean index1Exists = false;
            boolean index2Exists = false;
            try (ResultSet result = metaData.getIndexInfo(null, schemaName, tableName, false, true);){
                while (result.next()) {
                    String idxName = result.getString("INDEX_NAME");
                    if (index1.equalsIgnoreCase(idxName)) {
                        index1Exists = true;
                        continue;
                    }
                    if (!index2.equalsIgnoreCase(idxName)) continue;
                    index2Exists = true;
                }
            }
            if (!index1Exists) {
                statement.executeUpdate(this._sessionTableSchema.getCreateIndexOverExpiryStatementAsString(index1));
            }
            if (!index2Exists) {
                statement.executeUpdate(this._sessionTableSchema.getCreateIndexOverSessionStatementAsString(index2));
            }
            this._insertSession = this._sessionTableSchema.getInsertSessionStatementAsString();
            this._deleteSession = this._sessionTableSchema.getDeleteSessionStatementAsString();
            this._updateSession = this._sessionTableSchema.getUpdateSessionStatementAsString();
            this._updateSessionNode = this._sessionTableSchema.getUpdateSessionNodeStatementAsString();
            this._updateSessionAccessTime = this._sessionTableSchema.getUpdateSessionAccessTimeStatementAsString();
            this._selectBoundedExpiredSessions = this._sessionTableSchema.getBoundedExpiredSessionsStatementAsString();
            this._selectExpiredSessions = this._sessionTableSchema.getSelectExpiredSessionsStatementAsString();
        }
    }

    private void insert(String id) throws SQLException {
        block48: {
            try (Connection connection = this.getConnection();
                 PreparedStatement query = connection.prepareStatement(this._queryId);){
                connection.setAutoCommit(true);
                query.setString(1, id);
                try (ResultSet result = query.executeQuery();){
                    if (result.next()) break block48;
                    try (PreparedStatement statement = connection.prepareStatement(this._insertId);){
                        statement.setString(1, id);
                        statement.executeUpdate();
                    }
                }
            }
        }
    }

    private void delete(String id) throws SQLException {
        try (Connection connection = this.getConnection();
             PreparedStatement statement = connection.prepareStatement(this._deleteId);){
            connection.setAutoCommit(true);
            statement.setString(1, id);
            statement.executeUpdate();
        }
    }

    /*
     * Exception decompiling
     */
    private boolean exists(String id) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scavenge() {
        block84: {
            Set<String> candidateIds = this.getAllCandidateExpiredSessionIds();
            Connection connection = null;
            try {
                block87: {
                    String sessionId2;
                    Throwable throwable;
                    ResultSet result;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(this.getWorkerName() + "- Scavenge sweep started at " + System.currentTimeMillis(), new Object[0]);
                    }
                    if (this._lastScavengeTime <= 0L) break block84;
                    connection = this.getConnection();
                    connection.setAutoCommit(true);
                    HashSet<String> expiredSessionIds = new HashSet<String>();
                    long lowerBound = this._lastScavengeTime - this._scavengeIntervalMs;
                    long upperBound = this._lastScavengeTime;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(this.getWorkerName() + "- Pass 1: Searching for sessions expired between " + lowerBound + " and " + upperBound, new Object[0]);
                    }
                    try (PreparedStatement statement = connection.prepareStatement(this._selectBoundedExpiredSessions);){
                        statement.setString(1, this.getWorkerName());
                        statement.setLong(2, lowerBound);
                        statement.setLong(3, upperBound);
                        result = statement.executeQuery();
                        throwable = null;
                        try {
                            while (result.next()) {
                                sessionId2 = result.getString(this._sessionTableSchema.getIdColumn());
                                expiredSessionIds.add(sessionId2);
                                if (!LOG.isDebugEnabled()) continue;
                                LOG.debug("Found expired sessionId=" + sessionId2, new Object[0]);
                            }
                        }
                        catch (Throwable sessionId2) {
                            throwable = sessionId2;
                            throw sessionId2;
                        }
                        finally {
                            if (result != null) {
                                if (throwable != null) {
                                    try {
                                        result.close();
                                    }
                                    catch (Throwable sessionId2) {
                                        throwable.addSuppressed(sessionId2);
                                    }
                                } else {
                                    result.close();
                                }
                            }
                        }
                    }
                    this.scavengeSessions(candidateIds, expiredSessionIds, false);
                    var9_10 = null;
                    try (PreparedStatement selectExpiredSessions = connection.prepareStatement(this._selectExpiredSessions);){
                        expiredSessionIds.clear();
                        upperBound = this._lastScavengeTime - 2L * this._scavengeIntervalMs;
                        if (upperBound > 0L) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug(this.getWorkerName() + "- Pass 2: Searching for sessions expired before " + upperBound, new Object[0]);
                            }
                            selectExpiredSessions.setLong(1, upperBound);
                            result = selectExpiredSessions.executeQuery();
                            throwable = null;
                            try {
                                while (result.next()) {
                                    sessionId2 = result.getString(this._sessionTableSchema.getIdColumn());
                                    String lastNode = result.getString(this._sessionTableSchema.getLastNodeColumn());
                                    if (this.getWorkerName() == null && lastNode == null || this.getWorkerName() != null && this.getWorkerName().equals(lastNode)) {
                                        expiredSessionIds.add(sessionId2);
                                    }
                                    if (!LOG.isDebugEnabled()) continue;
                                    LOG.debug("Found expired sessionId=" + sessionId2 + " last managed by " + this.getWorkerName(), new Object[0]);
                                }
                            }
                            catch (Throwable sessionId3) {
                                throwable = sessionId3;
                                throw sessionId3;
                            }
                            finally {
                                if (result != null) {
                                    if (throwable != null) {
                                        try {
                                            result.close();
                                        }
                                        catch (Throwable sessionId3) {
                                            throwable.addSuppressed(sessionId3);
                                        }
                                    } else {
                                        result.close();
                                    }
                                }
                            }
                            this.scavengeSessions(candidateIds, expiredSessionIds, false);
                        }
                        upperBound = this._lastScavengeTime - 3L * this._scavengeIntervalMs;
                        expiredSessionIds.clear();
                        if (upperBound <= 0L) break block87;
                        if (LOG.isDebugEnabled()) {
                            LOG.debug(this.getWorkerName() + "- Pass 3: searching for sessions expired before " + upperBound, new Object[0]);
                        }
                        selectExpiredSessions.setLong(1, upperBound);
                        result = selectExpiredSessions.executeQuery();
                        throwable = null;
                        try {
                            while (result.next()) {
                                sessionId2 = result.getString(this._sessionTableSchema.getIdColumn());
                                expiredSessionIds.add(sessionId2);
                                if (!LOG.isDebugEnabled()) continue;
                                LOG.debug("Found expired sessionId=" + sessionId2, new Object[0]);
                            }
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (result != null) {
                                if (throwable != null) {
                                    try {
                                        result.close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                } else {
                                    result.close();
                                }
                            }
                        }
                        this.scavengeSessions(candidateIds, expiredSessionIds, true);
                    }
                    catch (Throwable throwable4) {
                        var9_10 = throwable4;
                        throw throwable4;
                    }
                }
                this.scavengeSessions(candidateIds);
            }
            catch (Exception e) {
                if (this.isRunning()) {
                    LOG.warn("Problem selecting expired sessions", (Throwable)e);
                } else {
                    LOG.ignore((Throwable)e);
                }
            }
            finally {
                this._lastScavengeTime = System.currentTimeMillis();
                if (LOG.isDebugEnabled()) {
                    LOG.debug(this.getWorkerName() + "- Scavenge sweep ended at " + this._lastScavengeTime, new Object[0]);
                }
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (SQLException e) {
                        LOG.warn((Throwable)e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scavengeSessions(Set<String> candidateIds, Set<String> expiredSessionIds, boolean forceDelete) {
        HashSet<String> remainingIds = new HashSet<String>(expiredSessionIds);
        Set<SessionManager> managers = this.getAllSessionManagers();
        for (SessionManager m : managers) {
            Set<String> successfullyExpiredIds = ((JDBCSessionManager)m).expire(expiredSessionIds);
            if (successfullyExpiredIds == null) continue;
            remainingIds.removeAll(successfullyExpiredIds);
            candidateIds.removeAll(successfullyExpiredIds);
        }
        if (!remainingIds.isEmpty() && forceDelete) {
            LOG.info("Forcibly deleting unrecoverable expired sessions {}", new Object[]{remainingIds});
            try {
                HashSet<String> hashSet = this._sessionIds;
                synchronized (hashSet) {
                    this._sessionIds.removeAll(remainingIds);
                }
                this.cleanExpiredSessionIds(remainingIds);
            }
            catch (Exception e) {
                LOG.warn("Error removing expired session ids", (Throwable)e);
            }
        }
    }

    private void scavengeSessions(Set<String> candidateIds) {
        if (candidateIds.isEmpty()) {
            return;
        }
        Set<SessionManager> managers = this.getAllSessionManagers();
        for (SessionManager m : managers) {
            ((JDBCSessionManager)m).expireCandidates(candidateIds);
        }
    }

    private Set<String> getAllCandidateExpiredSessionIds() {
        HashSet<String> candidateIds = new HashSet<String>();
        Set<SessionManager> managers = this.getAllSessionManagers();
        for (SessionManager m : managers) {
            candidateIds.addAll(((JDBCSessionManager)m).getCandidateExpiredIds());
        }
        return candidateIds;
    }

    private Set<SessionManager> getAllSessionManagers() {
        HashSet<SessionManager> managers = new HashSet<SessionManager>();
        Handler[] contexts = this._server.getChildHandlersByClass(ContextHandler.class);
        for (int i = 0; contexts != null && i < contexts.length; ++i) {
            SessionManager manager;
            SessionHandler sessionHandler = ((ContextHandler)contexts[i]).getChildHandlerByClass(SessionHandler.class);
            if (sessionHandler == null || (manager = sessionHandler.getSessionManager()) == null || !(manager instanceof JDBCSessionManager)) continue;
            managers.add(manager);
        }
        return managers;
    }

    private void cleanExpiredSessionIds(Set<String> expiredIds) throws Exception {
        if (expiredIds == null || expiredIds.isEmpty()) {
            return;
        }
        String[] ids = expiredIds.toArray(new String[expiredIds.size()]);
        try (Connection con = this.getConnection();){
            con.setTransactionIsolation(2);
            con.setAutoCommit(false);
            int start = 0;
            int end = 0;
            int blocksize = this._deleteBlockSize;
            int block = 0;
            try (Statement statement = con.createStatement();){
                while (end < ids.length) {
                    start = block * blocksize;
                    end = ids.length - start >= blocksize ? start + blocksize : ids.length;
                    statement.executeUpdate(this.fillInClause("delete from " + this._sessionIdTableSchema.getSchemaTableName() + " where " + this._sessionIdTableSchema.getIdColumn() + " in ", ids, start, end));
                    statement.executeUpdate(this.fillInClause("delete from " + this._sessionTableSchema.getSchemaTableName() + " where " + this._sessionTableSchema.getIdColumn() + " in ", ids, start, end));
                    ++block;
                }
            }
            catch (Exception e) {
                con.rollback();
                throw e;
            }
            con.commit();
        }
    }

    private String fillInClause(String sql, String[] literals, int start, int end) throws Exception {
        StringBuffer buff = new StringBuffer();
        buff.append(sql);
        buff.append("(");
        for (int i = start; i < end; ++i) {
            buff.append("'" + literals[i] + "'");
            if (i + 1 >= end) continue;
            buff.append(",");
        }
        buff.append(")");
        return buff.toString();
    }

    private void initializeDatabase() throws Exception {
        if (this._datasource != null) {
            return;
        }
        if (this._jndiName != null) {
            InitialContext ic = new InitialContext();
            this._datasource = (DataSource)ic.lookup(this._jndiName);
        } else if (this._driver != null && this._connectionUrl != null) {
            DriverManager.registerDriver(this._driver);
        } else if (this._driverClassName != null && this._connectionUrl != null) {
            Class.forName(this._driverClassName);
        } else {
            throw new IllegalStateException("No database configured for sessions");
        }
    }

    protected class Scavenger
    implements Runnable {
        protected Scavenger() {
        }

        @Override
        public void run() {
            try {
                JDBCSessionIdManager.this.scavenge();
            }
            finally {
                if (JDBCSessionIdManager.this._scheduler != null && JDBCSessionIdManager.this._scheduler.isRunning()) {
                    JDBCSessionIdManager.this._task = JDBCSessionIdManager.this._scheduler.schedule((Runnable)this, JDBCSessionIdManager.this._scavengeIntervalMs, TimeUnit.MILLISECONDS);
                }
            }
        }
    }

    public static class DatabaseAdaptor {
        String _dbName;
        boolean _isLower;
        boolean _isUpper;
        protected String _blobType;
        protected String _longType;

        public void adaptTo(DatabaseMetaData dbMeta) throws SQLException {
            this._dbName = dbMeta.getDatabaseProductName().toLowerCase(Locale.ENGLISH);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Using database {}", new Object[]{this._dbName});
            }
            this._isLower = dbMeta.storesLowerCaseIdentifiers();
            this._isUpper = dbMeta.storesUpperCaseIdentifiers();
        }

        public void setBlobType(String blobType) {
            this._blobType = blobType;
        }

        public String getBlobType() {
            if (this._blobType != null) {
                return this._blobType;
            }
            if (this._dbName.startsWith("postgres")) {
                return "bytea";
            }
            return "blob";
        }

        public void setLongType(String longType) {
            this._longType = longType;
        }

        public String getLongType() {
            if (this._longType != null) {
                return this._longType;
            }
            if (this._dbName == null) {
                throw new IllegalStateException("DbAdaptor missing metadata");
            }
            if (this._dbName.startsWith("oracle")) {
                return "number(20)";
            }
            return "bigint";
        }

        public String convertIdentifier(String identifier) {
            if (this._dbName == null) {
                throw new IllegalStateException("DbAdaptor missing metadata");
            }
            if (this._isLower) {
                return identifier.toLowerCase(Locale.ENGLISH);
            }
            if (this._isUpper) {
                return identifier.toUpperCase(Locale.ENGLISH);
            }
            return identifier;
        }

        public String getDBName() {
            return this._dbName;
        }

        public InputStream getBlobInputStream(ResultSet result, String columnName) throws SQLException {
            if (this._dbName == null) {
                throw new IllegalStateException("DbAdaptor missing metadata");
            }
            if (this._dbName.startsWith("postgres")) {
                byte[] bytes = result.getBytes(columnName);
                return new ByteArrayInputStream(bytes);
            }
            Blob blob = result.getBlob(columnName);
            return blob.getBinaryStream();
        }

        public boolean isEmptyStringNull() {
            if (this._dbName == null) {
                throw new IllegalStateException("DbAdaptor missing metadata");
            }
            return this._dbName.startsWith("oracle");
        }

        public boolean isRowIdReserved() {
            if (this._dbName == null) {
                throw new IllegalStateException("DbAdaptor missing metadata");
            }
            return this._dbName != null && this._dbName.startsWith("oracle");
        }
    }

    public static class SessionIdTableSchema {
        protected DatabaseAdaptor _dbAdaptor;
        protected String _tableName = "JettySessionIds";
        protected String _schemaName = null;
        protected String _idColumn = "id";

        public void setDatabaseAdaptor(DatabaseAdaptor dbAdaptor) {
            this._dbAdaptor = dbAdaptor;
        }

        public String getIdColumn() {
            return this._idColumn;
        }

        public void setIdColumn(String idColumn) {
            this.checkNotNull(idColumn);
            this._idColumn = idColumn;
        }

        public String getTableName() {
            return this._tableName;
        }

        public void setTableName(String tableName) {
            this.checkNotNull(tableName);
            this._tableName = tableName;
        }

        public String getSchemaName() {
            return this._schemaName;
        }

        public void setSchemaName(String schemaName) {
            this.checkNotNull(schemaName);
            this._schemaName = schemaName;
        }

        public String getInsertStatementAsString() {
            return "insert into " + this.getSchemaTableName() + " (" + this._idColumn + ")  values (?)";
        }

        public String getDeleteStatementAsString() {
            return "delete from " + this.getSchemaTableName() + " where " + this._idColumn + " = ?";
        }

        public String getSelectStatementAsString() {
            return "select * from " + this.getSchemaTableName() + " where " + this._idColumn + " = ?";
        }

        public String getCreateStatementAsString() {
            return "create table " + this.getSchemaTableName() + " (" + this._idColumn + " varchar(120), primary key(" + this._idColumn + "))";
        }

        private String getSchemaTableName() {
            return (this.getSchemaName() != null ? this.getSchemaName() + "." : "") + this.getTableName();
        }

        private void checkNotNull(String s) {
            if (s == null) {
                throw new IllegalArgumentException(s);
            }
        }
    }

    public static class SessionTableSchema {
        protected DatabaseAdaptor _dbAdaptor;
        protected String _tableName = "JettySessions";
        protected String _schemaName = null;
        protected String _rowIdColumn = "rowId";
        protected String _idColumn = "sessionId";
        protected String _contextPathColumn = "contextPath";
        protected String _virtualHostColumn = "virtualHost";
        protected String _lastNodeColumn = "lastNode";
        protected String _accessTimeColumn = "accessTime";
        protected String _lastAccessTimeColumn = "lastAccessTime";
        protected String _createTimeColumn = "createTime";
        protected String _cookieTimeColumn = "cookieTime";
        protected String _lastSavedTimeColumn = "lastSavedTime";
        protected String _expiryTimeColumn = "expiryTime";
        protected String _maxIntervalColumn = "maxInterval";
        protected String _mapColumn = "map";

        protected void setDatabaseAdaptor(DatabaseAdaptor dbadaptor) {
            this._dbAdaptor = dbadaptor;
        }

        public String getTableName() {
            return this._tableName;
        }

        public void setTableName(String tableName) {
            this.checkNotNull(tableName);
            this._tableName = tableName;
        }

        public String getSchemaName() {
            return this._schemaName;
        }

        public void setSchemaName(String schemaName) {
            this.checkNotNull(schemaName);
            this._schemaName = schemaName;
        }

        public String getRowIdColumn() {
            if ("rowId".equals(this._rowIdColumn) && this._dbAdaptor.isRowIdReserved()) {
                this._rowIdColumn = "srowId";
            }
            return this._rowIdColumn;
        }

        public void setRowIdColumn(String rowIdColumn) {
            this.checkNotNull(rowIdColumn);
            if (this._dbAdaptor == null) {
                throw new IllegalStateException("DbAdaptor is null");
            }
            if (this._dbAdaptor.isRowIdReserved() && "rowId".equals(rowIdColumn)) {
                throw new IllegalArgumentException("rowId is reserved word for Oracle");
            }
            this._rowIdColumn = rowIdColumn;
        }

        public String getIdColumn() {
            return this._idColumn;
        }

        public void setIdColumn(String idColumn) {
            this.checkNotNull(idColumn);
            this._idColumn = idColumn;
        }

        public String getContextPathColumn() {
            return this._contextPathColumn;
        }

        public void setContextPathColumn(String contextPathColumn) {
            this.checkNotNull(contextPathColumn);
            this._contextPathColumn = contextPathColumn;
        }

        public String getVirtualHostColumn() {
            return this._virtualHostColumn;
        }

        public void setVirtualHostColumn(String virtualHostColumn) {
            this.checkNotNull(virtualHostColumn);
            this._virtualHostColumn = virtualHostColumn;
        }

        public String getLastNodeColumn() {
            return this._lastNodeColumn;
        }

        public void setLastNodeColumn(String lastNodeColumn) {
            this.checkNotNull(lastNodeColumn);
            this._lastNodeColumn = lastNodeColumn;
        }

        public String getAccessTimeColumn() {
            return this._accessTimeColumn;
        }

        public void setAccessTimeColumn(String accessTimeColumn) {
            this.checkNotNull(accessTimeColumn);
            this._accessTimeColumn = accessTimeColumn;
        }

        public String getLastAccessTimeColumn() {
            return this._lastAccessTimeColumn;
        }

        public void setLastAccessTimeColumn(String lastAccessTimeColumn) {
            this.checkNotNull(lastAccessTimeColumn);
            this._lastAccessTimeColumn = lastAccessTimeColumn;
        }

        public String getCreateTimeColumn() {
            return this._createTimeColumn;
        }

        public void setCreateTimeColumn(String createTimeColumn) {
            this.checkNotNull(createTimeColumn);
            this._createTimeColumn = createTimeColumn;
        }

        public String getCookieTimeColumn() {
            return this._cookieTimeColumn;
        }

        public void setCookieTimeColumn(String cookieTimeColumn) {
            this.checkNotNull(cookieTimeColumn);
            this._cookieTimeColumn = cookieTimeColumn;
        }

        public String getLastSavedTimeColumn() {
            return this._lastSavedTimeColumn;
        }

        public void setLastSavedTimeColumn(String lastSavedTimeColumn) {
            this.checkNotNull(lastSavedTimeColumn);
            this._lastSavedTimeColumn = lastSavedTimeColumn;
        }

        public String getExpiryTimeColumn() {
            return this._expiryTimeColumn;
        }

        public void setExpiryTimeColumn(String expiryTimeColumn) {
            this.checkNotNull(expiryTimeColumn);
            this._expiryTimeColumn = expiryTimeColumn;
        }

        public String getMaxIntervalColumn() {
            return this._maxIntervalColumn;
        }

        public void setMaxIntervalColumn(String maxIntervalColumn) {
            this.checkNotNull(maxIntervalColumn);
            this._maxIntervalColumn = maxIntervalColumn;
        }

        public String getMapColumn() {
            return this._mapColumn;
        }

        public void setMapColumn(String mapColumn) {
            this.checkNotNull(mapColumn);
            this._mapColumn = mapColumn;
        }

        public String getCreateStatementAsString() {
            if (this._dbAdaptor == null) {
                throw new IllegalStateException("No DBAdaptor");
            }
            String blobType = this._dbAdaptor.getBlobType();
            String longType = this._dbAdaptor.getLongType();
            return "create table " + this.getSchemaTableName() + " (" + this.getRowIdColumn() + " varchar(120), " + this._idColumn + " varchar(120), " + this._contextPathColumn + " varchar(60), " + this._virtualHostColumn + " varchar(60), " + this._lastNodeColumn + " varchar(60), " + this._accessTimeColumn + " " + longType + ", " + this._lastAccessTimeColumn + " " + longType + ", " + this._createTimeColumn + " " + longType + ", " + this._cookieTimeColumn + " " + longType + ", " + this._lastSavedTimeColumn + " " + longType + ", " + this._expiryTimeColumn + " " + longType + ", " + this._maxIntervalColumn + " " + longType + ", " + this._mapColumn + " " + blobType + ", primary key(" + this.getRowIdColumn() + "))";
        }

        public String getCreateIndexOverExpiryStatementAsString(String indexName) {
            return "create index " + indexName + " on " + this.getSchemaTableName() + " (" + this.getExpiryTimeColumn() + ")";
        }

        public String getCreateIndexOverSessionStatementAsString(String indexName) {
            return "create index " + indexName + " on " + this.getSchemaTableName() + " (" + this.getIdColumn() + ", " + this.getContextPathColumn() + ")";
        }

        public String getAlterTableForMaxIntervalAsString() {
            if (this._dbAdaptor == null) {
                throw new IllegalStateException("No DBAdaptor");
            }
            String longType = this._dbAdaptor.getLongType();
            String stem = "alter table " + this.getSchemaTableName() + " add " + this.getMaxIntervalColumn() + " " + longType;
            if (this._dbAdaptor.getDBName().contains("oracle")) {
                return stem + " default " + -999 + " not null";
            }
            return stem + " not null default " + -999;
        }

        private String getSchemaTableName() {
            return (this.getSchemaName() != null ? this.getSchemaName() + "." : "") + this.getTableName();
        }

        private void checkNotNull(String s) {
            if (s == null) {
                throw new IllegalArgumentException(s);
            }
        }

        public String getInsertSessionStatementAsString() {
            return "insert into " + this.getSchemaTableName() + " (" + this.getRowIdColumn() + ", " + this.getIdColumn() + ", " + this.getContextPathColumn() + ", " + this.getVirtualHostColumn() + ", " + this.getLastNodeColumn() + ", " + this.getAccessTimeColumn() + ", " + this.getLastAccessTimeColumn() + ", " + this.getCreateTimeColumn() + ", " + this.getCookieTimeColumn() + ", " + this.getLastSavedTimeColumn() + ", " + this.getExpiryTimeColumn() + ", " + this.getMaxIntervalColumn() + ", " + this.getMapColumn() + ")  values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        }

        public String getDeleteSessionStatementAsString() {
            return "delete from " + this.getSchemaTableName() + " where " + this.getRowIdColumn() + " = ?";
        }

        public String getUpdateSessionStatementAsString() {
            return "update " + this.getSchemaTableName() + " set " + this.getIdColumn() + " = ?, " + this.getLastNodeColumn() + " = ?, " + this.getAccessTimeColumn() + " = ?, " + this.getLastAccessTimeColumn() + " = ?, " + this.getLastSavedTimeColumn() + " = ?, " + this.getExpiryTimeColumn() + " = ?, " + this.getMaxIntervalColumn() + " = ?, " + this.getMapColumn() + " = ? where " + this.getRowIdColumn() + " = ?";
        }

        public String getUpdateSessionNodeStatementAsString() {
            return "update " + this.getSchemaTableName() + " set " + this.getLastNodeColumn() + " = ? where " + this.getRowIdColumn() + " = ?";
        }

        public String getUpdateSessionAccessTimeStatementAsString() {
            return "update " + this.getSchemaTableName() + " set " + this.getLastNodeColumn() + " = ?, " + this.getAccessTimeColumn() + " = ?, " + this.getLastAccessTimeColumn() + " = ?, " + this.getLastSavedTimeColumn() + " = ?, " + this.getExpiryTimeColumn() + " = ?, " + this.getMaxIntervalColumn() + " = ? where " + this.getRowIdColumn() + " = ?";
        }

        public String getBoundedExpiredSessionsStatementAsString() {
            return "select * from " + this.getSchemaTableName() + " where " + this.getLastNodeColumn() + " = ? and " + this.getExpiryTimeColumn() + " >= ? and " + this.getExpiryTimeColumn() + " <= ?";
        }

        public String getSelectExpiredSessionsStatementAsString() {
            return "select * from " + this.getSchemaTableName() + " where " + this.getExpiryTimeColumn() + " >0 and " + this.getExpiryTimeColumn() + " <= ?";
        }

        public PreparedStatement getLoadStatement(Connection connection, String rowId, String contextPath, String virtualHosts) throws SQLException {
            if (this._dbAdaptor == null) {
                throw new IllegalStateException("No DB adaptor");
            }
            if ((contextPath == null || "".equals(contextPath)) && this._dbAdaptor.isEmptyStringNull()) {
                PreparedStatement statement = connection.prepareStatement("select * from " + this.getSchemaTableName() + " where " + this.getIdColumn() + " = ? and " + this.getContextPathColumn() + " is null and " + this.getVirtualHostColumn() + " = ?");
                statement.setString(1, rowId);
                statement.setString(2, virtualHosts);
                return statement;
            }
            PreparedStatement statement = connection.prepareStatement("select * from " + this.getSchemaTableName() + " where " + this.getIdColumn() + " = ? and " + this.getContextPathColumn() + " = ? and " + this.getVirtualHostColumn() + " = ?");
            statement.setString(1, rowId);
            statement.setString(2, contextPath);
            statement.setString(3, virtualHosts);
            return statement;
        }
    }
}

