/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.model;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.artifacts.VersionConstraint;
import org.gradle.api.artifacts.capability.CapabilitySelector;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.artifacts.component.ProjectComponentSelector;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.immutable.ImmutableAttributesSchema;
import org.gradle.internal.component.external.model.DefaultModuleComponentSelector;
import org.gradle.internal.component.external.model.ExternalDependencyDescriptor;
import org.gradle.internal.component.external.model.ModuleDependencyMetadata;
import org.gradle.internal.component.local.model.DefaultProjectDependencyMetadata;
import org.gradle.internal.component.model.ComponentGraphResolveState;
import org.gradle.internal.component.model.DependencyMetadata;
import org.gradle.internal.component.model.ExcludeMetadata;
import org.gradle.internal.component.model.GraphVariantSelectionResult;
import org.gradle.internal.component.model.GraphVariantSelector;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.component.model.VariantGraphResolveState;

public abstract class ExternalModuleDependencyMetadata
implements ModuleDependencyMetadata {
    private final String reason;
    private final boolean isEndorsing;
    private final List<IvyArtifactName> artifacts;

    public ExternalModuleDependencyMetadata(@Nullable String reason, boolean endorsing, List<IvyArtifactName> artifacts) {
        this.reason = reason;
        this.isEndorsing = endorsing;
        this.artifacts = artifacts;
    }

    public abstract ExternalDependencyDescriptor getDependencyDescriptor();

    @Override
    public GraphVariantSelectionResult selectVariants(GraphVariantSelector variantSelector, ImmutableAttributes consumerAttributes, ComponentGraphResolveState targetComponentState, ImmutableAttributesSchema consumerSchema, Set<CapabilitySelector> explicitRequestedCapabilities) {
        if (!targetComponentState.getCandidatesForGraphVariantSelection().getVariantsForAttributeMatching().isEmpty()) {
            VariantGraphResolveState selected = variantSelector.selectByAttributeMatching(consumerAttributes, explicitRequestedCapabilities, targetComponentState, consumerSchema, this.getArtifacts());
            return new GraphVariantSelectionResult(Collections.singletonList(selected), true);
        }
        return this.selectLegacyConfigurations(variantSelector, consumerAttributes, targetComponentState, consumerSchema);
    }

    protected abstract GraphVariantSelectionResult selectLegacyConfigurations(GraphVariantSelector var1, ImmutableAttributes var2, ComponentGraphResolveState var3, ImmutableAttributesSchema var4);

    @Override
    public List<IvyArtifactName> getArtifacts() {
        return this.artifacts;
    }

    @Override
    public abstract List<ExcludeMetadata> getExcludes();

    @Override
    public DependencyMetadata withTarget(ComponentSelector target) {
        if (target instanceof ModuleComponentSelector) {
            ModuleComponentSelector moduleTarget = (ModuleComponentSelector)target;
            ModuleComponentSelector newSelector = DefaultModuleComponentSelector.newSelector(moduleTarget.getModuleIdentifier(), moduleTarget.getVersionConstraint(), moduleTarget.getAttributes(), moduleTarget.getCapabilitySelectors());
            if (newSelector.equals(this.getSelector())) {
                return this;
            }
            return this.withRequested(newSelector);
        }
        if (target instanceof ProjectComponentSelector) {
            ProjectComponentSelector projectTarget = (ProjectComponentSelector)target;
            return new DefaultProjectDependencyMetadata(projectTarget, this);
        }
        throw new IllegalArgumentException("Unexpected selector provided: " + target);
    }

    @Override
    public DependencyMetadata withTargetAndArtifacts(ComponentSelector target, List<IvyArtifactName> artifacts) {
        if (target instanceof ModuleComponentSelector) {
            ModuleComponentSelector moduleTarget = (ModuleComponentSelector)target;
            ModuleComponentSelector newSelector = DefaultModuleComponentSelector.newSelector(moduleTarget.getModuleIdentifier(), moduleTarget.getVersionConstraint(), moduleTarget.getAttributes(), moduleTarget.getCapabilitySelectors());
            if (newSelector.equals(this.getSelector()) && this.getArtifacts().equals(artifacts)) {
                return this;
            }
            return this.withRequestedAndArtifacts(newSelector, artifacts);
        }
        if (target instanceof ProjectComponentSelector) {
            ProjectComponentSelector projectTarget = (ProjectComponentSelector)target;
            return new DefaultProjectDependencyMetadata(projectTarget, this);
        }
        throw new IllegalArgumentException("Unexpected selector provided: " + target);
    }

    @Override
    public ModuleDependencyMetadata withRequestedVersion(VersionConstraint requestedVersion) {
        ModuleComponentSelector selector = this.getSelector();
        if (requestedVersion.equals(selector.getVersionConstraint())) {
            return this;
        }
        ModuleComponentSelector newSelector = DefaultModuleComponentSelector.newSelector(selector.getModuleIdentifier(), requestedVersion, selector.getAttributes(), selector.getCapabilitySelectors());
        return this.withRequested(newSelector);
    }

    protected abstract ModuleDependencyMetadata withRequested(ModuleComponentSelector var1);

    protected abstract ModuleDependencyMetadata withRequestedAndArtifacts(ModuleComponentSelector var1, List<IvyArtifactName> var2);

    @Override
    public ModuleComponentSelector getSelector() {
        return this.getDependencyDescriptor().getSelector();
    }

    @Override
    public boolean isChanging() {
        return this.getDependencyDescriptor().isChanging();
    }

    @Override
    public boolean isTransitive() {
        return this.getDependencyDescriptor().isTransitive();
    }

    @Override
    public boolean isConstraint() {
        return this.getDependencyDescriptor().isConstraint();
    }

    @Override
    public boolean isEndorsingStrictVersions() {
        return this.isEndorsing;
    }

    @Override
    @Nullable
    public String getReason() {
        return this.reason;
    }

    public String toString() {
        return this.getDependencyDescriptor().toString();
    }
}

