/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.type;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordCategory;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractMsType;

public abstract class AbstractBasicArrayMsType
extends AbstractMsType {
    protected RecordNumber underlyingRecordNumber;

    public AbstractBasicArrayMsType(AbstractPdb pdb, PdbByteReader reader, int recordNumberSize) throws PdbException {
        super(pdb, reader);
        this.underlyingRecordNumber = RecordNumber.parse(pdb, reader, RecordCategory.TYPE, recordNumberSize);
    }

    public RecordNumber getModifiedRecordNumber() {
        return this.underlyingRecordNumber;
    }

    public AbstractMsType getUnderlyingType() {
        return this.pdb.getTypeRecord(this.underlyingRecordNumber);
    }

    @Override
    public void emit(StringBuilder builder, AbstractMsType.Bind bind) {
        this.getUnderlyingType().emit(builder, bind);
        if (bind.ordinal() < AbstractMsType.Bind.ARRAY.ordinal()) {
            builder.insert(0, "(");
            builder.append(")");
        }
        builder.append("[]");
    }
}

