/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.data;

import db.DBHandle;
import generic.depends.DependentServiceResolver;
import generic.depends.err.ServiceConstructionException;
import generic.depends.err.UnsatisfiedFieldsException;
import generic.depends.err.UnsatisfiedParameterException;
import ghidra.framework.data.DomainObjectAdapterDB;
import ghidra.framework.data.OpenMode;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public abstract class DBDomainObjectSupport
extends DomainObjectAdapterDB {
    private OpenMode openMode;
    private TaskMonitor monitor;
    private VersionException versionExc;

    protected DBDomainObjectSupport(DBHandle dbh, OpenMode openMode, TaskMonitor monitor, String name, int timeInterval, int bufSize, Object consumer) {
        super(dbh, name, timeInterval, consumer);
        this.openMode = openMode;
        this.monitor = monitor;
    }

    public void init() throws CancelledException, IOException, VersionException, ServiceConstructionException {
        this.versionExc = null;
        try {
            DependentServiceResolver.inject(this);
        }
        catch (ServiceConstructionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof VersionException) {
                throw (VersionException)cause;
            }
            if (cause instanceof CancelledException) {
                throw (CancelledException)cause;
            }
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw e;
        }
        catch (UnsatisfiedFieldsException | UnsatisfiedParameterException e) {
            throw new AssertionError((Object)e);
        }
        if (this.versionExc != null) {
            throw this.versionExc;
        }
        this.finishedCreatingManagers();
        this.monitor = null;
    }

    protected void finishedCreatingManagers() {
    }

    protected <T> T createManager(String managerName, ManagerSupplier<T> supplier) throws CancelledException, IOException {
        this.monitor.checkCancelled();
        this.monitor.setMessage("Creating " + managerName);
        try {
            return supplier.create(this.openMode, this.monitor);
        }
        catch (VersionException e) {
            this.versionExc = e.combine(this.versionExc);
            return null;
        }
    }

    protected static interface ManagerSupplier<T> {
        public T create(OpenMode var1, TaskMonitor var2) throws IOException, VersionException, CancelledException;
    }
}

