/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.stack;

import ghidra.app.plugin.core.debug.stack.StackUnwindWarningSet;
import ghidra.app.services.DebuggerControlService;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.Varnode;
import java.math.BigInteger;
import java.util.concurrent.CompletableFuture;

public interface UnwoundFrame<T> {
    public boolean isFake();

    public int getLevel();

    public String getDescription();

    public Address getProgramCounter();

    public Function getFunction();

    public Address getBasePointer();

    public Address getReturnAddress();

    public StackUnwindWarningSet getWarnings();

    public Exception getError();

    public T getValue(Program var1, VariableStorage var2);

    default public T getValue(Variable variable) {
        return this.getValue(variable.getProgram(), variable.getVariableStorage());
    }

    public T getValue(Register var1);

    public T evaluate(Program var1, VariableStorage var2, AddressSetView var3);

    public T evaluate(Program var1, Varnode var2, AddressSetView var3);

    public T evaluate(Program var1, PcodeOp var2, AddressSetView var3);

    public CompletableFuture<Void> setValue(DebuggerControlService.StateEditor var1, Program var2, VariableStorage var3, BigInteger var4);

    default public CompletableFuture<Void> setValue(DebuggerControlService.StateEditor editor, Variable variable, BigInteger value) {
        return this.setValue(editor, variable.getProgram(), variable.getVariableStorage(), value);
    }

    public CompletableFuture<Void> setReturnAddress(DebuggerControlService.StateEditor var1, Address var2);

    public T zext(T var1, int var2);
}

