/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.datastruct;

import ghidra.util.LongIterator;
import ghidra.util.datastruct.IndexRangeIterator;
import ghidra.util.datastruct.NoSuchIndexException;
import ghidra.util.datastruct.PropertySetIndexRangeIterator;
import ghidra.util.datastruct.ValueRange;
import ghidra.util.exception.NoValueException;
import ghidra.util.map.IntValueMap;

public class RangeMap {
    IntValueMap map = new IntValueMap("RangeMap");
    int defaultValue;

    public RangeMap() {
        this(0);
    }

    public RangeMap(int defaultValue) {
        this.defaultValue = defaultValue;
        this.map.putInt(0L, defaultValue);
    }

    public int getNumRanges() {
        return this.map.getSize();
    }

    public void clear() {
        this.map.removeRange(0L, Long.MAX_VALUE);
        this.map.putInt(0L, this.defaultValue);
    }

    public void paintRange(long start, long end, int value) {
        long next;
        if (end != Long.MAX_VALUE) {
            int origEndValue = this.getValue(end + 1L);
            if (origEndValue != value) {
                this.map.putInt(end + 1L, origEndValue);
            } else {
                this.map.remove(end + 1L);
            }
        }
        LongIterator it = this.map.getPropertyIterator(start);
        while (it.hasNext() && (next = it.next()) <= end) {
            this.map.remove(next);
        }
        if (start == 0L) {
            this.map.putInt(0L, value);
        } else {
            int startValue = this.getValue(start);
            if (startValue != value) {
                this.map.putInt(start, value);
            }
        }
    }

    public int getValue(long index) {
        try {
            return this.map.getInt(index);
        }
        catch (NoValueException e) {
            try {
                index = this.map.getPreviousPropertyIndex(index);
                return this.map.getInt(index);
            }
            catch (NoSuchIndexException noSuchIndexException) {
            }
            catch (NoValueException noValueException) {
                // empty catch block
            }
            return 0;
        }
    }

    public ValueRange getValueRange(long index) {
        if (this.map.getSize() == 1) {
            return new ValueRange(0L, Long.MAX_VALUE, this.defaultValue);
        }
        long start = 0L;
        if (this.map.hasProperty(index)) {
            start = index;
        } else {
            try {
                start = this.map.getPreviousPropertyIndex(index);
            }
            catch (NoSuchIndexException noSuchIndexException) {
                // empty catch block
            }
        }
        long end = Long.MAX_VALUE;
        try {
            end = this.map.getNextPropertyIndex(start) - 1L;
        }
        catch (NoSuchIndexException noSuchIndexException) {
            // empty catch block
        }
        int value = 0;
        try {
            value = this.map.getInt(start);
        }
        catch (NoValueException noValueException) {
            // empty catch block
        }
        return new ValueRange(start, end, value);
    }

    public IndexRangeIterator getIndexRangeIterator(long index) {
        return new PropertySetIndexRangeIterator(this.map, index);
    }

    public LongIterator getChangePointIterator(long start, long end) {
        return this.map.getPropertyIterator(start, end);
    }
}

