/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.elf.relocation;

import ghidra.app.plugin.core.reloc.ElfRelocationFixupHandler;
import ghidra.app.util.bin.format.elf.relocation.ARM_ElfRelocationType;
import ghidra.program.model.address.Address;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Processor;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.reloc.Relocation;
import ghidra.program.model.util.CodeUnitInsertionException;

public class ElfArmRelocationFixupHandler
extends ElfRelocationFixupHandler {
    public ElfArmRelocationFixupHandler() {
        super(ARM_ElfRelocationType.class);
    }

    public boolean processRelocation(Program program, Relocation relocation, Address oldImageBase, Address newImageBase) throws MemoryAccessException, CodeUnitInsertionException {
        if (relocation.getStatus() != Relocation.Status.APPLIED) {
            return false;
        }
        ARM_ElfRelocationType type = (ARM_ElfRelocationType)this.getRelocationType(relocation.getType());
        if (type == null) {
            return false;
        }
        switch (type) {
            case R_ARM_NONE: 
            case R_ARM_ABS32: 
            case R_ARM_REL32: 
            case R_ARM_GLOB_DAT: 
            case R_ARM_RELATIVE: 
            case R_ARM_PLT32: 
            case R_ARM_CALL: 
            case R_ARM_JUMP24: 
            case R_ARM_THM_JUMP24: {
                return this.process32BitRelocation(program, relocation, oldImageBase, newImageBase);
            }
        }
        return false;
    }

    public boolean handlesProgram(Program program) {
        if (!"Executable and Linking Format (ELF)".equals(program.getExecutableFormat())) {
            return false;
        }
        Language language = program.getLanguage();
        if (language.getLanguageDescription().getSize() != 32) {
            return false;
        }
        Processor processor = language.getProcessor();
        return processor.equals((Object)Processor.findOrPossiblyCreateProcessor((String)"ARM"));
    }
}

