/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.pcode;

import ghidra.program.model.data.DataType;
import ghidra.program.model.pcode.AttributeId;
import ghidra.program.model.pcode.Decoder;
import ghidra.program.model.pcode.DecoderException;
import ghidra.program.model.pcode.HighFunction;
import ghidra.program.model.pcode.HighSymbol;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.model.pcode.VarnodeAST;
import java.util.ArrayList;

public abstract class HighVariable {
    protected String name;
    protected DataType type;
    protected Varnode represent;
    protected Varnode[] instances;
    protected int offset = -1;
    protected HighFunction function;

    protected HighVariable(HighFunction func) {
        this.function = func;
    }

    protected HighVariable(String nm, DataType tp, Varnode rep, Varnode[] inst, HighFunction func) {
        this.name = nm;
        this.type = tp;
        this.function = func;
        this.attachInstances(inst, rep);
    }

    protected void setHighOnInstances() {
        for (Varnode instance : this.instances) {
            if (!(instance instanceof VarnodeAST)) continue;
            ((VarnodeAST)instance).setHigh(this);
        }
    }

    public HighFunction getHighFunction() {
        return this.function;
    }

    public String getName() {
        return this.name;
    }

    public int getSize() {
        return this.represent.getSize();
    }

    public DataType getDataType() {
        return this.type;
    }

    public Varnode getRepresentative() {
        return this.represent;
    }

    public Varnode[] getInstances() {
        return this.instances;
    }

    public abstract HighSymbol getSymbol();

    public int getOffset() {
        return this.offset;
    }

    public void attachInstances(Varnode[] inst, Varnode rep) {
        this.represent = rep;
        if (inst == null) {
            this.instances = new Varnode[1];
            this.instances[0] = rep;
        } else {
            this.instances = inst;
        }
    }

    protected void decodeInstances(Decoder decoder) throws DecoderException {
        int subel;
        int repref = (int)decoder.readUnsignedInteger(AttributeId.ATTRIB_REPREF);
        Varnode rep = this.function.getRef(repref);
        if (rep == null) {
            throw new DecoderException("Undefined varnode reference");
        }
        this.type = null;
        ArrayList<Varnode> vnlist = new ArrayList<Varnode>();
        this.type = this.function.getDataTypeManager().decodeDataType(decoder);
        while ((subel = decoder.peekElement()) != 0) {
            Varnode vn = Varnode.decode(decoder, this.function);
            vnlist.add(vn);
        }
        Varnode[] vnarray = new Varnode[vnlist.size()];
        vnlist.toArray(vnarray);
        this.attachInstances(vnarray, rep);
        this.setHighOnInstances();
    }

    public boolean requiresDynamicStorage() {
        if (this.represent.isUnique()) {
            return true;
        }
        return this.represent.getAddress().isStackAddress() && !this.represent.isAddrTied();
    }

    public abstract void decode(Decoder var1) throws DecoderException;
}

