/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main;

import docking.framework.ApplicationInformationDisplayFactory;
import generic.theme.GIcon;
import ghidra.framework.main.AppInfo;
import ghidra.framework.main.FrontEndTool;
import ghidra.framework.main.InfoPanel;
import ghidra.util.HelpLocation;
import java.awt.Image;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;

public class GhidraApplicationInformationDisplayFactory
extends ApplicationInformationDisplayFactory {
    protected List<Image> doGetWindowIcons() {
        ArrayList<Image> list = new ArrayList<Image>();
        list.add(this.image("icon.base.application.16"));
        list.add(this.image("icon.base.application.24"));
        list.add(this.image("icon.base.application.32"));
        list.add(this.image("icon.base.application.40"));
        list.add(this.image("icon.base.application.48"));
        list.add(this.image("icon.base.application.64"));
        list.add(this.image("icon.base.application.128"));
        list.add(this.image("icon.base.application.256"));
        return list;
    }

    private Image image(String id) {
        return new GIcon(id).getImageIcon().getImage();
    }

    protected String doCreateSplashScreenTitle() {
        return "Welcome To Ghidra";
    }

    protected String doCreateAboutTitle() {
        return "About Ghidra";
    }

    protected HelpLocation doCreateHelpLocation() {
        return new HelpLocation("About", "About_Ghidra");
    }

    protected JComponent doCreateSplashScreenComponent() {
        return new InfoPanel();
    }

    public Icon doGetHomeIcon() {
        return new GIcon("icon.base.application.home");
    }

    protected Runnable doGetHomeCallback() {
        return () -> {
            FrontEndTool frontEndTool = AppInfo.getFrontEndTool();
            frontEndTool.toFront();
        };
    }
}

