/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.data;

import docking.action.KeyBindingData;
import docking.action.KeyBindingType;
import docking.action.MenuData;
import ghidra.app.context.ListingActionContext;
import ghidra.app.context.ListingContextAction;
import ghidra.app.plugin.core.data.DataPlugin;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Dynamic;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.Union;
import ghidra.util.HelpLocation;
import javax.swing.KeyStroke;

class DataAction
extends ListingContextAction {
    protected DataType dataType;
    protected DataPlugin plugin;

    public DataAction(DataType dataType, DataPlugin plugin) {
        this("Define " + dataType.getDisplayName(), "Data", dataType, plugin);
    }

    public DataAction(String name, String group, DataType dataType, DataPlugin plugin) {
        super(name, plugin.getName(), KeyBindingType.SHARED);
        this.plugin = plugin;
        this.dataType = dataType;
        this.setPopupMenuData(new MenuData(new String[]{"Data", dataType.getDisplayName()}, group));
        this.assignHelpID(dataType);
        this.initKeyStroke(this.getDefaultKeyStroke());
    }

    protected KeyStroke getDefaultKeyStroke() {
        return null;
    }

    protected void initKeyStroke(KeyStroke keyStroke) {
        if (keyStroke == null) {
            return;
        }
        this.setKeyBindingData(new KeyBindingData(keyStroke));
    }

    DataType getDataType() {
        return this.dataType;
    }

    public void dispose() {
        this.dataType = null;
        this.plugin = null;
        super.dispose();
    }

    @Override
    public void actionPerformed(ListingActionContext context) {
        this.plugin.doCreateData(context, this.dataType, true);
    }

    @Override
    public boolean isEnabledForContext(ListingActionContext context) {
        return this.plugin.isCreateDataAllowed(context);
    }

    private void assignHelpID(DataType dt) {
        String helpID = "Favorites";
        if (dt instanceof Structure) {
            helpID = "Structure";
        } else if (dt instanceof Union) {
            helpID = "Union";
        } else if (dt instanceof Pointer) {
            helpID = "Define_Pointer";
        } else if (dt instanceof Dynamic) {
            helpID = "DynamicDataType";
        }
        this.setHelpLocation(new HelpLocation(this.plugin.getName(), helpID));
    }
}

