/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.util;

import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OSUtils {
    private static final Logger logger = Logger.getLogger(OSUtils.class.getName());
    private static final String SEPARATOR = System.getProperty("file.separator");

    public static String getOperatingSystem() {
        return System.getProperty("os.name");
    }

    public static boolean onMacOSX() {
        return "Mac OS X".equals(OSUtils.getOperatingSystem());
    }

    public static boolean onUnix() {
        return "/".equals(SEPARATOR);
    }

    public static boolean onWindows() {
        return OSUtils.getOperatingSystem().startsWith("Windows");
    }

    public static final void launchBrowser(String url) {
        try {
            URI uri = URI.create(url);
            Desktop.getDesktop().browse(uri);
        }
        catch (IOException e) {
            logger.log(Level.FINEST, "Web browser failed to launch via Desktop Class.", e);
            String[] browser = OSUtils.getBrowserExecString(url);
            try {
                Runtime.getRuntime().exec(browser);
            }
            catch (IOException re) {
                logger.log(Level.FINEST, "Web browser failed to launch via Runtime Class.", re);
            }
        }
    }

    private static final String[] getBrowserExecString(String url) {
        if (OSUtils.onMacOSX()) {
            return new String[]{"open", "-a", "Safari", url};
        }
        if (OSUtils.onUnix()) {
            return new String[]{"xdg-open", url};
        }
        if (OSUtils.onWindows()) {
            return new String[]{"rundll32.exe", "url.dll,FileProtocolHandler", url};
        }
        return new String[]{"firefox", url};
    }
}

