/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.Random;
import net.sf.freecol.common.model.RandomRange;
import net.sf.freecol.util.test.FreeColTestCase;

public class RandomRangeTest
extends FreeColTestCase {
    public void testRandomRange() {
        Random random = new Random();
        RandomRange r = new RandomRange(100, 1, 4, 1000);
        for (int i = 0; i < 25; ++i) {
            int vc = r.getAmount("test-c", random, true);
            int vd = r.getAmount("test-n", random, false);
            RandomRangeTest.assertTrue((String)("Continuous range (" + vc + ")"), (1000 <= vc && vc <= 5000 ? 1 : 0) != 0);
            RandomRangeTest.assertTrue((String)("Discrete range (" + vd + ")"), (vd == 1000 || vd == 2000 || vd == 3000 || vd == 4000 ? 1 : 0) != 0);
        }
        try {
            r = new RandomRange(-1, 1, 4, 1000);
            RandomRangeTest.fail((String)"Negative probability should fail");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            r = new RandomRange(100, 1, 0, 1000);
            RandomRangeTest.fail((String)"Min > max should fail");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

