/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai.mission;

import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.pathfinding.CostDeciders;
import net.sf.freecol.common.util.LogBuilder;
import net.sf.freecol.server.ai.AIColony;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.mission.Mission;

public final class WorkInsideColonyMission
extends Mission {
    private static final Logger logger = Logger.getLogger(WorkInsideColonyMission.class.getName());
    public static final String TAG = "workInsideColonyMission";
    private static final String tag = "AI worker";
    private Colony colony;
    private static final String COLONY_TAG = "colony";

    public WorkInsideColonyMission(AIMain aiMain, AIUnit aiUnit, AIColony aiColony) {
        super(aiMain, aiUnit);
        this.setTarget(aiColony.getColony());
    }

    public WorkInsideColonyMission(AIMain aiMain, AIUnit aiUnit, FreeColXMLReader xr) throws XMLStreamException {
        super(aiMain, aiUnit);
        this.readFromXML(xr);
    }

    public AIColony getAIColony() {
        return this.getAIMain().getAIColony(this.colony);
    }

    public static String invalidMissionReason(AIUnit aiUnit, Location loc) {
        String reason = WorkInsideColonyMission.invalidAIUnitReason(aiUnit);
        return reason != null ? reason : (!aiUnit.getUnit().isPerson() ? "unit-not-a-person" : ((reason = WorkInsideColonyMission.invalidTargetReason(loc, aiUnit.getUnit().getOwner())) != null ? reason : null));
    }

    @Override
    public int getBaseTransportPriority() {
        return 100;
    }

    @Override
    public Location getTarget() {
        return this.colony;
    }

    @Override
    public void setTarget(Location target) {
        if (target instanceof Colony) {
            this.colony = (Colony)target;
        }
    }

    @Override
    public Location findTarget() {
        return this.getTarget();
    }

    @Override
    public String invalidReason() {
        return WorkInsideColonyMission.invalidMissionReason(this.getAIUnit(), this.getTarget());
    }

    @Override
    public Mission doMission(LogBuilder lb) {
        lb.add(tag);
        String reason = this.invalidReason();
        if (reason != null) {
            return this.lbFail(lb, false, reason);
        }
        Unit unit = this.getUnit();
        Unit.MoveType mt = this.travelToTarget(this.getTarget(), CostDeciders.avoidSettlementsAndBlockingUnits(), lb);
        switch (mt) {
            case MOVE: {
                break;
            }
            case MOVE_HIGH_SEAS: 
            case MOVE_NO_MOVES: 
            case MOVE_ILLEGAL: {
                return this.lbWait(lb, new Object[0]);
            }
            case MOVE_NO_REPAIR: {
                return this.lbFail(lb, false, "aiUnit-died");
            }
            case MOVE_NO_ACCESS_EMBARK: 
            case MOVE_NO_TILE: {
                return this;
            }
            default: {
                return this.lbMove(lb, mt);
            }
        }
        this.lbAt(lb);
        if (unit.isInColony()) {
            lb.add(", working");
        }
        return this.lbWait(lb, new Object[0]);
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        xw.writeAttribute(COLONY_TAG, this.colony);
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        this.colony = xr.getAttribute(this.getGame(), COLONY_TAG, Colony.class, (Colony)null);
    }

    @Override
    public String getXMLTagName() {
        return TAG;
    }
}

