/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.HashSet;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.ModelMessage;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.util.test.FreeColTestCase;

public class ModelMessageTest
extends FreeColTestCase {
    public void testHashCode() {
        Game game = ModelMessageTest.getGame();
        game.changeMap(ModelMessageTest.getTestMap(true));
        Colony colony = this.getStandardColony(1);
        GoodsType cotton = ModelMessageTest.spec().getGoodsType("model.goods.cotton");
        ModelMessage mm1 = new ModelMessage(ModelMessage.MessageType.MISSING_GOODS, "buildColony.landLocked", colony, cotton);
        ModelMessage mm2 = new ModelMessage(ModelMessage.MessageType.MISSING_GOODS, "buildColony.landLocked", colony, cotton);
        ModelMessageTest.assertEquals((Object)mm1, (Object)mm2);
        ModelMessageTest.assertEquals((int)mm1.hashCode(), (int)mm2.hashCode());
        ModelMessage mm3 = new ModelMessage(ModelMessage.MessageType.MISSING_GOODS, "buildColony.landLocked", colony, cotton);
        ModelMessage mm4 = new ModelMessage(ModelMessage.MessageType.MISSING_GOODS, "buildColony.landLocked", colony, cotton);
        ModelMessageTest.assertNotSame((Object)mm3, (Object)mm4);
        ModelMessageTest.assertNotSame((Object)mm3.hashCode(), (Object)mm4.hashCode());
    }

    public void testModelMapSet2() {
        Game game = ModelMessageTest.getGame();
        game.changeMap(ModelMessageTest.getTestMap(true));
        Colony colony = this.getStandardColony(1);
        GoodsType cotton = ModelMessageTest.spec().getGoodsType("model.goods.cotton");
        ModelMessage mm1 = (ModelMessage)((StringTemplate)((StringTemplate)new ModelMessage(ModelMessage.MessageType.WAREHOUSE_CAPACITY, "model.building.warehouseSoonFull", colony, cotton).addNamed("%goods%", cotton)).addName("%colony%", colony.getName())).addAmount("%amount%", 10);
        ModelMessage mm2 = (ModelMessage)((StringTemplate)((StringTemplate)new ModelMessage(ModelMessage.MessageType.WAREHOUSE_CAPACITY, "model.building.warehouseSoonFull", colony, cotton).addNamed("%goods%", cotton)).addName("%colony%", colony.getName())).addAmount("%amount%", 10);
        HashSet<ModelMessage> set = new HashSet<ModelMessage>();
        ModelMessageTest.assertEquals((Object)mm1, (Object)mm2);
        ModelMessageTest.assertEquals((int)mm1.hashCode(), (int)mm2.hashCode());
        set.add(mm1);
        ModelMessageTest.assertTrue((boolean)set.remove(mm2));
    }

    public void testDefaultId() {
        Game game = ModelMessageTest.getGame();
        game.changeMap(ModelMessageTest.getTestMap(true));
        Player player = game.getPlayerByNationId("model.nation.dutch");
        String realMessageId = "player";
        String fakeMessageId = "no.such.messageId";
        ModelMessage mm1 = new ModelMessage(ModelMessage.MessageType.WAREHOUSE_CAPACITY, fakeMessageId, realMessageId, player, null);
        ModelMessageTest.assertEquals((String)Messages.message(realMessageId), (String)Messages.message(mm1));
    }
}

