/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.action;

import ca.sqlpower.architect.swingui.ArchitectFrame;
import ca.sqlpower.architect.swingui.IndexEditPanel;
import ca.sqlpower.architect.swingui.TablePane;
import ca.sqlpower.architect.swingui.action.AbstractTableTargetedAction;
import ca.sqlpower.architect.swingui.action.InsertColumnAction;
import ca.sqlpower.architect.swingui.action.Messages;
import ca.sqlpower.sqlobject.SQLIndex;
import ca.sqlpower.sqlobject.SQLObject;
import ca.sqlpower.sqlobject.SQLObjectException;
import ca.sqlpower.sqlobject.SQLTable;
import ca.sqlpower.swingui.DataEntryPanel;
import ca.sqlpower.swingui.DataEntryPanelBuilder;
import java.awt.Component;
import javax.swing.JDialog;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class InsertIndexAction
extends AbstractTableTargetedAction {
    private static final Logger logger = Logger.getLogger(InsertColumnAction.class);

    public InsertIndexAction(ArchitectFrame frame) {
        super(frame, Messages.getString("InsertIndexAction.name"), Messages.getString("InsertIndexAction.description"), "new_index");
        this.putValue("ActionCommandKey", "PlayPen");
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(73, 0));
        this.setEnabled(false);
    }

    @Override
    public void disableAction() {
        this.setEnabled(false);
        logger.debug((Object)"Disabling New Index Action");
        this.putValue("ShortDescription", Messages.getString("InsertIndexAction.shortDescription"));
    }

    @Override
    void processSQLObject(SQLObject so) throws SQLObjectException {
        if (so instanceof SQLTable) {
            this.makeDialog((SQLTable)so);
        }
    }

    @Override
    void processTablePane(TablePane tp) throws SQLObjectException {
        this.makeDialog((SQLTable)tp.getModel());
    }

    private void makeDialog(SQLTable parent) throws SQLObjectException {
        SQLIndex index = new SQLIndex();
        IndexEditPanel editPanel = new IndexEditPanel(index, parent, this.getSession());
        JDialog d = DataEntryPanelBuilder.createDataEntryPanelDialog((DataEntryPanel)editPanel, (Component)this.frame, (String)Messages.getString("InsertIndexAction.dialogTitle"), (String)Messages.getString("InsertIndexAction.okOption"));
        d.pack();
        d.setLocationRelativeTo(this.frame);
        d.setVisible(true);
    }
}

