/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.swingui.PlayPenComponent;
import ca.sqlpower.sqlobject.undo.PropertyChangeEdit;
import java.awt.Point;
import java.beans.PropertyChangeEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;

public class PlayPenComponentLocationEdit
extends AbstractUndoableEdit {
    private final Map<PlayPenComponent, Point> initialBounds = new HashMap<PlayPenComponent, Point>();
    private final Map<PlayPenComponent, Point> finalBounds = new HashMap<PlayPenComponent, Point>();

    @Override
    public boolean addEdit(UndoableEdit anEdit) {
        if (anEdit instanceof PropertyChangeEdit) {
            PropertyChangeEdit pce = (PropertyChangeEdit)anEdit;
            PropertyChangeEvent evt = new PropertyChangeEvent(pce.getSource(), pce.getPropertyName(), pce.getOldValue(), pce.getNewValue());
            if (pce.getPropertyName().equals("topLeftCorner") && pce.getSource() instanceof PlayPenComponent) {
                PlayPenComponent ppc = (PlayPenComponent)pce.getSource();
                if (!this.initialBounds.containsKey(pce.getSource())) {
                    this.initialBounds.put(ppc, new Point((Point)pce.getOldValue()));
                }
                this.finalBounds.put(ppc, new Point((Point)pce.getNewValue()));
                anEdit.die();
                return true;
            }
        }
        return false;
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        for (Map.Entry<PlayPenComponent, Point> entry : this.initialBounds.entrySet()) {
            entry.getKey().setTopLeftCorner(entry.getValue());
        }
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        for (Map.Entry<PlayPenComponent, Point> entry : this.finalBounds.entrySet()) {
            entry.getKey().setTopLeftCorner(entry.getValue());
        }
    }

    @Override
    public String getUndoPresentationName() {
        return "Undo moving " + this.initialBounds.size() + " objects";
    }

    @Override
    public String getRedoPresentationName() {
        return "Redo moving " + this.finalBounds.size() + " objects";
    }

    @Override
    public boolean isSignificant() {
        return this.finalBounds.size() > 0;
    }
}

