/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.update;

import java.util.List;
import java.util.Map;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Counter;
import org.pentaho.di.core.SQLStatement;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.shared.SharedObjectInterface;
import org.pentaho.di.trans.DatabaseImpact;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.update.Messages;
import org.pentaho.di.trans.steps.update.Update;
import org.pentaho.di.trans.steps.update.UpdateData;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateMeta
extends BaseStepMeta
implements StepMetaInterface {
    private String schemaName;
    private String tableName;
    private DatabaseMeta databaseMeta;
    private String[] keyStream;
    private String[] keyLookup;
    private String[] keyCondition;
    private String[] keyStream2;
    private String[] updateLookup;
    private String[] updateStream;
    private int commitSize;
    private boolean errorIgnored;
    private String ignoreFlagField;
    private boolean skipLookup;

    public int getCommitSize() {
        return this.commitSize;
    }

    public void setCommitSize(int commitSize) {
        this.commitSize = commitSize;
    }

    public boolean isSkipLookup() {
        return this.skipLookup;
    }

    public void setSkipLookup(boolean skipLookup) {
        this.skipLookup = skipLookup;
    }

    public DatabaseMeta getDatabaseMeta() {
        return this.databaseMeta;
    }

    public void setDatabaseMeta(DatabaseMeta database) {
        this.databaseMeta = database;
    }

    public String[] getKeyCondition() {
        return this.keyCondition;
    }

    public void setKeyCondition(String[] keyCondition) {
        this.keyCondition = keyCondition;
    }

    public String[] getKeyLookup() {
        return this.keyLookup;
    }

    public void setKeyLookup(String[] keyLookup) {
        this.keyLookup = keyLookup;
    }

    public String[] getKeyStream() {
        return this.keyStream;
    }

    public void setKeyStream(String[] keyStream) {
        this.keyStream = keyStream;
    }

    public String[] getKeyStream2() {
        return this.keyStream2;
    }

    public void setKeyStream2(String[] keyStream2) {
        this.keyStream2 = keyStream2;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String[] getUpdateLookup() {
        return this.updateLookup;
    }

    public void setUpdateLookup(String[] updateLookup) {
        this.updateLookup = updateLookup;
    }

    public String[] getUpdateStream() {
        return this.updateStream;
    }

    public void setUpdateStream(String[] updateStream) {
        this.updateStream = updateStream;
    }

    public boolean isErrorIgnored() {
        return this.errorIgnored;
    }

    public void setErrorIgnored(boolean ignoreError) {
        this.errorIgnored = ignoreError;
    }

    public String getIgnoreFlagField() {
        return this.ignoreFlagField;
    }

    public void setIgnoreFlagField(String ignoreFlagField) {
        this.ignoreFlagField = ignoreFlagField;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleXMLException {
        this.readData(stepnode, databases);
    }

    public void allocate(int nrkeys, int nrvalues) {
        this.keyStream = new String[nrkeys];
        this.keyLookup = new String[nrkeys];
        this.keyCondition = new String[nrkeys];
        this.keyStream2 = new String[nrkeys];
        this.updateLookup = new String[nrvalues];
        this.updateStream = new String[nrvalues];
    }

    @Override
    public Object clone() {
        int i;
        UpdateMeta retval = (UpdateMeta)super.clone();
        int nrkeys = this.keyStream.length;
        int nrvalues = this.updateLookup.length;
        retval.allocate(nrkeys, nrvalues);
        for (i = 0; i < nrkeys; ++i) {
            retval.keyStream[i] = this.keyStream[i];
            retval.keyLookup[i] = this.keyLookup[i];
            retval.keyCondition[i] = this.keyCondition[i];
            retval.keyStream2[i] = this.keyStream2[i];
        }
        for (i = 0; i < nrvalues; ++i) {
            retval.updateLookup[i] = this.updateLookup[i];
            retval.updateStream[i] = this.updateStream[i];
        }
        return retval;
    }

    private void readData(Node stepnode, List<? extends SharedObjectInterface> databases) throws KettleXMLException {
        try {
            int i;
            String con = XMLHandler.getTagValue((Node)stepnode, (String)"connection");
            this.databaseMeta = DatabaseMeta.findDatabase(databases, (String)con);
            String csize = XMLHandler.getTagValue((Node)stepnode, (String)"commit");
            this.commitSize = Const.toInt((String)csize, (int)0);
            this.skipLookup = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"skip_lookup"));
            this.errorIgnored = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"error_ignored"));
            this.ignoreFlagField = XMLHandler.getTagValue((Node)stepnode, (String)"ignore_flag_field");
            this.schemaName = XMLHandler.getTagValue((Node)stepnode, (String)"lookup", (String)"schema");
            this.tableName = XMLHandler.getTagValue((Node)stepnode, (String)"lookup", (String)"table");
            Node lookup = XMLHandler.getSubNode((Node)stepnode, (String)"lookup");
            int nrkeys = XMLHandler.countNodes((Node)lookup, (String)"key");
            int nrvalues = XMLHandler.countNodes((Node)lookup, (String)"value");
            this.allocate(nrkeys, nrvalues);
            for (i = 0; i < nrkeys; ++i) {
                Node knode = XMLHandler.getSubNodeByNr((Node)lookup, (String)"key", (int)i);
                this.keyStream[i] = XMLHandler.getTagValue((Node)knode, (String)"name");
                this.keyLookup[i] = XMLHandler.getTagValue((Node)knode, (String)"field");
                this.keyCondition[i] = XMLHandler.getTagValue((Node)knode, (String)"condition");
                if (this.keyCondition[i] == null) {
                    this.keyCondition[i] = "=";
                }
                this.keyStream2[i] = XMLHandler.getTagValue((Node)knode, (String)"name2");
            }
            for (i = 0; i < nrvalues; ++i) {
                Node vnode = XMLHandler.getSubNodeByNr((Node)lookup, (String)"value", (int)i);
                this.updateLookup[i] = XMLHandler.getTagValue((Node)vnode, (String)"name");
                this.updateStream[i] = XMLHandler.getTagValue((Node)vnode, (String)"rename");
                if (this.updateStream[i] != null) continue;
                this.updateStream[i] = this.updateLookup[i];
            }
        }
        catch (Exception e) {
            throw new KettleXMLException(Messages.getString("UpdateMeta.Exception.UnableToReadStepInfoFromXML"), (Throwable)e);
        }
    }

    @Override
    public void setDefault() {
        int i;
        this.skipLookup = false;
        this.keyStream = null;
        this.updateLookup = null;
        this.databaseMeta = null;
        this.commitSize = 100;
        this.schemaName = "";
        this.tableName = Messages.getString("UpdateMeta.DefaultTableName");
        int nrkeys = 0;
        int nrvalues = 0;
        this.allocate(nrkeys, nrvalues);
        for (i = 0; i < nrkeys; ++i) {
            this.keyLookup[i] = "age";
            this.keyCondition[i] = "BETWEEN";
            this.keyStream[i] = "age_from";
            this.keyStream2[i] = "age_to";
        }
        for (i = 0; i < nrvalues; ++i) {
            this.updateLookup[i] = Messages.getString("UpdateMeta.ColumnName.ReturnField") + i;
            this.updateStream[i] = Messages.getString("UpdateMeta.ColumnName.NewName") + i;
        }
    }

    @Override
    public String getXML() {
        int i;
        StringBuffer retval = new StringBuffer();
        retval.append("    " + XMLHandler.addTagValue((String)"connection", (String)(this.databaseMeta == null ? "" : this.databaseMeta.getName())));
        retval.append("    " + XMLHandler.addTagValue((String)"skip_lookup", (boolean)this.skipLookup));
        retval.append("    " + XMLHandler.addTagValue((String)"commit", (int)this.commitSize));
        retval.append("    " + XMLHandler.addTagValue((String)"error_ignored", (boolean)this.errorIgnored));
        retval.append("    " + XMLHandler.addTagValue((String)"ignore_flag_field", (String)this.ignoreFlagField));
        retval.append("    <lookup>" + Const.CR);
        retval.append("      " + XMLHandler.addTagValue((String)"schema", (String)this.schemaName));
        retval.append("      " + XMLHandler.addTagValue((String)"table", (String)this.tableName));
        for (i = 0; i < this.keyStream.length; ++i) {
            retval.append("      <key>" + Const.CR);
            retval.append("        " + XMLHandler.addTagValue((String)"name", (String)this.keyStream[i]));
            retval.append("        " + XMLHandler.addTagValue((String)"field", (String)this.keyLookup[i]));
            retval.append("        " + XMLHandler.addTagValue((String)"condition", (String)this.keyCondition[i]));
            retval.append("        " + XMLHandler.addTagValue((String)"name2", (String)this.keyStream2[i]));
            retval.append("        </key>" + Const.CR);
        }
        for (i = 0; i < this.updateLookup.length; ++i) {
            retval.append("      <value>" + Const.CR);
            retval.append("        " + XMLHandler.addTagValue((String)"name", (String)this.updateLookup[i]));
            retval.append("        " + XMLHandler.addTagValue((String)"rename", (String)this.updateStream[i]));
            retval.append("        </value>" + Const.CR);
        }
        retval.append("      </lookup>" + Const.CR);
        return retval.toString();
    }

    @Override
    public void readRep(Repository rep, long id_step, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleException {
        try {
            int i;
            long id_connection = rep.getStepAttributeInteger(id_step, "id_connection");
            this.databaseMeta = DatabaseMeta.findDatabase(databases, (long)id_connection);
            this.skipLookup = rep.getStepAttributeBoolean(id_step, "skip_lookup");
            this.commitSize = (int)rep.getStepAttributeInteger(id_step, "commit");
            this.schemaName = rep.getStepAttributeString(id_step, "schema");
            this.tableName = rep.getStepAttributeString(id_step, "table");
            this.errorIgnored = rep.getStepAttributeBoolean(id_step, "error_ignored");
            this.ignoreFlagField = rep.getStepAttributeString(id_step, "ignore_flag_field");
            int nrkeys = rep.countNrStepAttributes(id_step, "key_name");
            int nrvalues = rep.countNrStepAttributes(id_step, "value_name");
            this.allocate(nrkeys, nrvalues);
            for (i = 0; i < nrkeys; ++i) {
                this.keyStream[i] = rep.getStepAttributeString(id_step, i, "key_name");
                this.keyLookup[i] = rep.getStepAttributeString(id_step, i, "key_field");
                this.keyCondition[i] = rep.getStepAttributeString(id_step, i, "key_condition");
                this.keyStream2[i] = rep.getStepAttributeString(id_step, i, "key_name2");
            }
            for (i = 0; i < nrvalues; ++i) {
                this.updateLookup[i] = rep.getStepAttributeString(id_step, i, "value_name");
                this.updateStream[i] = rep.getStepAttributeString(id_step, i, "value_rename");
            }
        }
        catch (Exception e) {
            throw new KettleException(Messages.getString("UpdateMeta.Exception.UnexpectedErrorReadingStepInfoFromRepository"), (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_transformation, long id_step) throws KettleException {
        try {
            int i;
            rep.saveStepAttribute(id_transformation, id_step, "id_connection", this.databaseMeta == null ? -1.0 : (double)this.databaseMeta.getID());
            rep.saveStepAttribute(id_transformation, id_step, "skip_lookup", this.skipLookup);
            rep.saveStepAttribute(id_transformation, id_step, "commit", this.commitSize);
            rep.saveStepAttribute(id_transformation, id_step, "schema", this.schemaName);
            rep.saveStepAttribute(id_transformation, id_step, "table", this.tableName);
            rep.saveStepAttribute(id_transformation, id_step, "error_ignored", this.errorIgnored);
            rep.saveStepAttribute(id_transformation, id_step, "ignore_flag_field", this.ignoreFlagField);
            for (i = 0; i < this.keyStream.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "key_name", this.keyStream[i]);
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "key_field", this.keyLookup[i]);
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "key_condition", this.keyCondition[i]);
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "key_name2", this.keyStream2[i]);
            }
            for (i = 0; i < this.updateLookup.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "value_name", this.updateLookup[i]);
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "value_rename", this.updateStream[i]);
            }
            if (this.databaseMeta != null) {
                rep.insertStepDatabase(id_transformation, id_step, this.databaseMeta.getID());
            }
        }
        catch (Exception e) {
            throw new KettleException(Messages.getString("UpdateMeta.Exception.UnableToSaveStepInfoToRepository") + id_step, (Throwable)e);
        }
    }

    @Override
    public void getFields(RowMetaInterface row, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space) throws KettleStepException {
        if (this.ignoreFlagField != null && this.ignoreFlagField.length() > 0) {
            ValueMeta v = new ValueMeta(this.ignoreFlagField, 4);
            v.setOrigin(name);
            row.addValueMeta((ValueMetaInterface)v);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepinfo, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info) {
        CheckResult cr;
        block23: {
            String error_message = "";
            if (this.databaseMeta != null) {
                Database db = new Database(this.databaseMeta);
                db.shareVariablesWith((VariableSpace)transMeta);
                try {
                    try {
                        boolean error_found;
                        boolean first;
                        db.connect();
                        if (!Const.isEmpty((String)this.tableName)) {
                            cr = new CheckResult(1, Messages.getString("UpdateMeta.CheckResult.TableNameOK"), (CheckResultSourceInterface)stepinfo);
                            remarks.add((CheckResultInterface)cr);
                            first = true;
                            error_found = false;
                            error_message = "";
                            String schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(this.schemaName, this.tableName);
                            RowMetaInterface r = db.getTableFields(schemaTable);
                            if (r != null) {
                                ValueMetaInterface v;
                                String lufield;
                                int i;
                                cr = new CheckResult(1, Messages.getString("UpdateMeta.CheckResult.TableExists"), (CheckResultSourceInterface)stepinfo);
                                remarks.add((CheckResultInterface)cr);
                                for (i = 0; i < this.keyLookup.length; ++i) {
                                    lufield = this.keyLookup[i];
                                    v = r.searchValueMeta(lufield);
                                    if (v != null) continue;
                                    if (first) {
                                        first = false;
                                        error_message = error_message + Messages.getString("UpdateMeta.CheckResult.MissingCompareFieldsInTargetTable") + Const.CR;
                                    }
                                    error_found = true;
                                    error_message = error_message + "\t\t" + lufield + Const.CR;
                                }
                                cr = error_found ? new CheckResult(4, error_message, (CheckResultSourceInterface)stepinfo) : new CheckResult(1, Messages.getString("UpdateMeta.CheckResult.AllLookupFieldsFound"), (CheckResultSourceInterface)stepinfo);
                                remarks.add((CheckResultInterface)cr);
                                first = true;
                                error_found = false;
                                error_message = "";
                                for (i = 0; i < this.updateLookup.length; ++i) {
                                    lufield = this.updateLookup[i];
                                    v = r.searchValueMeta(lufield);
                                    if (v != null) continue;
                                    if (first) {
                                        first = false;
                                        error_message = error_message + Messages.getString("UpdateMeta.CheckResult.MissingFieldsToUpdateInTargetTable") + Const.CR;
                                    }
                                    error_found = true;
                                    error_message = error_message + "\t\t" + lufield + Const.CR;
                                }
                                cr = error_found ? new CheckResult(4, error_message, (CheckResultSourceInterface)stepinfo) : new CheckResult(1, Messages.getString("UpdateMeta.CheckResult.AllFieldsToUpdateFoundInTargetTable"), (CheckResultSourceInterface)stepinfo);
                                remarks.add((CheckResultInterface)cr);
                            } else {
                                error_message = Messages.getString("UpdateMeta.CheckResult.CouldNotReadTableInfo");
                                cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepinfo);
                                remarks.add((CheckResultInterface)cr);
                            }
                        }
                        if (prev != null && prev.size() > 0) {
                            ValueMetaInterface v;
                            int i;
                            cr = new CheckResult(1, Messages.getString("UpdateMeta.CheckResult.StepReceivingDatas", prev.size() + ""), (CheckResultSourceInterface)stepinfo);
                            remarks.add((CheckResultInterface)cr);
                            first = true;
                            error_message = "";
                            error_found = false;
                            for (i = 0; i < this.keyStream.length; ++i) {
                                v = prev.searchValueMeta(this.keyStream[i]);
                                if (v != null) continue;
                                if (first) {
                                    first = false;
                                    error_message = error_message + Messages.getString("UpdateMeta.CheckResult.MissingFieldsInInput") + Const.CR;
                                }
                                error_found = true;
                                error_message = error_message + "\t\t" + this.keyStream[i] + Const.CR;
                            }
                            for (i = 0; i < this.keyStream2.length; ++i) {
                                if (this.keyStream2[i] == null || this.keyStream2[i].length() <= 0 || (v = prev.searchValueMeta(this.keyStream2[i])) != null) continue;
                                if (first) {
                                    first = false;
                                    error_message = error_message + Messages.getString("UpdateMeta.CheckResult.MissingFieldsInInput2") + Const.CR;
                                }
                                error_found = true;
                                error_message = error_message + "\t\t" + this.keyStream[i] + Const.CR;
                            }
                            cr = error_found ? new CheckResult(4, error_message, (CheckResultSourceInterface)stepinfo) : new CheckResult(1, Messages.getString("UpdateMeta.CheckResult.AllFieldsFoundInInput"), (CheckResultSourceInterface)stepinfo);
                            remarks.add((CheckResultInterface)cr);
                            first = true;
                            error_found = false;
                            error_message = "";
                            for (i = 0; i < this.updateStream.length; ++i) {
                                String lufield = this.updateStream[i];
                                ValueMetaInterface v2 = prev.searchValueMeta(lufield);
                                if (v2 != null) continue;
                                if (first) {
                                    first = false;
                                    error_message = error_message + Messages.getString("UpdateMeta.CheckResult.MissingInputStreamFields") + Const.CR;
                                }
                                error_found = true;
                                error_message = error_message + "\t\t" + lufield + Const.CR;
                            }
                            cr = error_found ? new CheckResult(4, error_message, (CheckResultSourceInterface)stepinfo) : new CheckResult(1, Messages.getString("UpdateMeta.CheckResult.AllFieldsFoundInInput2"), (CheckResultSourceInterface)stepinfo);
                            remarks.add((CheckResultInterface)cr);
                        } else {
                            error_message = Messages.getString("UpdateMeta.CheckResult.MissingFieldsInInput3") + Const.CR;
                            cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepinfo);
                            remarks.add((CheckResultInterface)cr);
                        }
                    }
                    catch (KettleException e) {
                        error_message = Messages.getString("UpdateMeta.CheckResult.DatabaseErrorOccurred") + e.getMessage();
                        cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepinfo);
                        remarks.add((CheckResultInterface)cr);
                        Object var19_22 = null;
                        db.disconnect();
                        break block23;
                    }
                    Object var19_21 = null;
                }
                catch (Throwable throwable) {
                    Object var19_23 = null;
                    db.disconnect();
                    throw throwable;
                }
                db.disconnect();
            } else {
                error_message = Messages.getString("UpdateMeta.CheckResult.InvalidConnection");
                cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepinfo);
                remarks.add((CheckResultInterface)cr);
            }
        }
        if (input.length > 0) {
            cr = new CheckResult(1, Messages.getString("UpdateMeta.CheckResult.StepReceivingInfoFromOtherSteps"), (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
            return;
        }
        cr = new CheckResult(4, Messages.getString("UpdateMeta.CheckResult.NoInputError"), (CheckResultSourceInterface)stepinfo);
        remarks.add((CheckResultInterface)cr);
    }

    @Override
    public SQLStatement getSQLStatements(TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev) {
        SQLStatement retval;
        block14: {
            retval = new SQLStatement(stepMeta.getName(), this.databaseMeta, null);
            if (this.databaseMeta != null) {
                if (prev != null && prev.size() > 0) {
                    if (!Const.isEmpty((String)this.tableName)) {
                        String schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(this.schemaName, this.tableName);
                        Database db = new Database(this.databaseMeta);
                        db.shareVariablesWith((VariableSpace)transMeta);
                        try {
                            String sql;
                            db.connect();
                            if (this.getIgnoreFlagField() != null && this.getIgnoreFlagField().length() > 0) {
                                prev.addValueMeta((ValueMetaInterface)new ValueMeta(this.getIgnoreFlagField(), 4));
                            }
                            String cr_table = db.getDDL(schemaTable, prev, null, false, null, true);
                            String cr_index = "";
                            String[] idx_fields = null;
                            if (this.keyLookup != null && this.keyLookup.length > 0) {
                                idx_fields = new String[this.keyLookup.length];
                                for (int i = 0; i < this.keyLookup.length; ++i) {
                                    idx_fields[i] = this.keyLookup[i];
                                }
                            } else {
                                retval.setError(Messages.getString("UpdateMeta.CheckResult.MissingKeyFields"));
                            }
                            if (idx_fields != null && idx_fields.length > 0 && !db.checkIndexExists(this.schemaName, this.tableName, idx_fields)) {
                                String indexname = "idx_" + this.tableName + "_lookup";
                                cr_index = db.getCreateIndexStatement(this.schemaName, this.tableName, indexname, idx_fields, false, false, false, true);
                            }
                            if ((sql = cr_table + cr_index).length() == 0) {
                                retval.setSQL(null);
                                break block14;
                            }
                            retval.setSQL(sql);
                        }
                        catch (KettleException e) {
                            retval.setError(Messages.getString("UpdateMeta.ReturnValue.ErrorOccurred") + e.getMessage());
                        }
                    } else {
                        retval.setError(Messages.getString("UpdateMeta.ReturnValue.NoTableDefinedOnConnection"));
                    }
                } else {
                    retval.setError(Messages.getString("UpdateMeta.ReturnValue.NotReceivingAnyFields"));
                }
            } else {
                retval.setError(Messages.getString("UpdateMeta.ReturnValue.NoConnectionDefined"));
            }
        }
        return retval;
    }

    @Override
    public void analyseImpact(List<DatabaseImpact> impact, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info) throws KettleStepException {
        if (prev != null) {
            DatabaseImpact ii;
            ValueMetaInterface v;
            int i;
            for (i = 0; i < this.keyLookup.length; ++i) {
                v = prev.searchValueMeta(this.keyStream[i]);
                ii = new DatabaseImpact(1, transMeta.getName(), stepMeta.getName(), this.databaseMeta.getDatabaseName(), this.tableName, this.keyLookup[i], this.keyStream[i], v != null ? v.getOrigin() : "?", "", "Type = " + v.toStringMeta());
                impact.add(ii);
            }
            for (i = 0; i < this.updateLookup.length; ++i) {
                v = prev.searchValueMeta(this.updateStream[i]);
                ii = new DatabaseImpact(6, transMeta.getName(), stepMeta.getName(), this.databaseMeta.getDatabaseName(), this.tableName, this.updateLookup[i], this.updateStream[i], v != null ? v.getOrigin() : "?", "", "Type = " + v.toStringMeta());
                impact.add(ii);
            }
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta tr, Trans trans) {
        return new Update(stepMeta, stepDataInterface, cnr, tr, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new UpdateData();
    }

    @Override
    public DatabaseMeta[] getUsedDatabaseConnections() {
        if (this.databaseMeta != null) {
            return new DatabaseMeta[]{this.databaseMeta};
        }
        return super.getUsedDatabaseConnections();
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    @Override
    public boolean supportsErrorHandling() {
        return true;
    }
}

