/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.transform;

import dotty.tools.dotc.ast.Trees;
import dotty.tools.dotc.ast.tpd$;
import dotty.tools.dotc.core.Contexts;
import dotty.tools.dotc.core.Decorators$;
import dotty.tools.dotc.core.Flags$;
import dotty.tools.dotc.core.Symbols;
import dotty.tools.dotc.core.Symbols$;
import dotty.tools.dotc.core.Types;
import dotty.tools.dotc.inlines.Inlines$;
import dotty.tools.dotc.printing.Formatting$ShownDef$Show$;
import dotty.tools.dotc.printing.Formatting$ShownDef$Shown$;
import dotty.tools.dotc.report$;
import dotty.tools.dotc.transform.InlineVals$;
import dotty.tools.dotc.transform.MegaPhase;
import dotty.tools.dotc.util.Spans$Span$;
import dotty.tools.dotc.util.SrcPos;
import java.io.Serializable;
import scala.Function1;
import scala.StringContext$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.runtime.ScalaRunTime$;

public class InlineVals
extends MegaPhase.MiniPhase {
    public static String name() {
        return InlineVals$.MODULE$.name();
    }

    @Override
    public String phaseName() {
        return InlineVals$.MODULE$.name();
    }

    @Override
    public String description() {
        return InlineVals$.MODULE$.description();
    }

    @Override
    public void checkPostCondition(Trees.Tree<Types.Type> tree, Contexts.Context x$2) {
        if (!x$2.erasedTypes()) {
            Trees.Tree<Types.Type> tree2 = tree;
            if (tree2 instanceof Trees.ValDef) {
                Trees.ValDef valDef;
                Trees.ValDef tree3 = valDef = (Trees.ValDef)tree2;
                this.checkInlineConformant(tree3, x$2);
                return;
            }
            return;
        }
    }

    @Override
    public Trees.Tree<Types.Type> transformValDef(Trees.ValDef<Types.Type> tree, Contexts.Context x$2) {
        this.checkInlineConformant(tree, x$2);
        return tree;
    }

    private void checkInlineConformant(Trees.ValDef<Types.Type> tree, Contexts.Context x$2) {
        if (Symbols$.MODULE$.toDenot(tree.symbol(x$2), x$2).is(Flags$.MODULE$.Inline(), Flags$.MODULE$.DeferredOrTermParamOrAccessor(), x$2) && !Inlines$.MODULE$.inInlineMethod(x$2)) {
            Trees.Tree<Types.Type> rhs = tree.rhs(x$2);
            Trees.Tree<Types.Type> tpt = tree.tpt();
            Types.Type type = tpt.tpe().widenTermRefExpr(x$2).dealiasKeepOpaques(x$2).normalized(x$2);
            if (type instanceof Types.ConstantType) {
                Types.ConstantType constantType;
                Types.ConstantType tp = constantType = (Types.ConstantType)type;
                if (!tpd$.MODULE$.isPureExpr((Trees.Tree)rhs, x$2)) {
                    report$.MODULE$.error(Decorators$.MODULE$.em(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"inline value must be pure", ""})), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{Formatting$ShownDef$Shown$.MODULE$.given_Conversion_A_Shown(Formatting$ShownDef$Show$.MODULE$.given_Show_String()).apply((Object)InlineVals.details$1(x$2, rhs))}), x$2), rhs.srcPos(), x$2);
                    return;
                }
                return;
            }
            Types.Type tp = type;
            if (Symbols$.MODULE$.toDenot(tp.typeSymbol(x$2), x$2).is(Flags$.MODULE$.Opaque(), x$2)) {
                report$.MODULE$.error(Decorators$.MODULE$.em(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"The type of an `inline val` cannot be an opaque type.\\n\\nTo inline, consider using `inline def` instead"})), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]), x$2), rhs, x$2);
                return;
            }
            if (tp.derivesFrom(Symbols$.MODULE$.defn(x$2).UnitClass(x$2), x$2)) {
                report$.MODULE$.error(Decorators$.MODULE$.em(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"`inline val` of type `Unit` is not supported.\\n\\nTo inline a `Unit` consider using `inline def`"})), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]), x$2), rhs, x$2);
                return;
            }
            if (tp.derivesFrom(Symbols$.MODULE$.defn(x$2).StringClass(), x$2) || ((IterableOnceOps)Symbols$.MODULE$.defn(x$2).ScalaValueClasses().apply(x$2)).exists((Function1 & Serializable)_$1 -> tp.derivesFrom((Symbols.Symbol)_$1, x$2))) {
                SrcPos pos = Spans$Span$.MODULE$.isZeroExtent$extension(tpt.span()) ? rhs.srcPos() : tpt.srcPos();
                report$.MODULE$.error(Decorators$.MODULE$.em(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"inline value must have a literal constant type"})), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]), x$2), pos, x$2);
                return;
            }
            if (tp.derivesFrom(Symbols$.MODULE$.defn(x$2).NullClass(), x$2)) {
                report$.MODULE$.error(Decorators$.MODULE$.em(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"`inline val` with `null` is not supported.\\n\\nTo inline a `null` consider using `inline def`"})), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]), x$2), rhs, x$2);
                return;
            }
            report$.MODULE$.error(Decorators$.MODULE$.em(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"inline value must contain a literal constant value.\\n\\nTo inline more complex types consider using `inline def`"})), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]), x$2), rhs, x$2);
            return;
        }
    }

    private static final String details$1(Contexts.Context x$2$1, Trees.Tree rhs$1) {
        if (tpd$.MODULE$.enclosingInlineds(x$2$1).nonEmpty() || rhs$1 instanceof Trees.Inlined) {
            return Decorators$.MODULE$.i(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{" but was: ", ""})), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{Formatting$ShownDef$Shown$.MODULE$.given_Conversion_A_Shown(Formatting$ShownDef$Show$.MODULE$.given_Show_Showable()).apply((Object)rhs$1)}), x$2$1);
        }
        return "";
    }
}

