/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.config;

import java.net.InetSocketAddress;
import javax.crypto.SecretKey;
import org.eclipse.californium.scandium.util.SecretUtil;

public final class DtlsClusterConnectorConfig {
    private InetSocketAddress address;
    private String identity;
    private SecretKey secret;
    private Boolean clusterMac;
    private Boolean backwardMessages;

    public InetSocketAddress getAddress() {
        return this.address;
    }

    public String getSecureIdentity() {
        return this.identity;
    }

    public SecretKey getSecretKey() {
        return SecretUtil.create(this.secret);
    }

    public boolean useClusterMac() {
        return this.clusterMac;
    }

    public boolean useBackwardMessages() {
        return this.backwardMessages;
    }

    protected Object clone() {
        DtlsClusterConnectorConfig cloned = new DtlsClusterConnectorConfig();
        cloned.address = this.address;
        cloned.identity = this.identity;
        cloned.secret = SecretUtil.create(this.secret);
        cloned.clusterMac = this.clusterMac;
        cloned.backwardMessages = this.backwardMessages;
        return cloned;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(DtlsClusterConnectorConfig config) {
        return new Builder(config);
    }

    public static final class Builder {
        private DtlsClusterConnectorConfig config;

        public Builder() {
            this.config = new DtlsClusterConnectorConfig();
        }

        public Builder(DtlsClusterConnectorConfig initialConfiguration) {
            this.config = (DtlsClusterConnectorConfig)initialConfiguration.clone();
        }

        public Builder setAddress(InetSocketAddress address) {
            this.config.address = address;
            return this;
        }

        public Builder setSecure(String identity, SecretKey secret) {
            if (identity == null && secret != null) {
                throw new IllegalArgumentException("No identity but secret!");
            }
            if (identity != null && secret == null) {
                throw new IllegalArgumentException("No secret but identity!");
            }
            if (this.config.secret != null) {
                SecretUtil.destroy(this.config.secret);
            }
            this.config.identity = identity;
            this.config.secret = SecretUtil.create(secret);
            return this;
        }

        public Builder setClusterMac(Boolean enable) {
            this.config.clusterMac = enable;
            return this;
        }

        public Builder setBackwardMessage(Boolean enable) {
            this.config.backwardMessages = enable;
            return this;
        }

        public DtlsClusterConnectorConfig getIncompleteConfig() {
            return this.config;
        }

        public DtlsClusterConnectorConfig build() {
            if (this.config.address == null) {
                throw new IllegalStateException("Local cluster socker address missing!");
            }
            if (this.config.clusterMac == Boolean.TRUE && this.config.identity == null) {
                throw new IllegalStateException("MAC for cluster traffic requires enabled encryption!");
            }
            if (this.config.backwardMessages == null) {
                this.config.backwardMessages = Boolean.TRUE;
            }
            if (this.config.clusterMac == null) {
                this.config.clusterMac = this.config.identity != null;
            }
            return this.config;
        }
    }
}

