/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.util;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.derby.iapi.services.context.Context;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.shared.common.error.ShutdownException;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

public class InterruptStatus {
    public static final int MAX_INTERRUPT_RETRIES = 120;
    public static final int INTERRUPT_RETRY_SLEEP = 500;
    private static final ThreadLocal<Exception> exception = new ThreadLocal();

    public static void setInterrupted() {
        LanguageConnectionContext lcc = null;
        try {
            lcc = (LanguageConnectionContext)InterruptStatus.getContextOrNull("LanguageConnectionContext");
        }
        catch (ShutdownException shutdownException) {
            // empty catch block
        }
        Thread.interrupted();
        StandardException e = StandardException.newException((String)"08000", (Object[])new Object[0]);
        if (lcc != null) {
            lcc.setInterruptedException(e);
        } else {
            exception.set((Exception)((Object)e));
        }
    }

    public static void saveInfoFromLcc(LanguageConnectionContext lcc) {
        StandardException e = lcc.getInterruptedException();
        if (e != null) {
            exception.set((Exception)((Object)e));
        }
    }

    public static boolean noteAndClearInterrupt(String s, int threadsInPageIO, int hashCode) {
        if (Thread.currentThread().isInterrupted()) {
            InterruptStatus.setInterrupted();
            if (SanityManager.DEBUG_ON((String)"DebugInterruptRecovery")) {
                SanityManager.DEBUG_PRINT((String)"DebugInterruptRecovery", (String)(Thread.currentThread().getName() + " " + Integer.toHexString(hashCode) + "@Interrupted: " + s + " threadsInPageIO: " + threadsInPageIO + "\n"));
            }
            Thread.interrupted();
            return true;
        }
        return false;
    }

    public static void restoreIntrFlagIfSeen() {
        LanguageConnectionContext lcc = null;
        try {
            lcc = (LanguageConnectionContext)InterruptStatus.getContextOrNull("LanguageConnectionContext");
        }
        catch (ShutdownException shutdownException) {
            // empty catch block
        }
        if (lcc == null) {
            if (exception.get() != null) {
                exception.set(null);
                Thread.currentThread().interrupt();
            }
        } else if (lcc.getInterruptedException() != null) {
            lcc.setInterruptedException(null);
            Thread.currentThread().interrupt();
        }
    }

    public static void restoreIntrFlagIfSeen(LanguageConnectionContext lcc) {
        LanguageConnectionContext ctxLcc = null;
        try {
            ctxLcc = (LanguageConnectionContext)InterruptStatus.getContextOrNull("LanguageConnectionContext");
            SanityManager.ASSERT((lcc == ctxLcc ? 1 : 0) != 0, (String)("lcc=" + String.valueOf(lcc) + " getContextOrNull=" + String.valueOf(ctxLcc)));
        }
        catch (ShutdownException shutdownException) {
            // empty catch block
        }
        if (lcc.getInterruptedException() != null) {
            lcc.setInterruptedException(null);
            Thread.currentThread().interrupt();
        }
    }

    public static void throwIf(LanguageConnectionContext lcc) throws StandardException {
        StandardException e;
        if (Thread.currentThread().isInterrupted()) {
            InterruptStatus.setInterrupted();
        }
        if ((e = lcc.getInterruptedException()) != null) {
            lcc.setInterruptedException(null);
            throw e;
        }
    }

    private static Context getContextOrNull(final String contextID) {
        if (System.getSecurityManager() == null) {
            return ContextService.getContextOrNull(contextID);
        }
        return AccessController.doPrivileged(new PrivilegedAction<Context>(){

            @Override
            public Context run() {
                return ContextService.getContextOrNull(contextID);
            }
        });
    }
}

