/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.spi;

import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.CollectionEntry;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.event.spi.AbstractEvent;
import org.hibernate.event.spi.EventSource;
import org.hibernate.persister.collection.CollectionPersister;

public abstract class AbstractCollectionEvent
extends AbstractEvent {
    private final PersistentCollection<?> collection;
    private final Object affectedOwner;
    private final Object affectedOwnerId;
    private final String affectedOwnerEntityName;

    public AbstractCollectionEvent(CollectionPersister collectionPersister, PersistentCollection<?> collection, EventSource source, Object affectedOwner, Object affectedOwnerId) {
        super(source);
        this.collection = collection;
        this.affectedOwner = affectedOwner;
        this.affectedOwnerId = affectedOwnerId;
        this.affectedOwnerEntityName = AbstractCollectionEvent.getAffectedOwnerEntityName(collectionPersister, affectedOwner, source);
    }

    protected static CollectionPersister getLoadedCollectionPersister(PersistentCollection<?> collection, EventSource source) {
        CollectionEntry ce = source.getPersistenceContextInternal().getCollectionEntry(collection);
        return ce == null ? null : ce.getLoadedPersister();
    }

    protected static Object getLoadedOwnerOrNull(PersistentCollection<?> collection, EventSource source) {
        return source.getPersistenceContextInternal().getLoadedCollectionOwnerOrNull(collection);
    }

    protected static Object getLoadedOwnerIdOrNull(PersistentCollection<?> collection, EventSource source) {
        return source.getPersistenceContextInternal().getLoadedCollectionOwnerIdOrNull(collection);
    }

    protected static Object getOwnerIdOrNull(Object owner, EventSource source) {
        EntityEntry ownerEntry = source.getPersistenceContextInternal().getEntry(owner);
        return ownerEntry == null ? null : ownerEntry.getId();
    }

    protected static String getAffectedOwnerEntityName(CollectionPersister collectionPersister, Object affectedOwner, EventSource source) {
        EntityEntry entry;
        if (affectedOwner != null && (entry = source.getPersistenceContextInternal().getEntry(affectedOwner)) != null && entry.getEntityName() != null) {
            return entry.getEntityName();
        }
        if (collectionPersister != null) {
            return collectionPersister.getOwnerEntityPersister().getEntityName();
        }
        return null;
    }

    public PersistentCollection<?> getCollection() {
        return this.collection;
    }

    public Object getAffectedOwnerOrNull() {
        return this.affectedOwner;
    }

    public Object getAffectedOwnerIdOrNull() {
        return this.affectedOwnerId;
    }

    public String getAffectedOwnerEntityName() {
        return this.affectedOwnerEntityName;
    }
}

