/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.util;

import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.LongAdder;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jitsi.nlj.util.UtilKt;
import org.jitsi.utils.OrderedJsonObject;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerImpl;
import org.jitsi.videobridge.util.PartitionedByteBufferPool;

public class ByteBufferPool {
    private static int T1 = 220;
    private static int T2 = 775;
    private static int T3 = 1500;
    private static final PartitionedByteBufferPool pool1 = new PartitionedByteBufferPool(T1);
    private static final PartitionedByteBufferPool pool2 = new PartitionedByteBufferPool(T2);
    private static final PartitionedByteBufferPool pool3 = new PartitionedByteBufferPool(T3);
    private static final Logger logger = new LoggerImpl(ByteBufferPool.class.getName());
    private static final Set<byte[]> outstandingBuffers = Collections.synchronizedSet(Collections.newSetFromMap(new IdentityHashMap()));
    private static final Set<byte[]> returnedBuffers = Collections.synchronizedSet(Collections.newSetFromMap(new IdentityHashMap()));
    private static final Map<byte[], Queue<BufferEvent>> bufferEvents = Collections.synchronizedMap(new IdentityHashMap());
    private static boolean enableStatistics = false;
    private static Boolean bookkeepingEnabled = false;
    private static final LongAdder numRequests = new LongAdder();
    private static final LongAdder numLargeRequests = new LongAdder();
    private static final LongAdder numReturns = new LongAdder();

    private static long threadId() {
        return Thread.currentThread().getId();
    }

    private static String stackTraceAsString(StackTraceElement[] stack) {
        StringBuilder sb = new StringBuilder();
        for (StackTraceElement ste : stack) {
            sb.append(ste.toString()).append("\n");
        }
        return sb.toString();
    }

    public static byte[] getBuffer(int size) {
        byte[] buf;
        if (enableStatistics) {
            numRequests.increment();
        }
        if (size <= T1) {
            buf = pool1.getBuffer(size);
        } else if (size <= T2) {
            buf = pool2.getBuffer(size);
        } else if (size <= T3) {
            buf = pool3.getBuffer(size);
        } else {
            buf = new byte[size];
            numLargeRequests.increment();
        }
        if (bookkeepingEnabled.booleanValue()) {
            Exception stackTrace = new Exception();
            outstandingBuffers.add(buf);
            returnedBuffers.remove(buf);
            bufferEvents.computeIfAbsent(buf, k -> new LinkedBlockingQueue()).add(new BufferEvent("allocation", System.currentTimeMillis(), stackTrace));
        }
        return buf;
    }

    public static void returnBuffer(@NotNull byte[] buf) {
        if (enableStatistics) {
            numReturns.increment();
        }
        int len = buf.length;
        if (bookkeepingEnabled.booleanValue()) {
            int arrayId = System.identityHashCode(buf);
            Exception stackTrace = new Exception();
            bufferEvents.computeIfAbsent(buf, k -> new LinkedBlockingQueue()).add(new BufferEvent("return", System.currentTimeMillis(), stackTrace));
            if (outstandingBuffers.remove(buf)) {
                returnedBuffers.add(buf);
            } else if (returnedBuffers.contains(buf)) {
                String bufferTimeline = bufferEvents.get(buf).stream().map(BufferEvent::toString).collect(Collectors.joining());
                logger.error("Thread " + ByteBufferPool.threadId() + " returned a previously-returned " + len + "-byte buffer " + arrayId + " its timeline:\n" + bufferTimeline);
            } else {
                logger.error("Thread " + ByteBufferPool.threadId() + " returned a " + len + "-byte buffer we didn't give out from\n" + ByteBufferPool.stackTraceAsString(stackTrace.getStackTrace()));
            }
        }
        if (len <= T1) {
            pool1.returnBuffer(buf);
        } else if (len <= T2) {
            pool2.returnBuffer(buf);
        } else if (len <= T3) {
            pool3.returnBuffer(buf);
        } else {
            logger.warn("Received a suspiciously large buffer (size = " + len + ")\n +" + UtilKt.getStackTrace());
        }
    }

    public static OrderedJsonObject getStatsJson() {
        OrderedJsonObject stats = new OrderedJsonObject();
        long numLargeRequestsSum = numLargeRequests.sum();
        stats.put("num_large_requests", (Object)numLargeRequestsSum);
        if (enableStatistics) {
            long numRequestsSum = numRequests.sum();
            long allAllocations = numLargeRequestsSum + pool1.getNumAllocations() + pool2.getNumAllocations() + pool3.getNumAllocations();
            long storedBytes = pool1.getStoredBytes() + pool2.getStoredBytes() + pool3.getStoredBytes();
            stats.put("num_requests", (Object)numRequestsSum);
            stats.put("num_returns", (Object)numReturns.sum());
            stats.put("num_allocations", (Object)allAllocations);
            stats.put("allocation_percent", (Object)(100.0 * (double)allAllocations / (double)numRequestsSum));
            stats.put("stored_bytes", (Object)storedBytes);
            stats.put("pool1", pool1.getStats());
            stats.put("pool2", pool2.getStats());
            stats.put("pool3", pool3.getStats());
        }
        if (bookkeepingEnabled.booleanValue()) {
            stats.put("outstanding_buffers", (Object)outstandingBuffers.size());
        }
        return stats;
    }

    public static void enableStatistics(boolean enable) {
        enableStatistics = enable;
        pool1.enableStatistics(enable);
        pool2.enableStatistics(enable);
        pool3.enableStatistics(enable);
    }

    public static boolean statisticsEnabled() {
        return enableStatistics;
    }

    public static void enableBookkeeping(boolean enable) {
        bookkeepingEnabled = enable;
        if (!enable) {
            outstandingBuffers.clear();
            returnedBuffers.clear();
            bufferEvents.clear();
        }
    }

    public static boolean bookkeepingEnabled() {
        return bookkeepingEnabled;
    }

    private static class BufferEvent {
        final String context;
        final Long timestamp;
        final Exception trace;
        public static final String ALLOCATION = "allocation";
        public static final String RETURN = "return";

        public BufferEvent(String context, Long timestamp, Exception trace) {
            this.context = context;
            this.timestamp = timestamp;
            this.trace = trace;
        }

        public String toString() {
            return this.context + " BufferEvent: timestamp=" + this.timestamp + "\n" + ByteBufferPool.stackTraceAsString(this.trace.getStackTrace());
        }
    }
}

