/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import org.hibernate.dialect.SqlAstTranslatorWithMerge;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.mapping.JdbcMappingContainer;
import org.hibernate.query.sqm.ComparisonOperator;
import org.hibernate.query.sqm.FetchClauseType;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.ast.tree.cte.CteMaterialization;
import org.hibernate.sql.ast.tree.cte.CteStatement;
import org.hibernate.sql.ast.tree.expression.BinaryArithmeticExpression;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.Literal;
import org.hibernate.sql.ast.tree.expression.Summarization;
import org.hibernate.sql.ast.tree.from.NamedTableReference;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.insert.ConflictClause;
import org.hibernate.sql.ast.tree.insert.InsertSelectStatement;
import org.hibernate.sql.ast.tree.predicate.BooleanExpressionPredicate;
import org.hibernate.sql.ast.tree.predicate.InArrayPredicate;
import org.hibernate.sql.ast.tree.predicate.LikePredicate;
import org.hibernate.sql.ast.tree.predicate.NullnessPredicate;
import org.hibernate.sql.ast.tree.select.QueryGroup;
import org.hibernate.sql.ast.tree.select.QueryPart;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.update.UpdateStatement;
import org.hibernate.sql.exec.internal.JdbcOperationQueryInsertImpl;
import org.hibernate.sql.exec.spi.JdbcOperation;
import org.hibernate.sql.exec.spi.JdbcOperationQueryInsert;
import org.hibernate.sql.model.internal.TableInsertStandard;

public class PostgreSQLSqlAstTranslator<T extends JdbcOperation>
extends SqlAstTranslatorWithMerge<T> {
    public PostgreSQLSqlAstTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
        super(sessionFactory, statement);
    }

    @Override
    public void visitInArrayPredicate(InArrayPredicate inArrayPredicate) {
        inArrayPredicate.getTestExpression().accept(this);
        this.appendSql(" = any (");
        inArrayPredicate.getArrayParameter().accept(this);
        this.appendSql(")");
    }

    @Override
    protected String getArrayContainsFunction() {
        return super.getArrayContainsFunction();
    }

    @Override
    protected void renderInsertIntoNoColumns(TableInsertStandard tableInsert) {
        this.renderIntoIntoAndTable(tableInsert);
        this.appendSql("default values");
    }

    @Override
    protected JdbcOperationQueryInsert translateInsert(InsertSelectStatement sqlAst) {
        this.visitInsertStatement(sqlAst);
        return new JdbcOperationQueryInsertImpl(this.getSql(), this.getParameterBinders(), this.getAffectedTableNames(), null);
    }

    @Override
    protected void renderTableReferenceIdentificationVariable(TableReference tableReference) {
        String identificationVariable = tableReference.getIdentificationVariable();
        if (identificationVariable != null) {
            Clause currentClause = this.getClauseStack().getCurrent();
            if (currentClause == Clause.INSERT) {
                this.appendSql(" as ");
            } else {
                this.append(' ');
            }
            this.append(tableReference.getIdentificationVariable());
        }
    }

    @Override
    protected void renderDmlTargetTableExpression(NamedTableReference tableReference) {
        super.renderDmlTargetTableExpression(tableReference);
        Statement currentStatement = this.getStatementStack().getCurrent();
        if (!(currentStatement instanceof UpdateStatement) || !PostgreSQLSqlAstTranslator.hasNonTrivialFromClause(((UpdateStatement)currentStatement).getFromClause())) {
            this.renderTableReferenceIdentificationVariable(tableReference);
        }
    }

    @Override
    protected void renderFromClauseAfterUpdateSet(UpdateStatement statement) {
        this.renderFromClauseJoiningDmlTargetReference(statement);
    }

    @Override
    protected void visitConflictClause(ConflictClause conflictClause) {
        this.visitStandardConflictClause(conflictClause);
    }

    @Override
    protected void renderExpressionAsClauseItem(Expression expression) {
        expression.accept(this);
    }

    @Override
    protected void renderComparison(Expression lhs, ComparisonOperator operator, Expression rhs) {
        JdbcMappingContainer lhsExpressionType = lhs.getExpressionType();
        if (lhsExpressionType != null && lhsExpressionType.getJdbcTypeCount() == 1 && lhsExpressionType.getSingleJdbcMapping().getJdbcType().getDdlTypeCode() == 2009) {
            switch (operator) {
                case EQUAL: 
                case NOT_DISTINCT_FROM: 
                case NOT_EQUAL: 
                case DISTINCT_FROM: {
                    this.appendSql("cast(");
                    lhs.accept(this);
                    this.appendSql(" as text)");
                    this.appendSql(operator.sqlText());
                    this.appendSql("cast(");
                    rhs.accept(this);
                    this.appendSql(" as text)");
                    return;
                }
            }
        }
        this.renderComparisonStandard(lhs, operator, rhs);
    }

    @Override
    public void visitBooleanExpressionPredicate(BooleanExpressionPredicate booleanExpressionPredicate) {
        boolean isNegated = booleanExpressionPredicate.isNegated();
        if (isNegated) {
            this.appendSql("not(");
        }
        booleanExpressionPredicate.getExpression().accept(this);
        if (isNegated) {
            this.appendSql(')');
        }
    }

    @Override
    public void visitNullnessPredicate(NullnessPredicate nullnessPredicate) {
        Expression expression = nullnessPredicate.getExpression();
        JdbcMappingContainer expressionType = expression.getExpressionType();
        if (this.isStruct(expressionType)) {
            expression.accept(this);
            if (nullnessPredicate.isNegated()) {
                this.appendSql(" is distinct from null");
            } else {
                this.appendSql(" is not distinct from null");
            }
        } else {
            super.visitNullnessPredicate(nullnessPredicate);
        }
    }

    @Override
    protected void renderMaterializationHint(CteMaterialization materialization) {
        if (materialization == CteMaterialization.NOT_MATERIALIZED) {
            this.appendSql("not ");
        }
        this.appendSql("materialized ");
    }

    @Override
    protected boolean supportsRowConstructor() {
        return true;
    }

    @Override
    protected boolean supportsArrayConstructor() {
        return true;
    }

    @Override
    public boolean supportsFilterClause() {
        return true;
    }

    @Override
    protected String getForUpdate() {
        return " for no key update";
    }

    @Override
    protected String getForShare(int timeoutMillis) {
        return " for share";
    }

    protected boolean shouldEmulateFetchClause(QueryPart queryPart) {
        if (this.getQueryPartForRowNumbering() == queryPart || this.isRowsOnlyFetchClauseType(queryPart)) {
            return false;
        }
        return !this.getDialect().supportsFetchClause(queryPart.getFetchClauseType());
    }

    @Override
    public void visitQueryGroup(QueryGroup queryGroup) {
        if (this.shouldEmulateFetchClause(queryGroup)) {
            this.emulateFetchOffsetWithWindowFunctions(queryGroup, true);
        } else {
            super.visitQueryGroup(queryGroup);
        }
    }

    @Override
    public void visitQuerySpec(QuerySpec querySpec) {
        if (this.shouldEmulateFetchClause(querySpec)) {
            this.emulateFetchOffsetWithWindowFunctions(querySpec, true);
        } else {
            super.visitQuerySpec(querySpec);
        }
    }

    @Override
    public void visitOffsetFetchClause(QueryPart queryPart) {
        if (!this.isRowNumberingCurrentQueryPart()) {
            if (this.getDialect().supportsFetchClause(FetchClauseType.ROWS_ONLY)) {
                this.renderOffsetFetchClause(queryPart, true);
            } else {
                this.renderLimitOffsetClause(queryPart);
            }
        }
    }

    @Override
    protected boolean supportsRecursiveSearchClause() {
        return this.getDialect().getVersion().isSameOrAfter(14);
    }

    @Override
    protected boolean supportsRecursiveCycleClause() {
        return this.getDialect().getVersion().isSameOrAfter(14);
    }

    @Override
    protected boolean supportsRecursiveCycleUsingClause() {
        return this.getDialect().getVersion().isSameOrAfter(14);
    }

    @Override
    protected void renderStandardCycleClause(CteStatement cte) {
        super.renderStandardCycleClause(cte);
        if (cte.getCycleMarkColumn() != null && cte.getCyclePathColumn() == null && this.supportsRecursiveCycleUsingClause()) {
            this.appendSql(" using ");
            this.appendSql(this.determineCyclePathColumnName(cte));
        }
    }

    @Override
    protected void renderPartitionItem(Expression expression) {
        if (expression instanceof Literal) {
            this.appendSql("()");
        } else if (expression instanceof Summarization) {
            Summarization summarization = (Summarization)expression;
            this.appendSql(summarization.getKind().sqlText());
            this.appendSql('(');
            this.renderCommaSeparated(summarization.getGroupings());
            this.appendSql(')');
        } else {
            expression.accept(this);
        }
    }

    @Override
    public void visitLikePredicate(LikePredicate likePredicate) {
        likePredicate.getMatchExpression().accept(this);
        if (likePredicate.isNegated()) {
            this.appendSql(" not");
        }
        if (likePredicate.isCaseSensitive()) {
            this.appendSql(" like ");
        } else {
            this.appendSql(' ');
            this.appendSql(this.getDialect().getCaseInsensitiveLike());
            this.appendSql(' ');
        }
        likePredicate.getPattern().accept(this);
        if (likePredicate.getEscapeCharacter() != null) {
            this.appendSql(" escape ");
            likePredicate.getEscapeCharacter().accept(this);
        } else {
            this.appendSql(" escape ''");
        }
    }

    @Override
    public void visitBinaryArithmeticExpression(BinaryArithmeticExpression arithmeticExpression) {
        this.appendSql('(');
        this.visitArithmeticOperand(arithmeticExpression.getLeftHandOperand());
        this.appendSql(arithmeticExpression.getOperator().getOperatorSqlTextString());
        this.visitArithmeticOperand(arithmeticExpression.getRightHandOperand());
        this.appendSql(')');
    }
}

