/*
 * Decompiled with CFR 0.152.
 */
package javax.help;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.net.URL;
import java.util.Vector;
import javax.help.HelpSet;
import javax.help.InvalidHelpSetContextException;
import javax.help.Map;
import javax.help.TextHelpModel;
import javax.help.event.EventListenerList;
import javax.help.event.HelpModelEvent;
import javax.help.event.HelpModelListener;
import javax.help.event.TextHelpModelEvent;
import javax.help.event.TextHelpModelListener;

public class DefaultHelpModel
implements TextHelpModel,
Serializable {
    private HelpSet helpset;
    private Map.ID currentID;
    private URL currentURL;
    private String navID;
    private Vector highlights = new Vector();
    private String title;
    protected EventListenerList listenerList = new EventListenerList();
    protected EventListenerList textListenerList = new EventListenerList();
    protected PropertyChangeSupport changes = new PropertyChangeSupport(this);
    private static boolean debug = false;
    static /* synthetic */ Class class$javax$help$event$HelpModelListener;
    static /* synthetic */ Class class$javax$help$event$TextHelpModelListener;

    public DefaultHelpModel(HelpSet helpSet) {
        this.helpset = helpSet;
    }

    public void addHelpModelListener(HelpModelListener helpModelListener) {
        DefaultHelpModel.debug("addHelpModelListener: ");
        DefaultHelpModel.debug("  l:" + helpModelListener);
        if (debug) {
            try {
                throw new Exception("");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.listenerList.add(class$javax$help$event$HelpModelListener != null ? class$javax$help$event$HelpModelListener : (class$javax$help$event$HelpModelListener = DefaultHelpModel.class$("javax.help.event.HelpModelListener")), helpModelListener);
    }

    public void addHighlight(int n, int n2) {
        DefaultHelpModel.debug("addHighlight(" + n + ", " + n2 + ")");
        this.highlights.addElement(new DefaultHighlight(n, n2));
        this.fireHighlightsChanged(this);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes.addPropertyChangeListener(propertyChangeListener);
    }

    public void addTextHelpModelListener(TextHelpModelListener textHelpModelListener) {
        DefaultHelpModel.debug("addTextHelpModelListener: ");
        DefaultHelpModel.debug("  l:" + textHelpModelListener);
        if (debug) {
            try {
                throw new Exception("");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.textListenerList.add(class$javax$help$event$TextHelpModelListener != null ? class$javax$help$event$TextHelpModelListener : (class$javax$help$event$TextHelpModelListener = DefaultHelpModel.class$("javax.help.event.TextHelpModelListener")), textHelpModelListener);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static void debug(String string) {
        if (debug) {
            System.err.println("DefaultHelpModel: " + string);
        }
    }

    protected void fireHighlightsChanged(Object object) {
        Object[] objectArray = this.textListenerList.getListenerList();
        TextHelpModelEvent textHelpModelEvent = null;
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$javax$help$event$TextHelpModelListener != null ? class$javax$help$event$TextHelpModelListener : DefaultHelpModel.class$("javax.help.event.TextHelpModelListener"))) {
                if (textHelpModelEvent == null) {
                    textHelpModelEvent = new TextHelpModelEvent(object);
                }
                DefaultHelpModel.debug("fireHighlightsChanged: ");
                DefaultHelpModel.debug("  " + objectArray[n + 1]);
                DefaultHelpModel.debug("  " + textHelpModelEvent);
                ((TextHelpModelListener)objectArray[n + 1]).highlightsChanged(textHelpModelEvent);
            }
            n -= 2;
        }
    }

    protected void fireIDChanged(Object object, Map.ID iD, URL uRL) {
        Object[] objectArray = this.listenerList.getListenerList();
        HelpModelEvent helpModelEvent = null;
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$javax$help$event$HelpModelListener != null ? class$javax$help$event$HelpModelListener : DefaultHelpModel.class$("javax.help.event.HelpModelListener"))) {
                if (helpModelEvent == null) {
                    helpModelEvent = new HelpModelEvent(object, iD, uRL);
                }
                DefaultHelpModel.debug("fireIDChanged: ");
                DefaultHelpModel.debug("  " + objectArray[n + 1]);
                DefaultHelpModel.debug("  " + helpModelEvent);
                ((HelpModelListener)objectArray[n + 1]).idChanged(helpModelEvent);
            }
            n -= 2;
        }
    }

    public Map.ID getCurrentID() {
        return this.currentID;
    }

    public URL getCurrentURL() {
        return this.currentURL;
    }

    public String getDocumentTitle() {
        return this.title;
    }

    public HelpSet getHelpSet() {
        return this.helpset;
    }

    public TextHelpModel.Highlight[] getHighlights() {
        Object[] objectArray = new DefaultHighlight[this.highlights.size()];
        this.highlights.copyInto(objectArray);
        return objectArray;
    }

    public void removeAllHighlights() {
        DefaultHelpModel.debug("removeAllHighlights");
        this.highlights.setSize(0);
        this.fireHighlightsChanged(this);
    }

    public void removeHelpModelListener(HelpModelListener helpModelListener) {
        this.listenerList.remove(class$javax$help$event$HelpModelListener != null ? class$javax$help$event$HelpModelListener : (class$javax$help$event$HelpModelListener = DefaultHelpModel.class$("javax.help.event.HelpModelListener")), helpModelListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes.removePropertyChangeListener(propertyChangeListener);
    }

    public void removeTextHelpModelListener(TextHelpModelListener textHelpModelListener) {
        this.textListenerList.remove(class$javax$help$event$TextHelpModelListener != null ? class$javax$help$event$TextHelpModelListener : (class$javax$help$event$TextHelpModelListener = DefaultHelpModel.class$("javax.help.event.TextHelpModelListener")), textHelpModelListener);
    }

    public void setCurrentID(Map.ID iD) throws InvalidHelpSetContextException {
        if (iD == null) {
            iD = this.helpset.getHomeID();
        }
        if (iD == null || iD.equals(this.currentID)) {
            return;
        }
        String string = iD.id;
        HelpSet helpSet = iD.hs;
        if (!this.helpset.contains(helpSet)) {
            throw new InvalidHelpSetContextException("Wrong context", this.helpset, helpSet);
        }
        Map map = this.helpset.getCombinedMap();
        this.currentID = iD;
        try {
            Object object;
            URL uRL;
            Map.ID iD2 = iD;
            if (helpSet == this.helpset) {
                uRL = map.getURLFromID(iD);
            } else {
                object = helpSet.getLocalMap();
                uRL = object.getURLFromID(iD);
            }
            if (this.currentURL != null && this.currentURL.equals(uRL)) {
                object = this.currentURL.getRef();
                String string2 = uRL.getRef();
                if (object == null && string2 == null) {
                    return;
                }
                if (object != null && string2 != null && ((String)object).compareTo(string2) == 0) {
                    return;
                }
            }
            this.currentURL = uRL;
        }
        catch (Exception exception) {
            this.currentURL = null;
        }
        this.highlights.setSize(0);
        this.fireIDChanged(this, this.currentID, this.currentURL);
    }

    public void setCurrentURL(URL uRL) {
        if (uRL != null && this.currentURL != null && this.currentURL.equals(uRL)) {
            return;
        }
        Map.ID iD = this.helpset.getCombinedMap().getIDFromURL(uRL);
        this.currentID = iD != null && !iD.equals(this.currentID) ? iD : null;
        this.currentURL = uRL;
        this.highlights.setSize(0);
        this.fireIDChanged(this, this.currentID, this.currentURL);
    }

    public void setDocumentTitle(String string) {
        String string2 = this.title;
        this.title = string;
        this.changes.firePropertyChange("documentTitle", string2, string);
    }

    public void setHelpSet(HelpSet helpSet) {
        HelpSet helpSet2 = this.helpset;
        this.helpset = helpSet;
        this.changes.firePropertyChange("helpSet", helpSet2, helpSet);
    }

    public void setHighlights(TextHelpModel.Highlight[] highlightArray) {
        this.highlights.setSize(0);
        if (highlightArray == null) {
            return;
        }
        int n = 0;
        while (n < highlightArray.length) {
            this.highlights.addElement(new DefaultHighlight(highlightArray[n].getStartOffset(), highlightArray[n].getEndOffset()));
            ++n;
        }
        if (this.highlights.size() > 0) {
            this.fireHighlightsChanged(this);
        }
    }

    public static class DefaultHighlight
    implements TextHelpModel.Highlight {
        public int start;
        public int end;

        public DefaultHighlight(int n, int n2) {
            if (n < 0) {
                throw new IllegalArgumentException("start");
            }
            if (n2 < 0) {
                throw new IllegalArgumentException("end");
            }
            this.start = n;
            this.end = n2;
        }

        public int getEndOffset() {
            return this.end;
        }

        public int getStartOffset() {
            return this.start;
        }
    }
}

