/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.protocol;

import java.sql.SQLException;
import java.sql.SQLNonTransientConnectionException;
import java.sql.SQLTransientConnectionException;
import java.util.List;
import java.util.concurrent.Callable;
import org.mariadb.jdbc.internal.com.read.dao.Results;
import org.mariadb.jdbc.internal.com.send.parameters.ParameterHolder;
import org.mariadb.jdbc.internal.protocol.AbstractMultiSend;
import org.mariadb.jdbc.internal.protocol.AsyncMultiReadResult;
import org.mariadb.jdbc.internal.protocol.Protocol;
import org.mariadb.jdbc.internal.util.BulkStatus;
import org.mariadb.jdbc.internal.util.SqlStates;
import org.mariadb.jdbc.internal.util.dao.PrepareResult;

public class AsyncMultiRead
implements Callable<AsyncMultiReadResult> {
    private final BulkStatus status;
    private final int sendCmdInitialCounter;
    private final Protocol protocol;
    private final AbstractMultiSend bulkSend;
    private final List<ParameterHolder[]> parametersList;
    private final List<String> queries;
    private final Results results;
    private final int paramCount;
    private final AsyncMultiReadResult asyncMultiReadResult;

    public AsyncMultiRead(BulkStatus status, Protocol protocol, AbstractMultiSend bulkSend, int paramCount, Results results, List<ParameterHolder[]> parametersList, List<String> queries, PrepareResult prepareResult) {
        this.status = status;
        this.sendCmdInitialCounter = status.sendCmdCounter - 1;
        this.protocol = protocol;
        this.bulkSend = bulkSend;
        this.paramCount = paramCount;
        this.results = results;
        this.parametersList = parametersList;
        this.queries = queries;
        this.asyncMultiReadResult = new AsyncMultiReadResult(prepareResult);
    }

    @Override
    public AsyncMultiReadResult call() throws Exception {
        int initialTimeout = this.protocol.getTimeout();
        if (initialTimeout != 0) {
            this.protocol.changeSocketSoTimeout(0);
        }
        int counter = 0;
        block2: while (!this.status.sendEnded || counter < this.status.sendSubCmdCounter) {
            while (counter < this.status.sendSubCmdCounter) {
                block7: {
                    try {
                        this.protocol.getResult(this.results);
                    }
                    catch (SQLException qex) {
                        if (qex instanceof SQLNonTransientConnectionException || qex instanceof SQLTransientConnectionException) {
                            this.asyncMultiReadResult.setException(qex);
                            break block2;
                        }
                        if (this.asyncMultiReadResult.getException() != null) break block7;
                        this.asyncMultiReadResult.setException(this.bulkSend.handleResultException(qex, this.results, this.parametersList, this.queries, counter, this.sendCmdInitialCounter, this.paramCount, this.asyncMultiReadResult.getPrepareResult()));
                    }
                }
                ++counter;
                if (!Thread.currentThread().isInterrupted()) continue;
                this.asyncMultiReadResult.setException(new SQLException("Interrupted reading responses ", SqlStates.INTERRUPTED_EXCEPTION.getSqlState(), -1));
                continue block2;
            }
        }
        if (initialTimeout != 0) {
            this.protocol.changeSocketSoTimeout(initialTimeout);
        }
        return this.asyncMultiReadResult;
    }
}

