/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.cc.impl.serialize;

import java.io.File;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.classpath.DefaultClassPath;
import org.gradle.internal.classpath.TransformedClassPath;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.graph.CombinatorsKt;
import org.gradle.internal.serialize.graph.WriteContext;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0000\u001a\f\u0010\u0003\u001a\u00020\u0001*\u00020\u0002H\u0002\u001a\f\u0010\u0004\u001a\u00020\u0001*\u00020\u0002H\u0002\u001a\u0014\u0010\u0005\u001a\u00020\u0006*\u00020\u00072\u0006\u0010\b\u001a\u00020\u0001H\u0000\u001a\u0014\u0010\t\u001a\u00020\u0006*\u00020\u00072\u0006\u0010\b\u001a\u00020\u0001H\u0002\u001a\u0014\u0010\n\u001a\u00020\u0006*\u00020\u00072\u0006\u0010\b\u001a\u00020\u000bH\u0002\u00a8\u0006\f"}, d2={"readClassPath", "Lorg/gradle/internal/classpath/ClassPath;", "Lorg/gradle/internal/serialize/Decoder;", "readDefaultClassPath", "readTransformedClassPath", "writeClassPath", "", "Lorg/gradle/internal/serialize/graph/WriteContext;", "classPath", "writeDefaultClassPath", "writeTransformedClassPath", "Lorg/gradle/internal/classpath/TransformedClassPath;", "configuration-cache"})
@SourceDebugExtension(value={"SMAP\nClassPathEncodingExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClassPathEncodingExtensions.kt\norg/gradle/internal/cc/impl/serialize/ClassPathEncodingExtensionsKt\n+ 2 Combinators.kt\norg/gradle/internal/serialize/graph/CombinatorsKt\n*L\n1#1,91:1\n260#2,11:92\n260#2,11:103\n*S KotlinDebug\n*F\n+ 1 ClassPathEncodingExtensions.kt\norg/gradle/internal/cc/impl/serialize/ClassPathEncodingExtensionsKt\n*L\n45#1:92,11\n53#1:103,11\n*E\n"})
public final class ClassPathEncodingExtensionsKt {
    public static final void writeClassPath(@NotNull WriteContext $this$writeClassPath, @NotNull ClassPath classPath) {
        Intrinsics.checkNotNullParameter((Object)$this$writeClassPath, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)classPath, (String)"classPath");
        if (classPath instanceof TransformedClassPath) {
            $this$writeClassPath.writeBoolean(true);
            ClassPathEncodingExtensionsKt.writeTransformedClassPath($this$writeClassPath, (TransformedClassPath)classPath);
        } else {
            $this$writeClassPath.writeBoolean(false);
            ClassPathEncodingExtensionsKt.writeDefaultClassPath($this$writeClassPath, classPath);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void writeDefaultClassPath(WriteContext $this$writeDefaultClassPath, ClassPath classPath) {
        void $this$writeCollection$iv;
        WriteContext writeContext = $this$writeDefaultClassPath;
        List list = classPath.getAsFiles();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"classPath.asFiles");
        Collection collection$iv = list;
        boolean $i$f$writeCollection = false;
        int size$iv = collection$iv.size();
        $this$writeCollection$iv.writeSmallInt(size$iv);
        int totalWritten$iv = 0;
        for (Object element$iv : collection$iv) {
            File it2 = (File)element$iv;
            boolean bl = false;
            Encoder encoder = (Encoder)$this$writeDefaultClassPath;
            Intrinsics.checkNotNullExpressionValue((Object)it2, (String)"it");
            CombinatorsKt.writeFile((Encoder)encoder, (File)it2);
            ++totalWritten$iv;
        }
        if (size$iv != totalWritten$iv) {
            CombinatorsKt.reportCollectionWriteFailure((WriteContext)$this$writeCollection$iv, (String)"collection", (int)size$iv, (int)totalWritten$iv, (int)collection$iv.size());
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void writeTransformedClassPath(WriteContext $this$writeTransformedClassPath, TransformedClassPath classPath) {
        void $this$writeCollection$iv;
        WriteContext writeContext = $this$writeTransformedClassPath;
        List list = classPath.getAsFiles();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"classPath.asFiles");
        Iterable iterable = list;
        List list2 = classPath.getAsTransformedFiles();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"classPath.asTransformedFiles");
        Collection collection$iv = CollectionsKt.zip((Iterable)iterable, (Iterable)list2);
        boolean $i$f$writeCollection = false;
        int size$iv = collection$iv.size();
        $this$writeCollection$iv.writeSmallInt(size$iv);
        int totalWritten$iv = 0;
        for (Object element$iv : collection$iv) {
            Pair it2 = (Pair)element$iv;
            boolean bl = false;
            Encoder encoder = (Encoder)$this$writeTransformedClassPath;
            Object object = it2.getFirst();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"it.first");
            CombinatorsKt.writeFile((Encoder)encoder, (File)((File)object));
            Encoder encoder2 = (Encoder)$this$writeTransformedClassPath;
            Object object2 = it2.getSecond();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"it.second");
            CombinatorsKt.writeFile((Encoder)encoder2, (File)((File)object2));
            ++totalWritten$iv;
        }
        if (size$iv != totalWritten$iv) {
            CombinatorsKt.reportCollectionWriteFailure((WriteContext)$this$writeCollection$iv, (String)"collection", (int)size$iv, (int)totalWritten$iv, (int)collection$iv.size());
        }
    }

    @NotNull
    public static final ClassPath readClassPath(@NotNull Decoder $this$readClassPath) {
        Intrinsics.checkNotNullParameter((Object)$this$readClassPath, (String)"<this>");
        boolean isTransformed = $this$readClassPath.readBoolean();
        return isTransformed ? ClassPathEncodingExtensionsKt.readTransformedClassPath($this$readClassPath) : ClassPathEncodingExtensionsKt.readDefaultClassPath($this$readClassPath);
    }

    private static final ClassPath readDefaultClassPath(Decoder $this$readDefaultClassPath) {
        int size = $this$readDefaultClassPath.readSmallInt();
        DefaultClassPath.Builder builder = DefaultClassPath.builderWithExactSize((int)size);
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"builderWithExactSize(size)");
        DefaultClassPath.Builder builder2 = builder;
        int n = 0;
        while (n < size) {
            int it2 = n++;
            boolean bl = false;
            builder2.add(CombinatorsKt.readFile((Decoder)$this$readDefaultClassPath));
        }
        ClassPath classPath = builder2.build();
        Intrinsics.checkNotNullExpressionValue((Object)classPath, (String)"builder.build()");
        return classPath;
    }

    private static final ClassPath readTransformedClassPath(Decoder $this$readTransformedClassPath) {
        int size = $this$readTransformedClassPath.readSmallInt();
        TransformedClassPath.Builder builder = TransformedClassPath.builderWithExactSize((int)size);
        int n = 0;
        while (n < size) {
            int it2 = n++;
            boolean bl = false;
            builder.add(CombinatorsKt.readFile((Decoder)$this$readTransformedClassPath), CombinatorsKt.readFile((Decoder)$this$readTransformedClassPath));
        }
        TransformedClassPath transformedClassPath = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)transformedClassPath, (String)"builder.build()");
        return (ClassPath)transformedClassPath;
    }
}

