/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine.support.hierarchical;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.support.hierarchical.Node;
import org.junit.platform.engine.support.hierarchical.NopLock;
import org.junit.platform.engine.support.hierarchical.ResourceLock;

class NodeExecutionAdvisor {
    private final Map<TestDescriptor, Node.ExecutionMode> forcedDescendantExecutionModeByTestDescriptor = new HashMap<TestDescriptor, Node.ExecutionMode>();
    private final Map<TestDescriptor, ResourceLock> resourceLocksByTestDescriptor = new HashMap<TestDescriptor, ResourceLock>();

    NodeExecutionAdvisor() {
    }

    void forceDescendantExecutionMode(TestDescriptor testDescriptor, Node.ExecutionMode executionMode) {
        this.forcedDescendantExecutionModeByTestDescriptor.put(testDescriptor, executionMode);
    }

    void useResourceLock(TestDescriptor testDescriptor, ResourceLock resourceLock) {
        this.resourceLocksByTestDescriptor.put(testDescriptor, resourceLock);
    }

    Optional<Node.ExecutionMode> getForcedExecutionMode(TestDescriptor testDescriptor) {
        return testDescriptor.getParent().flatMap(this::lookupExecutionModeForcedByAncestor);
    }

    private Optional<Node.ExecutionMode> lookupExecutionModeForcedByAncestor(TestDescriptor testDescriptor) {
        Node.ExecutionMode value = this.forcedDescendantExecutionModeByTestDescriptor.get(testDescriptor);
        if (value != null) {
            return Optional.of(value);
        }
        return testDescriptor.getParent().flatMap(this::lookupExecutionModeForcedByAncestor);
    }

    ResourceLock getResourceLock(TestDescriptor testDescriptor) {
        return this.resourceLocksByTestDescriptor.getOrDefault(testDescriptor, NopLock.INSTANCE);
    }
}

