/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.gradle.api.Transformer;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.internal.provider.TransformBackedProvider;
import org.gradle.api.internal.provider.ValueSupplier;

public class MappingProvider<OUT, IN>
extends TransformBackedProvider<OUT, IN> {
    public MappingProvider(@Nullable Class<OUT> type, ProviderInternal<? extends IN> provider, Transformer<? extends OUT, ? super IN> transformer) {
        super(type, provider, transformer);
    }

    @Override
    public boolean calculatePresence(ValueSupplier.ValueConsumer consumer) {
        return this.provider.calculatePresence(consumer);
    }

    @Override
    public ValueSupplier.ExecutionTimeValue<? extends OUT> calculateExecutionTimeValue() {
        ValueSupplier.ExecutionTimeValue value = this.provider.calculateExecutionTimeValue();
        if (value.isChangingValue()) {
            return ValueSupplier.ExecutionTimeValue.changingValue(new MappingProvider(this.type, value.getChangingValue(), this.transformer));
        }
        return ValueSupplier.ExecutionTimeValue.value(this.mapValue(value.toValue()));
    }

    @Override
    @Nonnull
    protected ValueSupplier.Value<OUT> mapValue(ValueSupplier.Value<? extends IN> value) {
        ValueSupplier.Value transformedValue = super.mapValue(value);
        if (!value.isMissing() && transformedValue.isMissing()) {
            throw new IllegalStateException("The transformer in MappingProvider must always return a value");
        }
        return transformedValue;
    }

    @Override
    protected void beforeRead() {
    }

    @Override
    public String toString() {
        return "map(" + (this.type == null ? "" : this.type.getName() + " ") + this.provider + " " + this.transformer + ")";
    }
}

