/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.mappingoutput;

import java.util.List;
import org.pentaho.di.core.RowSet;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.mapping.MappingValueRename;
import org.pentaho.di.trans.steps.mappingoutput.MappingOutputData;
import org.pentaho.di.trans.steps.mappingoutput.MappingOutputMeta;
import org.pentaho.di.trans.steps.mappingoutput.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappingOutput
extends BaseStep
implements StepInterface {
    private MappingOutputMeta meta;
    private MappingOutputData data;

    public MappingOutput(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (MappingOutputMeta)smi;
        this.data = (MappingOutputData)sdi;
        Object[] r = this.getRow();
        if (r == null) {
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.first = false;
            this.data.outputRowMeta = this.getInputRowMeta().clone();
            this.meta.setOutputValueRenames(this.data.outputValueRenames);
            this.meta.setInputValueRenames(this.data.inputValueRenames);
            this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this);
            int totalsleep = 0;
            while (!this.isStopped() && !this.getTrans().getParentTrans().isRunning()) {
                try {
                    totalsleep += 10;
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    this.stopAll();
                }
                if (totalsleep <= 60000) continue;
                throw new KettleException(Messages.getString("MappingOutput.Exception.UnableToConnectWithParentMapping", "" + totalsleep / 1000));
            }
            if (this.data.targetSteps == null) {
                this.log.logDetailed(this.toString(), Messages.getString("MappingOutput.NoTargetStepSpecified", this.getStepname()), new Object[0]);
            }
        }
        this.putRow(this.data.outputRowMeta, r);
        if (this.checkFeedback(this.getLinesRead())) {
            this.logBasic(Messages.getString("MappingOutput.Log.LineNumber") + this.getLinesRead());
        }
        return true;
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (MappingOutputMeta)smi;
        this.data = (MappingOutputData)sdi;
        return super.init(smi, sdi);
    }

    public void setConnectorSteps(StepInterface[] targetSteps, List<MappingValueRename> inputValueRenames, List<MappingValueRename> outputValueRenames) {
        for (int i = 0; i < targetSteps.length; ++i) {
            RowSet rowSet = new RowSet(this.getTransMeta().getSizeRowset());
            rowSet.setThreadNameFromToCopy(this.getStepname(), 0, targetSteps[i].getStepname(), 0);
            this.getOutputRowSets().add(rowSet);
            targetSteps[i].getInputRowSets().add(rowSet);
        }
        this.data.inputValueRenames = inputValueRenames;
        this.data.outputValueRenames = outputValueRenames;
        this.data.targetSteps = targetSteps;
    }

    @Override
    public void run() {
        BaseStep.runStepThread(this, this.meta, this.data);
    }
}

